/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.mongodb.database;

import com.mongodb.ConnectionString;
import com.mongodb.MongoCredential;
import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoDatabase;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.sql.Driver;
import java.util.Collections;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import liquibase.GlobalConfiguration;
import liquibase.Scope;
import liquibase.exception.DatabaseException;
import liquibase.exception.UnexpectedLiquibaseException;
import liquibase.ext.mongodb.configuration.MongoConfiguration;
import liquibase.ext.mongodb.database.MongoClientDriver;
import liquibase.ext.mongodb.statement.BsonUtils;
import liquibase.logging.Logger;
import liquibase.nosql.database.AbstractNoSqlConnection;
import liquibase.util.LiquibaseUtil;
import liquibase.util.StringUtil;
import lombok.Generated;

public class MongoConnection
extends AbstractNoSqlConnection {
    public static final int DEFAULT_PORT = 27017;
    public static final String MONGO_PREFIX = "mongodb://";
    public static final String MONGO_DNS_PREFIX = "mongodb+srv://";
    private ConnectionString connectionString;
    protected MongoClient mongoClient;
    protected MongoDatabase mongoDatabase;

    @Override
    public boolean supports(String url) {
        if (url == null) {
            return false;
        }
        boolean isMongodbConnection = url.toLowerCase().startsWith("mongodb");
        MongoConnection.showErrorMessageIfSomeRequiredDependenciesAreNotPresent(isMongodbConnection);
        return isMongodbConnection;
    }

    public static void showErrorMessageIfSomeRequiredDependenciesAreNotPresent(boolean isMongodbConnection) {
        if (isMongodbConnection) {
            String errorMessagePrefix = "The required dependencies (JAR files) are not available on the classpath:";
            String errorMessage = "The required dependencies (JAR files) are not available on the classpath:";
            try {
                Class.forName("com.mongodb.ConnectionString");
            }
            catch (ClassNotFoundException e) {
                errorMessage = errorMessage + "\n- mongodb-driver-core.jar";
            }
            try {
                Class.forName("com.mongodb.client.MongoClients");
            }
            catch (ClassNotFoundException e) {
                errorMessage = errorMessage + "\n- mongodb-driver-sync.jar";
            }
            try {
                Class.forName("org.bson.Transformer");
            }
            catch (ClassNotFoundException e) {
                errorMessage = errorMessage + "\n- bson.jar";
            }
            if (!errorMessage.equals("The required dependencies (JAR files) are not available on the classpath:")) {
                errorMessage = errorMessage + "\nDownload the required dependencies and place them in the 'liquibase/lib' folder";
                throw new UnexpectedLiquibaseException(errorMessage);
            }
        }
    }

    public String getCatalog() throws DatabaseException {
        try {
            return this.mongoDatabase.getName();
        }
        catch (Exception e) {
            throw new DatabaseException((Throwable)e);
        }
    }

    public String getDatabaseProductName() throws DatabaseException {
        return "MongoDB";
    }

    public String getURL() {
        return String.join((CharSequence)",", Optional.ofNullable(this.connectionString).map(ConnectionString::getHosts).orElse(Collections.emptyList()));
    }

    public String getVisibleUrl() {
        return Optional.ofNullable(this.connectionString).map(ConnectionString::getConnectionString).orElseGet(() -> super.getVisibleUrl());
    }

    public String getConnectionUserName() {
        return Optional.ofNullable(this.connectionString).map(ConnectionString::getCredential).map(MongoCredential::getUserName).orElse("");
    }

    public boolean isClosed() throws DatabaseException {
        return Objects.isNull(this.mongoClient);
    }

    public void open(String url, Driver driverObject, Properties driverProperties) throws DatabaseException {
        try {
            String urlWithCredentials = this.injectCredentials(StringUtil.trimToEmpty((String)url), driverProperties);
            this.connectionString = new ConnectionString(this.resolveRetryWrites(urlWithCredentials));
            this.mongoClient = ((MongoClientDriver)driverObject).connect(this.connectionString, this.getAppName(driverProperties, false));
            String database = this.connectionString.getDatabase();
            if (database == null) {
                throw new IllegalArgumentException("Database not specified in URL");
            }
            this.mongoDatabase = this.mongoClient.getDatabase(Objects.requireNonNull(database)).withCodecRegistry(BsonUtils.uuidCodecRegistry());
        }
        catch (Exception e) {
            throw new DatabaseException("Could not open connection to database: " + Optional.ofNullable(this.connectionString).map(ConnectionString::getDatabase).orElse(url), (Throwable)e);
        }
    }

    protected String getAppName(Properties driverProperties, boolean isProExt) {
        if (driverProperties == null) {
            return "Liquibase";
        }
        if (driverProperties.getProperty("appName") != null) {
            return driverProperties.getProperty("appName");
        }
        String appType = isProExt ? "PRO_" : "OSS_";
        String extType = isProExt ? "_ProExt_" : "_OssExt_";
        String buildVersion = LiquibaseUtil.getBuildVersion();
        return "Liquibase_" + appType + buildVersion + extType + this.getVersion();
    }

    protected String getVersion() {
        String string;
        block10: {
            String classPath;
            String className = this.getClass().getSimpleName() + ".class";
            URL url = this.getClass().getResource(className);
            String string2 = classPath = url == null ? "" : url.toString();
            if (!classPath.startsWith("jar")) {
                return "LOCAL_BUILD";
            }
            InputStream is = new URL(classPath.substring(0, classPath.indexOf("!")) + "!/META-INF/MANIFEST.MF").openStream();
            try {
                Attributes attributes = new Manifest(is).getMainAttributes();
                String version = attributes.getValue("Implementation-Version");
                if (version == null) {
                    version = attributes.getValue("Bundle-Version");
                }
                string = version;
                if (is == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    Scope.getCurrentScope().getLog(this.getClass()).warning("Could not extract version within classPath = " + classPath);
                    return null;
                }
            }
            is.close();
        }
        return string;
    }

    private String resolveRetryWrites(String url) {
        Logger log = Scope.getCurrentScope().getLog(this.getClass());
        if (MongoConfiguration.RETRY_WRITES.getCurrentConfiguredValue().wasDefaultValueUsed()) {
            return url;
        }
        String retryWritesConfigValue = String.valueOf(MongoConfiguration.RETRY_WRITES.getCurrentValue());
        if (url.contains("retryWrites")) {
            if (url.contains("retryWrites=" + retryWritesConfigValue)) {
                log.info("retryWrites query param is already set to" + retryWritesConfigValue + ", no need to override it");
            } else {
                log.warning(String.format("overriding retryWrites query param value to '%s'", retryWritesConfigValue));
                url = url.replaceFirst("\\bretryWrites=.*?(&|$)", "retryWrites=" + retryWritesConfigValue + "$1");
            }
        } else {
            log.info("Adding retryWrites=" + retryWritesConfigValue + " to URL");
            url = url + (url.contains("?") ? "&" : "?") + "retryWrites=" + retryWritesConfigValue;
        }
        return url;
    }

    private String injectCredentials(String url, Properties driverProperties) {
        if (Objects.nonNull(driverProperties)) {
            Optional<String> user = Optional.ofNullable(StringUtil.trimToNull((String)driverProperties.getProperty("user"))).map(MongoConnection::encode);
            Optional<String> password = Optional.ofNullable(StringUtil.trimToNull((String)driverProperties.getProperty("password"))).map(MongoConnection::encode);
            if (user.isPresent()) {
                String mongoPrefix = url.startsWith(MONGO_DNS_PREFIX) ? MONGO_DNS_PREFIX : MONGO_PREFIX;
                return mongoPrefix + user.get() + password.map(p -> ":" + p).orElse("") + "@" + url.substring(mongoPrefix.length());
            }
        }
        return url;
    }

    private static String encode(String s) {
        try {
            return URLEncoder.encode(s, ((Charset)GlobalConfiguration.FILE_ENCODING.getCurrentValue()).name());
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public void close() throws DatabaseException {
        try {
            if (!this.isClosed()) {
                this.mongoClient.close();
                this.mongoClient = null;
            }
        }
        catch (Exception e) {
            throw new DatabaseException((Throwable)e);
        }
    }

    @Generated
    public ConnectionString getConnectionString() {
        return this.connectionString;
    }

    @Generated
    public MongoClient getMongoClient() {
        return this.mongoClient;
    }

    @Generated
    public MongoDatabase getMongoDatabase() {
        return this.mongoDatabase;
    }

    @Generated
    public void setConnectionString(ConnectionString connectionString) {
        this.connectionString = connectionString;
    }

    @Generated
    public void setMongoClient(MongoClient mongoClient) {
        this.mongoClient = mongoClient;
    }

    @Generated
    public void setMongoDatabase(MongoDatabase mongoDatabase) {
        this.mongoDatabase = mongoDatabase;
    }

    @Generated
    public MongoConnection() {
    }
}

