/*
 * Decompiled with CFR 0.152.
 */
package liquibase.nosql.parser.json;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import liquibase.ContextExpression;
import liquibase.Labels;
import liquibase.Scope;
import liquibase.changelog.ChangeLogParameters;
import liquibase.changelog.DatabaseChangeLog;
import liquibase.database.Database;
import liquibase.exception.ChangeLogParseException;
import liquibase.ext.mongodb.database.MongoLiquibaseDatabase;
import liquibase.logging.Logger;
import liquibase.parser.ChangeLogParser;
import liquibase.parser.core.ParsedNode;
import liquibase.resource.ResourceAccessor;

public class JsonNoSqlChangeLogParser
implements ChangeLogParser {
    public static final String RAW_JSON_FIELD = "$rawJson";
    protected Logger log = Scope.getCurrentScope().getLog(this.getClass());
    protected ObjectMapper objectMapper = new JsonMapper();

    public int getPriority() {
        return 10;
    }

    public boolean supports(String changeLogFile, ResourceAccessor resourceAccessor) {
        Database database = Scope.getCurrentScope().getDatabase();
        if (database != null && !(database instanceof MongoLiquibaseDatabase)) {
            return false;
        }
        for (String extension : this.getSupportedFileExtensions()) {
            if (!changeLogFile.toLowerCase().endsWith("." + extension)) continue;
            return true;
        }
        return false;
    }

    protected String[] getSupportedFileExtensions() {
        return new String[]{"json"};
    }

    public Logger getLogger() {
        return this.log;
    }

    public DatabaseChangeLog parse(String physicalChangeLogLocation, ChangeLogParameters changeLogParameters, ResourceAccessor resourceAccessor) throws ChangeLogParseException {
        DatabaseChangeLog databaseChangeLog;
        block15: {
            InputStream changeLogStream = resourceAccessor.openStream(null, physicalChangeLogLocation);
            try {
                if (changeLogStream == null) {
                    throw new ChangeLogParseException(physicalChangeLogLocation + " does not exist");
                }
                JsonParser parser = this.objectMapper.createParser(changeLogStream);
                TreeNode parsedJson = this.objectMapper.readTree(parser);
                if (Objects.isNull(parsedJson) || parsedJson.size() == 0) {
                    throw new ChangeLogParseException("Empty file " + physicalChangeLogLocation);
                }
                DatabaseChangeLog changeLog = new DatabaseChangeLog(physicalChangeLogLocation);
                TreeNode rootList = parsedJson.get("databaseChangeLog");
                if (Objects.isNull(rootList)) {
                    throw new ChangeLogParseException("Could not find databaseChangeLog node");
                }
                if (!rootList.isArray()) {
                    throw new ChangeLogParseException("databaseChangeLog does not contain a list of entries. Each changeSet must begin ' - changeSet:'");
                }
                for (JsonNode obj : (ArrayNode)rootList) {
                    if (!obj.isObject() || !obj.has("property")) continue;
                    JsonNode property = obj.get("property");
                    ContextExpression context = new ContextExpression((String)Optional.ofNullable(property.get("context")).map(JsonNode::asText).orElse(null));
                    Labels labels = new Labels((String)Optional.ofNullable(property.get("labels")).map(JsonNode::asText).orElse(null));
                    Boolean global = this.getGlobalParam(property);
                    if (property.has("name")) {
                        String value = property.get("value").asText();
                        String dbms = Optional.ofNullable(property.get("dbms")).map(JsonNode::asText).orElse(null);
                        changeLogParameters.set(property.get("name").asText(), (Object)value, context, labels, dbms, global.booleanValue(), changeLog);
                        continue;
                    }
                    if (!property.has("file")) continue;
                    this.loadChangeLogParametersFromFile(changeLogParameters, resourceAccessor, changeLog, property, context, labels, global);
                }
                this.replaceParameters(parsedJson, changeLogParameters, changeLog);
                changeLog.setChangeLogParameters(changeLogParameters);
                ParsedNode databaseChangeLogNode = new ParsedNode(null, "databaseChangeLog");
                Map mapJson = (Map)this.objectMapper.convertValue((Object)parsedJson, (TypeReference)new TypeReference<Map<String, Object>>(){});
                databaseChangeLogNode.setValue(mapJson.get("databaseChangeLog"));
                changeLog.load(databaseChangeLogNode, resourceAccessor);
                databaseChangeLog = changeLog;
                if (changeLogStream == null) break block15;
            }
            catch (Throwable throwable) {
                try {
                    if (changeLogStream != null) {
                        try {
                            changeLogStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (ChangeLogParseException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new ChangeLogParseException("Error parsing " + physicalChangeLogLocation, (Throwable)e);
                }
            }
            changeLogStream.close();
        }
        return databaseChangeLog;
    }

    private void loadChangeLogParametersFromFile(ChangeLogParameters changeLogParameters, ResourceAccessor resourceAccessor, DatabaseChangeLog changeLog, JsonNode property, ContextExpression context, Labels labels, Boolean global) throws IOException {
        Properties props = new Properties();
        try (InputStream propertiesStream = resourceAccessor.openStream(null, property.get("file").asText());){
            if (propertiesStream == null) {
                this.getLogger().info("Could not open properties file " + property.get("file"));
            } else {
                props.load(propertiesStream);
                for (Map.Entry<Object, Object> entry : props.entrySet()) {
                    String dbms = Optional.ofNullable(property.get("dbms")).map(JsonNode::asText).orElse(null);
                    changeLogParameters.set(entry.getKey().toString(), (Object)entry.getValue().toString(), context, labels, dbms, global.booleanValue(), changeLog);
                }
            }
        }
    }

    private Boolean getGlobalParam(JsonNode property) {
        JsonNode globalObj = property.get("global");
        boolean global = globalObj == null ? true : globalObj.asBoolean();
        return global;
    }

    protected void replaceParameters(TreeNode obj, ChangeLogParameters changeLogParameters, DatabaseChangeLog changeLog) {
        if (obj.isObject()) {
            ObjectNode objectNode = (ObjectNode)obj;
            Iterator fields = objectNode.fields();
            while (fields.hasNext()) {
                Map.Entry entry = (Map.Entry)fields.next();
                if (((JsonNode)entry.getValue()).isValueNode()) {
                    objectNode.put((String)entry.getKey(), changeLogParameters.expandExpressions(((JsonNode)entry.getValue()).asText(), changeLog));
                    continue;
                }
                if (((JsonNode)entry.getValue()).isObject() && ((JsonNode)entry.getValue()).has(RAW_JSON_FIELD)) {
                    JsonNode jsonPayload = ((JsonNode)entry.getValue()).get(RAW_JSON_FIELD);
                    objectNode.put((String)entry.getKey(), changeLogParameters.expandExpressions(jsonPayload.toPrettyString(), changeLog));
                    continue;
                }
                this.replaceParameters((TreeNode)entry.getValue(), changeLogParameters, changeLog);
            }
        } else if (obj.isArray()) {
            ArrayNode arrayNode = (ArrayNode)obj;
            for (int i = 0; i < arrayNode.size(); ++i) {
                JsonNode child = arrayNode.get(i);
                if (child.isValueNode()) {
                    TextNode jsonNode = JsonNodeFactory.instance.textNode(changeLogParameters.expandExpressions(child.toString(), changeLog));
                    arrayNode.set(i, (JsonNode)jsonNode);
                    continue;
                }
                this.replaceParameters((TreeNode)child, changeLogParameters, changeLog);
            }
        }
    }
}

