/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.mongodb.statement;

import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import liquibase.ext.mongodb.database.MongoLiquibaseDatabase;
import liquibase.ext.mongodb.statement.AbstractRunCommandStatement;
import liquibase.ext.mongodb.statement.BsonUtils;
import liquibase.nosql.statement.NoSqlExecuteStatement;
import org.bson.Document;

public class CreateIndexStatement
extends AbstractRunCommandStatement
implements NoSqlExecuteStatement<MongoLiquibaseDatabase> {
    public static final String RUN_COMMAND_NAME = "createIndexes";
    private static final String KEY = "key";
    private static final String INDEXES = "indexes";

    public CreateIndexStatement(String collectionName, Document keys, Document options) {
        super(BsonUtils.toCommand(RUN_COMMAND_NAME, collectionName, CreateIndexStatement.combine(keys, options)));
    }

    public CreateIndexStatement(String collectionName, String keys, String options) {
        this(collectionName, BsonUtils.orEmptyDocument(keys), BsonUtils.orEmptyDocument(options));
    }

    @Override
    public String getRunCommandName() {
        return RUN_COMMAND_NAME;
    }

    private static Document combine(Document key, Document options) {
        Document indexDocument = new Document(KEY, (Object)key);
        if (Objects.nonNull(options)) {
            indexDocument.putAll((Map)options);
        }
        return new Document(INDEXES, Collections.singletonList(indexDocument));
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CreateIndexStatement)) {
            return false;
        }
        CreateIndexStatement other = (CreateIndexStatement)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof CreateIndexStatement;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        return result;
    }
}

