/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.mongodb.statement;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import liquibase.ext.mongodb.database.MongoLiquibaseDatabase;
import liquibase.ext.mongodb.statement.AbstractCollectionStatement;
import liquibase.nosql.statement.NoSqlQueryForListStatement;
import lombok.Generated;
import org.bson.Document;
import org.bson.conversions.Bson;

public class FindAllStatement
extends AbstractCollectionStatement
implements NoSqlQueryForListStatement<MongoLiquibaseDatabase, Document> {
    public static final String COMMAND_NAME = "find";
    private final Bson filter;
    private final Bson sort;

    public FindAllStatement(String collectionName) {
        this(collectionName, (Bson)new Document(), (Bson)new Document());
    }

    public FindAllStatement(String collectionName, Bson filter, Bson sort) {
        super(collectionName);
        this.filter = filter;
        this.sort = sort;
    }

    @Override
    public String getCommandName() {
        return COMMAND_NAME;
    }

    @Override
    public String toJs() {
        return "db." + this.getCollectionName() + "." + this.getCommandName() + "(" + (String)Optional.ofNullable(this.filter).map(Bson::toString).orElse(null) + ", " + (String)Optional.ofNullable(this.sort).map(Bson::toString).orElse(null) + ");";
    }

    @Override
    public List<Document> queryForList(MongoLiquibaseDatabase database) {
        ArrayList<Document> result = new ArrayList<Document>();
        database.getMongoDatabase().getCollection(this.collectionName, Document.class).find(this.filter).sort(this.sort).into(result);
        return result;
    }

    @Generated
    public Bson getFilter() {
        return this.filter;
    }

    @Generated
    public Bson getSort() {
        return this.sort;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FindAllStatement)) {
            return false;
        }
        FindAllStatement other = (FindAllStatement)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Bson this$filter = this.getFilter();
        Bson other$filter = other.getFilter();
        if (this$filter == null ? other$filter != null : !this$filter.equals(other$filter)) {
            return false;
        }
        Bson this$sort = this.getSort();
        Bson other$sort = other.getSort();
        return !(this$sort == null ? other$sort != null : !this$sort.equals(other$sort));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof FindAllStatement;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Bson $filter = this.getFilter();
        result = result * 59 + ($filter == null ? 43 : $filter.hashCode());
        Bson $sort = this.getSort();
        result = result * 59 + ($sort == null ? 43 : $sort.hashCode());
        return result;
    }
}

