/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.mongodb.change;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import liquibase.ChecksumVersion;
import liquibase.GlobalConfiguration;
import liquibase.Scope;
import liquibase.change.AbstractChange;
import liquibase.change.AbstractSQLChange;
import liquibase.change.CheckSum;
import liquibase.database.Database;
import liquibase.exception.UnexpectedLiquibaseException;
import liquibase.ext.mongodb.database.MongoLiquibaseDatabase;
import liquibase.util.StringUtil;

public abstract class AbstractMongoChange
extends AbstractChange {
    public boolean supports(Database database) {
        return database instanceof MongoLiquibaseDatabase;
    }

    public boolean generateStatementsVolatile(Database database) {
        return false;
    }

    public boolean generateRollbackStatementsVolatile(Database database) {
        return false;
    }

    CheckSum generateCheckSum(String ... texts) {
        CheckSum checkSum;
        ChecksumVersion version = Scope.getCurrentScope().getChecksumVersion();
        if (version.lowerOrEqualThan(ChecksumVersion.V8)) {
            return super.generateCheckSum();
        }
        String text = "";
        if (texts != null) {
            text = StringUtil.join((String[])texts, (String)"");
        }
        ByteArrayInputStream stream = new ByteArrayInputStream(text.getBytes((Charset)GlobalConfiguration.FILE_ENCODING.getCurrentValue()));
        try {
            checkSum = CheckSum.compute((InputStream)new AbstractSQLChange.NormalizingStream((InputStream)stream), (boolean)false);
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((InputStream)stream).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new UnexpectedLiquibaseException((Throwable)e);
            }
        }
        ((InputStream)stream).close();
        return checkSum;
    }
}

