/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.mongodb.lockservice;

import com.mongodb.MongoException;
import com.mongodb.client.model.Filters;
import com.mongodb.client.model.FindOneAndReplaceOptions;
import com.mongodb.client.model.ReturnDocument;
import java.util.Date;
import liquibase.ext.mongodb.database.MongoLiquibaseDatabase;
import liquibase.ext.mongodb.lockservice.MongoChangeLogLock;
import liquibase.ext.mongodb.lockservice.MongoChangeLogLockToDocumentConverter;
import liquibase.ext.mongodb.statement.AbstractCollectionStatement;
import liquibase.nosql.statement.NoSqlUpdateStatement;
import lombok.Generated;
import org.bson.conversions.Bson;

public class ReplaceChangeLogLockStatement
extends AbstractCollectionStatement
implements NoSqlUpdateStatement<MongoLiquibaseDatabase> {
    public static final String COMMAND_NAME = "updateLock";
    private static final Integer DUPLICATE_KEY_ERROR_CODE = 11000;
    private final boolean locked;

    public ReplaceChangeLogLockStatement(String collectionName, boolean locked) {
        super(collectionName);
        this.locked = locked;
    }

    @Override
    public String getCommandName() {
        return COMMAND_NAME;
    }

    @Override
    public String toJs() {
        return "db." + this.getCollectionName() + "." + this.getCommandName() + "(" + this.locked + ");";
    }

    @Override
    public int update(MongoLiquibaseDatabase database) {
        MongoChangeLogLock lock = new MongoChangeLogLock(1, new Date(), MongoChangeLogLock.formLockedBy(), this.locked);
        long documentCount = database.getMongoDatabase().getCollection(this.collectionName).countDocuments(Filters.eq((String)"_id", (Object)lock.getId()));
        if (documentCount == 0L) {
            return this.update(database, Filters.eq((String)"_id", (Object)lock.getId()), lock, true);
        }
        if (this.locked) {
            return this.update(database, Filters.and((Bson[])new Bson[]{Filters.eq((String)"_id", (Object)lock.getId()), Filters.eq((String)"locked", (Object)false)}), lock, false);
        }
        return this.update(database, Filters.and((Bson[])new Bson[]{Filters.eq((String)"_id", (Object)lock.getId()), Filters.eq((String)"locked", (Object)true), Filters.eq((String)"lockedBy", (Object)lock.getLockedBy())}), lock, false);
    }

    private int update(MongoLiquibaseDatabase database, Bson filters, MongoChangeLogLock lock, boolean upsert) {
        try {
            Object result = database.getMongoDatabase().getCollection(this.collectionName).findOneAndReplace(filters, (Object)new MongoChangeLogLockToDocumentConverter().toDocument(lock), new FindOneAndReplaceOptions().upsert(upsert).returnDocument(ReturnDocument.AFTER));
            return result != null ? 1 : 0;
        }
        catch (MongoException e) {
            if (e.getCode() == DUPLICATE_KEY_ERROR_CODE.intValue()) {
                return 0;
            }
            throw e;
        }
    }

    @Generated
    public boolean isLocked() {
        return this.locked;
    }
}

