/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.ora.dropSynonym;

import liquibase.database.Database;
import liquibase.database.core.OracleDatabase;
import liquibase.exception.ValidationErrors;
import liquibase.ext.ora.dropSynonym.DropSynonymStatement;
import liquibase.sql.Sql;
import liquibase.sql.UnparsedSql;
import liquibase.sqlgenerator.SqlGeneratorChain;
import liquibase.sqlgenerator.core.AbstractSqlGenerator;
import liquibase.structure.DatabaseObject;

public class DropSynonymGenerator
extends AbstractSqlGenerator<DropSynonymStatement> {
    public boolean supports(DropSynonymStatement statement, Database database) {
        return database instanceof OracleDatabase;
    }

    public ValidationErrors validate(DropSynonymStatement statement, Database database, SqlGeneratorChain chain) {
        ValidationErrors validationErrors = new ValidationErrors();
        validationErrors.checkRequiredField("synonymName", (Object)statement.getSynonymName());
        return validationErrors;
    }

    public Sql[] generateSql(DropSynonymStatement statement, Database database, SqlGeneratorChain chain) {
        StringBuilder sql = new StringBuilder("DROP ");
        if (statement.isPublic() != null && statement.isPublic().booleanValue()) {
            sql.append("PUBLIC ");
        }
        sql.append("SYNONYM ");
        if (statement.getSynonymSchemaName() != null) {
            sql.append(statement.getSynonymSchemaName()).append(".");
        }
        sql.append(statement.getSynonymName());
        if (statement.isForce() != null && statement.isForce().booleanValue()) {
            sql.append(" FORCE");
        }
        return new Sql[]{new UnparsedSql(sql.toString(), new DatabaseObject[0])};
    }
}

