/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.copy;

import java.io.InputStream;
import java.util.ArrayList;
import liquibase.change.AbstractChange;
import liquibase.change.DatabaseChange;
import liquibase.change.DatabaseChangeProperty;
import liquibase.changelog.ChangeSet;
import liquibase.database.Database;
import liquibase.exception.SetupException;
import liquibase.exception.ValidationErrors;
import liquibase.ext.copy.CopyStatement;
import liquibase.resource.ResourceAccessor;
import liquibase.statement.SqlStatement;
import liquibase.util.StreamUtil;
import liquibase.util.StringUtils;

@DatabaseChange(name="copy", description="The 'copy' tag allows you to specify any copy file and have it stored externally in a file. It is useful for fast importing of data that are not supported through LiquiBase's subsystem.\n", priority=1)
public class CopyChange
extends AbstractChange {
    private String path;
    private Boolean relativeToChangelogFile = false;
    private String catalogName;
    private String schemaName;
    private String tableName;
    private String encoding;

    @DatabaseChangeProperty(description="The file path of the COPY file to load", requiredForDatabase={"postgres"}, exampleValue="my/path/file.sql")
    public String getPath() {
        return this.path;
    }

    public void setPath(String fileName) {
        this.path = fileName;
    }

    @DatabaseChangeProperty(exampleValue="utf8")
    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public Boolean isRelativeToChangelogFile() {
        return this.relativeToChangelogFile;
    }

    public void setRelativeToChangelogFile(Boolean relativeToChangelogFile) {
        this.relativeToChangelogFile = relativeToChangelogFile;
    }

    public String getCatalogName() {
        return this.catalogName;
    }

    public void setCatalogName(String catalogName) {
        this.catalogName = catalogName;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public void setSchemaName(String schemaName) {
        this.schemaName = schemaName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public SqlStatement[] generateStatements(Database arg0) {
        ArrayList<CopyStatement> ret = new ArrayList<CopyStatement>();
        ret.add(new CopyStatement(this.openSqlStream(), this.schemaName, this.tableName));
        return ret.toArray(new SqlStatement[ret.size()]);
    }

    public void finishInitialization() throws SetupException {
        if (this.path == null) {
            throw new SetupException("<copy> - No path specified");
        }
        if (this.tableName == null) {
            throw new SetupException("<copy> - No tableName specified");
        }
    }

    public InputStream openSqlStream() {
        if (this.path == null) {
            return null;
        }
        InputStream inputStream = null;
        try {
            inputStream = StreamUtil.openStream((String)this.path, (Boolean)this.isRelativeToChangelogFile(), (ChangeSet)this.getChangeSet(), (ResourceAccessor)this.getResourceAccessor());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return inputStream;
    }

    public ValidationErrors validate(Database database) {
        ValidationErrors validationErrors = new ValidationErrors();
        if (StringUtils.trimToNull((String)this.getPath()) == null) {
            validationErrors.addError("'path' is required");
        }
        if (StringUtils.trimToNull((String)this.getTableName()) == null) {
            validationErrors.addError("'tableName' is required");
        }
        return validationErrors;
    }

    public String getConfirmationMessage() {
        return "COPY imported in file " + this.path + " to " + this.tableName;
    }
}

