/*
 * Decompiled with CFR 0.152.
 */
package liquibase.sdk.maven.plugins;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.text.DateFormat;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import liquibase.sdk.github.GitHubClient;
import liquibase.sdk.maven.plugins.AbstractGitHubMojo;
import liquibase.sdk.util.ArchiveUtil;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.kohsuke.github.GHArtifact;
import org.kohsuke.github.GHWorkflowRun;

@Mojo(name="download-snapshot-artifacts", requiresProject=false)
public class DownloadSnapshotArtifactsMojo
extends AbstractGitHubMojo {
    @Parameter(property="liquibase.sdk.branchSearch", defaultValue="master")
    protected String branchSearch;
    @Parameter(property="liquibase.sdk.skipFailedBuilds", defaultValue="false")
    protected Boolean skipFailedBuilds;
    @Parameter(property="liquibase.sdk.artifactPattern", required=true)
    protected String artifactPattern;
    @Parameter(property="liquibase.sdk.downloadDirectory", required=true)
    protected String downloadDirectory;
    @Parameter(property="liquibase.sdk.workflowId")
    protected String workflowId;
    @Parameter(property="liquibase.sdk.runId")
    protected String runId;
    @Parameter(property="liquibase.sdk.unzipArtifacts", defaultValue="false")
    protected Boolean unzipArtifacts;

    public void execute() throws MojoExecutionException, MojoFailureException {
        File downloadDirectory = new File(this.downloadDirectory);
        downloadDirectory.mkdirs();
        int downloaded = 0;
        for (String repo : this.getRepos()) {
            this.log.info("Looking for " + this.branchSearch + " from a run in " + repo);
            try {
                GitHubClient github = new GitHubClient(this.githubToken, this.log);
                String matchingLabel = github.findMatchingBranch(repo, this.branchSearch);
                if (matchingLabel == null) {
                    throw new MojoFailureException("Could not find matching branch(es): " + this.branchSearch + " in " + repo);
                }
                this.log.info("Found matching branch: " + matchingLabel);
                GHWorkflowRun runToDownload = null;
                runToDownload = StringUtils.trimToNull((String)this.runId) == null ? github.findLastBuild(repo, new GitHubClient.BuildFilter(repo, matchingLabel, this.skipFailedBuilds), GitHubClient.getWorkflowId(repo, this.workflowId)) : github.findBuild(repo, Long.parseLong(this.runId));
                if (runToDownload == null) {
                    throw new IOException("Could not find successful build for branch " + matchingLabel);
                }
                this.log.info("Downloading artifacts in build #" + runToDownload.getRunNumber() + " originally ran at " + DateFormat.getDateTimeInstance().format(runToDownload.getCreatedAt()) + " -- " + runToDownload.getHtmlUrl());
                for (GHArtifact artifact : runToDownload.listArtifacts()) {
                    String finalArtifactName = artifact.getName();
                    if (!finalArtifactName.endsWith(".zip")) {
                        finalArtifactName = finalArtifactName + ".zip";
                    }
                    if (ArchiveUtil.filenameMatches(artifact.getName(), this.artifactPattern) || ArchiveUtil.filenameMatches(finalArtifactName, this.artifactPattern)) {
                        Path finalPath = new File(downloadDirectory, finalArtifactName).toPath().normalize().toAbsolutePath();
                        this.log.info("Downloading " + finalPath + "...");
                        URL url = artifact.getArchiveDownloadUrl();
                        File tempFile = github.downloadArtifact(url);
                        Files.move(tempFile.toPath(), finalPath, StandardCopyOption.REPLACE_EXISTING);
                        if (this.unzipArtifacts.booleanValue()) {
                            if (!finalPath.toString().endsWith(".zip")) {
                                this.log.debug("Not unzipping " + finalPath);
                            }
                            Path unzipDirectory = Paths.get(finalPath.toString().replaceFirst(".zip$", ""), new String[0]);
                            this.log.info("Unzipping to  " + unzipDirectory + "...");
                            try (ZipFile zipFile = new ZipFile(finalPath.toFile(), 1);){
                                Enumeration<? extends ZipEntry> entries = zipFile.entries();
                                while (entries.hasMoreElements()) {
                                    ZipEntry entry = entries.nextElement();
                                    Path entryPath = unzipDirectory.resolve(entry.getName());
                                    if (entry.isDirectory()) continue;
                                    Files.createDirectories(entryPath.getParent(), new FileAttribute[0]);
                                    InputStream in = zipFile.getInputStream(entry);
                                    Throwable throwable = null;
                                    try {
                                        OutputStream out = Files.newOutputStream(entryPath.toFile().toPath(), new OpenOption[0]);
                                        Throwable throwable2 = null;
                                        try {
                                            IOUtils.copy((InputStream)in, (OutputStream)out);
                                        }
                                        catch (Throwable throwable3) {
                                            throwable2 = throwable3;
                                            throw throwable3;
                                        }
                                        finally {
                                            if (out == null) continue;
                                            if (throwable2 != null) {
                                                try {
                                                    out.close();
                                                }
                                                catch (Throwable throwable4) {
                                                    throwable2.addSuppressed(throwable4);
                                                }
                                                continue;
                                            }
                                            out.close();
                                        }
                                    }
                                    catch (Throwable throwable5) {
                                        throwable = throwable5;
                                        throw throwable5;
                                    }
                                    finally {
                                        if (in == null) continue;
                                        if (throwable != null) {
                                            try {
                                                in.close();
                                            }
                                            catch (Throwable throwable6) {
                                                throwable.addSuppressed(throwable6);
                                            }
                                            continue;
                                        }
                                        in.close();
                                    }
                                }
                            }
                        }
                        ++downloaded;
                        continue;
                    }
                    this.log.debug("Not downloading " + artifact.getName());
                }
            }
            catch (MojoFailureException e) {
                throw e;
            }
            catch (Exception e) {
                throw new MojoExecutionException(e.getMessage(), e);
            }
        }
        if (downloaded == 0) {
            throw new MojoFailureException("Did not find any matching artifacts");
        }
    }
}

