/*
 * Decompiled with CFR 0.152.
 */
package liquibase.sdk.maven.plugins;

import liquibase.sdk.github.GitHubClient;
import liquibase.sdk.maven.plugins.AbstractGitHubMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Mojo(name="find-matching-branch", requiresProject=false)
public class FindMatchingBranchMojo
extends AbstractGitHubMojo {
    private static final Logger log = LoggerFactory.getLogger(FindMatchingBranchMojo.class);
    @Parameter(property="liquibase.sdk.branchSearch", required=true)
    protected String branchSearch;

    public void execute() throws MojoExecutionException {
        String repo = this.getRepo();
        log.info("Looking for " + this.branchSearch + " in " + repo);
        try {
            GitHubClient github = this.createGitHubClient();
            String matchedLabel = github.findMatchingBranch(repo, this.branchSearch.split("\\s*,\\s*"));
            log.info("Found matching branch " + matchedLabel);
        }
        catch (Exception e) {
            throw new MojoExecutionException(e.getMessage(), e);
        }
    }
}

