/*
 * Decompiled with CFR 0.152.
 */
package liquibase.sdk.maven.plugins;

import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import liquibase.sdk.github.GitHubClient;
import liquibase.sdk.maven.plugins.AbstractGitHubMojo;
import org.apache.commons.io.IOUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="install-snapshot", requiresProject=false)
public class InstallSnapshotMojo
extends AbstractGitHubMojo {
    @Parameter(property="liquibase.sdk.branchSearch", defaultValue="master")
    protected String branchSearch;
    @Parameter(property="liquibase.sdk.skipFailedBuilds", defaultValue="false")
    protected Boolean skipFailedBuilds;
    @Parameter(property="liquibase.sdk.workflowId")
    protected String workflowId;
    @Parameter(property="liquibase.sdk.proWorkflowId")
    protected String proWorkflowId;

    public void execute() throws MojoExecutionException, MojoFailureException {
        for (String repo : this.getRepos()) {
            this.log.info("Looking for " + this.branchSearch + " from a run in " + repo);
            try {
                String currentWorkflowId;
                String artifactName;
                GitHubClient github = new GitHubClient(this.githubToken, this.log);
                String matchingLabel = github.findMatchingBranch(repo, this.branchSearch);
                if (matchingLabel == null) {
                    throw new MojoFailureException("Could not find matching branch(es): " + this.branchSearch + " in " + repo);
                }
                this.log.info("Found matching branch: " + matchingLabel);
                if (repo.endsWith("/liquibase")) {
                    String headBranchFilename = matchingLabel.replaceFirst(".*:", "").replaceAll("[^a-zA-Z0-9\\-.]", "_");
                    artifactName = "liquibase-artifacts-" + headBranchFilename;
                    currentWorkflowId = this.workflowId;
                } else if (repo.equals("liquibase/liquibase-pro")) {
                    artifactName = "liquibase-commercial-modules";
                    currentWorkflowId = this.proWorkflowId;
                } else {
                    artifactName = repo.replaceFirst(".*/", "") + "-artifacts";
                    currentWorkflowId = null;
                }
                File file = github.downloadArtifact(repo, matchingLabel, artifactName, GitHubClient.getWorkflowId(repo, currentWorkflowId), this.skipFailedBuilds);
                if (file == null) {
                    throw new MojoFailureException("Cannot find " + artifactName + ".zip");
                }
                file.deleteOnExit();
                try (ZipFile zipFile = new ZipFile(file);){
                    Enumeration<? extends ZipEntry> entries = zipFile.entries();
                    while (entries.hasMoreElements()) {
                        ZipEntry entry = entries.nextElement();
                        if (!entry.getName().endsWith(".jar") || entry.getName().contains("-javadoc") || entry.getName().contains("-sources")) continue;
                        this.log.info("Installing " + entry.getName() + "...");
                        File entryFile = File.createTempFile(entry.getName() + "-", ".jar");
                        entryFile.deleteOnExit();
                        try (InputStream in = zipFile.getInputStream(entry);
                             FileOutputStream out = new FileOutputStream(entryFile);){
                            IOUtils.copy((InputStream)in, (OutputStream)out);
                        }
                        this.log.debug("Saved " + entry.getName() + " as " + entryFile.getAbsolutePath());
                        this.installToMavenCache(entryFile);
                    }
                }
                this.log.info("Successfully installed " + this.branchSearch + " as version 0-SNAPSHOT from " + repo);
            }
            catch (MojoExecutionException | MojoFailureException e) {
                throw e;
            }
            catch (Exception e) {
                throw new MojoExecutionException(e.getMessage(), e);
            }
        }
    }
}

