/*
 * Decompiled with CFR 0.152.
 */
package liquibase.sdk.maven.plugins;

import java.util.Properties;
import liquibase.sdk.github.GitHubClient;
import liquibase.sdk.maven.plugins.AbstractGitHubMojo;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.kohsuke.github.GHCommitState;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Mojo(name="set-commit-status", requiresProject=false)
public class SetCommitStatusMojo
extends AbstractGitHubMojo {
    private static final Logger log = LoggerFactory.getLogger(SetCommitStatusMojo.class);
    @Parameter(property="liquibase.sdk.status.context", required=true)
    protected String statusContext;
    @Parameter(property="liquibase.sdk.status.description", required=true)
    protected String statusDescription;
    @Parameter(property="liquibase.sdk.status.state", required=true)
    protected String statusState;
    @Parameter(property="liquibase.sdk.status.url", required=true)
    protected String statusUrl;
    @Parameter(property="liquibase.sdk.status.commit", required=true)
    protected String statusCommit;

    public void execute() throws MojoExecutionException {
        try {
            String commit;
            String repo = this.getRepo();
            GitHubClient github = this.createGitHubClient();
            if (StringUtils.trimToNull((String)this.statusCommit).equals("installed")) {
                Properties buildInfo = github.getInstalledBuildProperties(this.getRepo());
                commit = repo.equals("liquibase/liquibase") ? (String)buildInfo.get("build.commit") : (String)buildInfo.get("build.pro.commit");
                if (commit == null) {
                    throw new MojoExecutionException("Could not find commit in build properties");
                }
            } else {
                commit = this.statusCommit;
            }
            log.info("Setting commit status for commit " + commit + " on " + repo);
            github.setCommitStatus(repo, commit, GHCommitState.valueOf((String)this.statusState.toUpperCase()), this.statusContext, this.statusDescription, this.statusUrl);
        }
        catch (MojoExecutionException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MojoExecutionException(e.getMessage(), e);
        }
    }
}

