/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.singlestore;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import liquibase.database.DatabaseConnection;
import liquibase.database.core.MariaDBDatabase;
import liquibase.database.jvm.JdbcConnection;
import liquibase.exception.DatabaseException;

public class SingleStoreDatabase
extends MariaDBDatabase {
    public static final String PRODUCT_NAME = "SingleStore";

    public SingleStoreDatabase() {
        this.sequenceNextValueFunction = null;
        this.unmodifiableDataTypes = new ArrayList();
    }

    public String getShortName() {
        return "singlestore";
    }

    public String getDefaultDatabaseProductName() {
        return PRODUCT_NAME;
    }

    public int getPriority() {
        return 5;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isCorrectDatabaseImplementation(DatabaseConnection conn) throws DatabaseException {
        if (!conn.getDatabaseProductName().equals("MySQL")) return PRODUCT_NAME.equalsIgnoreCase(conn.getDatabaseProductName());
        try (Statement stmt = ((JdbcConnection)conn).createStatement();
             ResultSet rs = stmt.executeQuery("select @@memsql_version");){
            if (!rs.next()) return PRODUCT_NAME.equalsIgnoreCase(conn.getDatabaseProductName());
            if (rs.getString(1).isEmpty()) return PRODUCT_NAME.equalsIgnoreCase(conn.getDatabaseProductName());
            boolean bl = true;
            return bl;
        }
        catch (SQLException e) {
            return false;
        }
    }

    public String getDefaultDriver(String url) {
        if (url.startsWith("jdbc:singlestore")) {
            return "com.singlestore.jdbc.Driver";
        }
        return super.getDefaultDriver(url);
    }

    protected String getMinimumVersionForFractionalDigitsForTimestamp() {
        return "6.8.0";
    }

    public boolean supportsSequences() {
        return false;
    }
}

