/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.singlestore.sqlgenerator;

import liquibase.database.Database;
import liquibase.datatype.DataTypeFactory;
import liquibase.ext.singlestore.SingleStoreDatabase;
import liquibase.sql.Sql;
import liquibase.sql.UnparsedSql;
import liquibase.sqlgenerator.SqlGeneratorChain;
import liquibase.sqlgenerator.core.SetColumnRemarksGenerator;
import liquibase.statement.core.SetColumnRemarksStatement;
import liquibase.structure.DatabaseObject;
import liquibase.util.StringUtil;

public class SetColumnRemarksGeneratorSingleStore
extends SetColumnRemarksGenerator {
    public int getPriority() {
        return 5;
    }

    public boolean supports(SetColumnRemarksStatement statement, Database database) {
        return super.supports(statement, database) && database instanceof SingleStoreDatabase;
    }

    public Sql[] generateSql(SetColumnRemarksStatement statement, Database database, SqlGeneratorChain sqlGeneratorChain) {
        if (database instanceof SingleStoreDatabase) {
            String remarksEscaped = database.escapeStringForDatabase(StringUtil.trimToEmpty((String)statement.getRemarks()));
            String sql = "ALTER TABLE " + database.escapeTableName(statement.getCatalogName(), statement.getSchemaName(), statement.getTableName()) + " MODIFY COLUMN " + database.escapeColumnName(statement.getCatalogName(), statement.getSchemaName(), statement.getTableName(), statement.getColumnName()) + " " + DataTypeFactory.getInstance().fromDescription(statement.getColumnDataType(), database).toDatabaseDataType(database) + " COMMENT '" + remarksEscaped + "'";
            return new Sql[]{new UnparsedSql(sql, new DatabaseObject[0])};
        }
        return super.generateSql(statement, database, sqlGeneratorChain);
    }
}

