/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.vertica.change;

import liquibase.change.AbstractChange;
import liquibase.change.DatabaseChange;
import liquibase.database.Database;
import liquibase.ext.vertica.database.VerticaDatabase;
import liquibase.ext.vertica.statement.DropProjectionStatement;
import liquibase.statement.SqlStatement;

@DatabaseChange(name="dropProjection", description="Drops an existing projection", priority=1, appliesTo={"projection"})
public class DropProjectionChange
extends AbstractChange {
    private String schemaName;
    private String tableName;
    private String projectionName;
    private Boolean cascade;

    public Boolean getCascade() {
        return this.cascade;
    }

    public void setCascade(Boolean cascade) {
        this.cascade = cascade;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public void setSchemaName(String schemaName) {
        this.schemaName = schemaName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public String getProjectionName() {
        return this.projectionName;
    }

    public SqlStatement[] generateStatements(Database database) {
        return new SqlStatement[]{new DropProjectionStatement(this.getSchemaName(), this.getTableName(), this.getProjectionName(), this.getCascade())};
    }

    public String getConfirmationMessage() {
        return "Projection " + this.getProjectionName() + " dropped";
    }

    public void setProjectionName(String projectionName) {
        this.projectionName = projectionName;
    }

    public boolean supports(Database database) {
        return database instanceof VerticaDatabase;
    }
}

