/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.vertica.snapshot;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import liquibase.database.Database;
import liquibase.database.jvm.JdbcConnection;
import liquibase.exception.DatabaseException;
import liquibase.executor.jvm.ColumnMapRowMapper;
import liquibase.executor.jvm.RowMapper;
import liquibase.executor.jvm.RowMapperResultSetExtractor;
import liquibase.snapshot.CachedRow;
import liquibase.util.StringUtil;

class ResultSetCache {
    private int timesSingleQueried = 0;
    private boolean didBulkQuery = false;
    private Map<String, Map<String, List<CachedRow>>> cacheBySchema = new HashMap<String, Map<String, List<CachedRow>>>();
    private Map<String, Object> info = new HashMap<String, Object>();

    ResultSetCache() {
    }

    public List<CachedRow> get(ResultSetExtractor resultSetExtractor) throws DatabaseException {
        try {
            List<CachedRow> results;
            String wantedKey = resultSetExtractor.wantedKeyParameters().createParamsKey(resultSetExtractor.database);
            String schemaKey = resultSetExtractor.wantedKeyParameters().createSchemaKey(resultSetExtractor.database);
            Map<String, List<CachedRow>> cache = this.cacheBySchema.get(schemaKey);
            if (cache == null) {
                cache = new HashMap<String, List<CachedRow>>();
                this.cacheBySchema.put(schemaKey, cache);
            }
            if (cache.containsKey(wantedKey)) {
                return cache.get(wantedKey);
            }
            if (this.didBulkQuery) {
                return new ArrayList<CachedRow>();
            }
            if (resultSetExtractor.shouldBulkSelect(this)) {
                cache.clear();
                results = resultSetExtractor.bulkFetch();
                this.didBulkQuery = true;
            } else {
                ++this.timesSingleQueried;
                results = resultSetExtractor.fastFetch();
            }
            for (CachedRow row : results) {
                for (String rowKey : resultSetExtractor.rowKeyParameters(row).getKeyPermutations()) {
                    if (!cache.containsKey(rowKey)) {
                        cache.put(rowKey, new ArrayList());
                    }
                    cache.get(rowKey).add(row);
                }
            }
            List<CachedRow> returnList = cache.get(wantedKey);
            if (returnList == null) {
                returnList = new ArrayList<CachedRow>();
            }
            return returnList;
        }
        catch (SQLException e) {
            throw new DatabaseException((Throwable)e);
        }
    }

    public <T> T getInfo(String key, Class<T> type) {
        return (T)this.info.get(key);
    }

    public void putInfo(String key, Object value) {
        this.info.put(key, value);
    }

    public static abstract class UnionResultSetExtractor
    extends ResultSetExtractor {
        protected UnionResultSetExtractor(Database database) {
            super(database);
        }
    }

    public static abstract class SingleResultSetExtractor
    extends ResultSetExtractor {
        public SingleResultSetExtractor(Database database) {
            super(database);
        }

        public abstract List<CachedRow> fastFetchQuery() throws SQLException, DatabaseException;

        public abstract List<CachedRow> bulkFetchQuery() throws SQLException, DatabaseException;

        @Override
        public List<CachedRow> fastFetch() throws SQLException, DatabaseException {
            return this.fastFetchQuery();
        }

        @Override
        public List<CachedRow> bulkFetch() throws SQLException, DatabaseException {
            return this.bulkFetchQuery();
        }
    }

    public static abstract class ResultSetExtractor {
        private final Database database;

        public ResultSetExtractor(Database database) {
            this.database = database;
        }

        boolean shouldBulkSelect(ResultSetCache resultSetCache) {
            return resultSetCache.timesSingleQueried >= 3;
        }

        ResultSet executeQuery(String sql, Database database) throws DatabaseException, SQLException {
            Statement statement = ((JdbcConnection)database.getConnection()).createStatement();
            return statement.executeQuery(sql);
        }

        public boolean equals(Object expectedValue, Object foundValue) {
            return this.equals(expectedValue, foundValue, true);
        }

        public boolean equals(Object expectedValue, Object foundValue, boolean equalIfEitherNull) {
            if (expectedValue == null && foundValue == null) {
                return true;
            }
            if (expectedValue == null || foundValue == null) {
                return equalIfEitherNull;
            }
            return expectedValue.equals(foundValue);
        }

        public abstract RowData rowKeyParameters(CachedRow var1);

        public abstract RowData wantedKeyParameters();

        public abstract List<CachedRow> fastFetch() throws SQLException, DatabaseException;

        public abstract List<CachedRow> bulkFetch() throws SQLException, DatabaseException;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected List<CachedRow> extract(ResultSet resultSet) throws SQLException {
            ArrayList<CachedRow> returnList = new ArrayList<CachedRow>();
            try {
                List result = (List)new RowMapperResultSetExtractor((RowMapper)new ColumnMapRowMapper(this.database.isCaseSensitive()){

                    protected Object getColumnValue(ResultSet rs, int index) throws SQLException {
                        Object value = super.getColumnValue(rs, index);
                        if (value != null && value instanceof String) {
                            value = ((String)value).trim();
                        }
                        return value;
                    }
                }).extractData(resultSet);
                for (Map row : result) {
                    returnList.add(new CachedRow(row));
                }
            }
            finally {
                resultSet.close();
            }
            return returnList;
        }
    }

    public static class RowData {
        private Database database;
        private String[] parameters;
        private String catalog;
        private String schema;
        private String[] keyPermutations;

        protected RowData(String catalog, String schema, Database database, String ... parameters) {
            this.database = database;
            this.catalog = catalog;
            this.schema = schema;
            this.parameters = parameters;
        }

        public String[] getKeyPermutations() {
            if (this.keyPermutations == null) {
                this.keyPermutations = this.permutations(this.parameters);
            }
            return this.keyPermutations;
        }

        protected String[] permutations(String[] params) {
            return this.permute(params, 0);
        }

        private String[] permute(String[] params, int fromIndex) {
            String[] nullVersion = Arrays.copyOf(params, params.length);
            nullVersion[fromIndex] = null;
            if (params.length == fromIndex + 1) {
                return new String[]{this.createKey(this.database, params), this.createKey(this.database, nullVersion)};
            }
            ArrayList permutations = new ArrayList();
            Collections.addAll(permutations, this.permute(params, fromIndex + 1));
            Collections.addAll(permutations, this.permute(nullVersion, fromIndex + 1));
            return permutations.toArray(new String[permutations.size()]);
        }

        public String createSchemaKey(Database database) {
            if (!database.supportsCatalogs() && !database.supportsSchemas()) {
                return "all";
            }
            if (database.supportsCatalogs() && database.supportsSchemas()) {
                return (this.catalog + "." + this.schema).toLowerCase();
            }
            if (this.catalog == null && this.schema != null) {
                return this.schema.toLowerCase();
            }
            if (this.catalog == null) {
                return "all";
            }
            return this.catalog.toLowerCase();
        }

        public String createKey(Database database, String ... params) {
            String key = StringUtil.join((String[])params, (String)":");
            if (!database.isCaseSensitive()) {
                return key.toLowerCase();
            }
            return key;
        }

        public String createParamsKey(Database database) {
            return this.createKey(database, this.parameters);
        }
    }
}

