/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.vertica.sqlgenerator;

import liquibase.database.Database;
import liquibase.exception.ValidationErrors;
import liquibase.ext.vertica.database.VerticaDatabase;
import liquibase.ext.vertica.statement.DropProjectionStatement;
import liquibase.sql.Sql;
import liquibase.sql.UnparsedSql;
import liquibase.sqlgenerator.SqlGeneratorChain;
import liquibase.sqlgenerator.core.AbstractSqlGenerator;
import liquibase.structure.DatabaseObject;
import liquibase.structure.core.Relation;
import liquibase.structure.core.Table;

public class DropProjectionGenerator
extends AbstractSqlGenerator<DropProjectionStatement> {
    public ValidationErrors validate(DropProjectionStatement statement, Database database, SqlGeneratorChain sqlGeneratorChain) {
        ValidationErrors validationErrors = new ValidationErrors();
        validationErrors.checkRequiredField("projectionName", (Object)statement.getProjectionName());
        return validationErrors;
    }

    public Sql[] generateSql(DropProjectionStatement statement, Database database, SqlGeneratorChain sqlGeneratorChain) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("DROP PROJECTION ");
        if (statement.getSchemaName() != null) {
            buffer.append(statement.getSchemaName()).append(".");
        }
        if (statement.getProjectionName() != null) {
            buffer.append(statement.getProjectionName()).append(" ");
        }
        if (statement.isCascade()) {
            buffer.append(" CASCADE");
        }
        return new Sql[]{new UnparsedSql(buffer.toString(), new DatabaseObject[]{this.getAffectedTable(statement)})};
    }

    protected Relation getAffectedTable(DropProjectionStatement statement) {
        return new Table().setName(statement.getTableName()).setSchema("", statement.getSchemaName());
    }

    public boolean supports(DropProjectionStatement statement, Database database) {
        return database instanceof VerticaDatabase;
    }
}

