/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.modifycolumn;

import java.util.ArrayList;
import liquibase.change.ColumnConfig;
import liquibase.database.Database;
import liquibase.database.core.CacheDatabase;
import liquibase.database.core.DB2Database;
import liquibase.database.core.DerbyDatabase;
import liquibase.database.core.H2Database;
import liquibase.database.core.HsqlDatabase;
import liquibase.database.core.MSSQLDatabase;
import liquibase.database.core.MaxDBDatabase;
import liquibase.database.core.MySQLDatabase;
import liquibase.database.core.OracleDatabase;
import liquibase.database.core.SQLiteDatabase;
import liquibase.database.core.SybaseASADatabase;
import liquibase.database.core.SybaseDatabase;
import liquibase.database.structure.DatabaseObject;
import liquibase.database.typeconversion.TypeConverterFactory;
import liquibase.exception.ValidationErrors;
import liquibase.exception.Warnings;
import liquibase.ext.modifycolumn.ModifyColumnStatement;
import liquibase.sql.Sql;
import liquibase.sql.UnparsedSql;
import liquibase.sqlgenerator.SqlGenerator;
import liquibase.sqlgenerator.SqlGeneratorChain;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModifyColumnGenerator
implements SqlGenerator<ModifyColumnStatement> {
    public int getPriority() {
        return 5;
    }

    public boolean supports(ModifyColumnStatement statement, Database database) {
        return true;
    }

    public boolean requiresUpdatedDatabaseMetadata(Database database) {
        return false;
    }

    public Warnings warn(ModifyColumnStatement modifyColumnStatement, Database database, SqlGeneratorChain sqlGeneratorChain) {
        return new Warnings();
    }

    public ValidationErrors validate(ModifyColumnStatement statement, Database database, SqlGeneratorChain sqlGeneratorChain) {
        ValidationErrors validationErrors = new ValidationErrors();
        validationErrors.checkRequiredField("tableName", (Object)statement.getTableName());
        validationErrors.checkRequiredField("columns", (Object)statement.getColumns());
        for (ColumnConfig column : statement.getColumns()) {
            if (!column.isPrimaryKey() || !(database instanceof CacheDatabase) && !(database instanceof H2Database) && !(database instanceof DB2Database) && !(database instanceof DerbyDatabase) && !(database instanceof SQLiteDatabase)) continue;
            validationErrors.addError("Adding primary key columns is not supported on " + database.getTypeName());
        }
        return validationErrors;
    }

    public Sql[] generateSql(ModifyColumnStatement statement, Database database, SqlGeneratorChain sqlGeneratorChain) {
        if (database instanceof SQLiteDatabase) {
            return this.generateStatementsForSQLiteDatabase(statement, database);
        }
        ArrayList<UnparsedSql> sql = new ArrayList<UnparsedSql>();
        for (ColumnConfig column : statement.getColumns()) {
            String alterTable = "ALTER TABLE " + database.escapeTableName(statement.getSchemaName(), statement.getTableName());
            alterTable = alterTable + " " + this.getModifyString(database) + " ";
            alterTable = alterTable + database.escapeColumnName(statement.getSchemaName(), statement.getTableName(), column.getName());
            alterTable = alterTable + this.getPreDataTypeString(database);
            alterTable = alterTable + TypeConverterFactory.getInstance().findTypeConverter(database).getDataType(column.getType(), Boolean.valueOf(false));
            if (this.supportsExtraMetaData(database)) {
                if (!column.isNullable()) {
                    alterTable = alterTable + " NOT NULL";
                } else if (database instanceof SybaseDatabase || database instanceof SybaseASADatabase) {
                    alterTable = alterTable + " NULL";
                }
                alterTable = alterTable + this.getDefaultClause(column, database);
                if (column.isAutoIncrement() != null && column.isAutoIncrement().booleanValue()) {
                    alterTable = alterTable + " " + database.getAutoIncrementClause();
                }
                if (column.isPrimaryKey()) {
                    alterTable = alterTable + " PRIMARY KEY";
                }
            }
            alterTable = alterTable + this.getPostDataTypeString(database);
            sql.add(new UnparsedSql(alterTable, new DatabaseObject[0]));
        }
        return sql.toArray(new Sql[sql.size()]);
    }

    private Sql[] generateStatementsForSQLiteDatabase(ModifyColumnStatement statement, Database database) {
        ArrayList statements = new ArrayList();
        return statements.toArray(new Sql[statements.size()]);
    }

    private boolean supportsExtraMetaData(Database database) {
        return database instanceof MSSQLDatabase || database instanceof MySQLDatabase;
    }

    private String getModifyString(Database database) {
        if (database instanceof HsqlDatabase || database instanceof H2Database || database instanceof DerbyDatabase || database instanceof DB2Database || database instanceof MSSQLDatabase || database instanceof CacheDatabase) {
            return "ALTER COLUMN";
        }
        if (database instanceof SybaseASADatabase || database instanceof SybaseDatabase || database instanceof MySQLDatabase) {
            return "MODIFY";
        }
        if (database instanceof OracleDatabase || database instanceof MaxDBDatabase) {
            return "MODIFY (";
        }
        return "ALTER COLUMN";
    }

    private String getPreDataTypeString(Database database) {
        if (database instanceof DerbyDatabase || database instanceof DB2Database) {
            return " SET DATA TYPE ";
        }
        if (database instanceof SybaseASADatabase || database instanceof SybaseDatabase || database instanceof MSSQLDatabase || database instanceof MySQLDatabase || database instanceof HsqlDatabase || database instanceof H2Database || database instanceof CacheDatabase || database instanceof OracleDatabase || database instanceof MaxDBDatabase) {
            return " ";
        }
        return " TYPE ";
    }

    private String getPostDataTypeString(Database database) {
        if (database instanceof OracleDatabase || database instanceof MaxDBDatabase) {
            return " )";
        }
        return "";
    }

    private String getDefaultClause(ColumnConfig column, Database database) {
        String clause = "";
        String defaultValue = column.getDefaultValue();
        if (defaultValue != null && database instanceof MySQLDatabase) {
            clause = clause + " DEFAULT " + TypeConverterFactory.getInstance().findTypeConverter(database).getDataType((Object)defaultValue).convertObjectToString((Object)defaultValue, database);
        }
        return clause;
    }
}

