/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.tools;

import com.datical.liquibase.ext.config.SqlcmdConfiguration;
import com.datical.liquibase.ext.config.SqlcmdConfiguration$ConfigurationKeys;
import com.datical.liquibase.ext.database.jvm.ProJdbcConnection;
import com.datical.liquibase.ext.tools.NativeToolFileCreator;
import com.datical.liquibase.ext.tools.NativeToolFileCreator$FileTypeEnum;
import com.datical.liquibase.ext.util.NativeRunnerUtil;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.TimeoutException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import liquibase.Scope;
import liquibase.change.AbstractSQLChange;
import liquibase.change.Change;
import liquibase.change.core.ExecuteShellCommandChange;
import liquibase.changelog.ChangeSet;
import liquibase.database.Database;
import liquibase.database.DatabaseConnection;
import liquibase.database.core.MSSQLDatabase;
import liquibase.exception.LiquibaseException;
import liquibase.exception.UnexpectedLiquibaseException;
import liquibase.resource.ResourceAccessor;
import liquibase.servicelocator.LiquibaseService;
import liquibase.sql.Sql;
import liquibase.util.StringUtil;

@LiquibaseService(skip=true)
public class SqlcmdRunner
extends ExecuteShellCommandChange {
    private final ChangeSet changeSet;
    private final Sql[] sqlStrings;
    private File outFile = null;
    private Boolean keepTempFile;
    private List<String> args = new ArrayList<String>();
    private String tempName;
    private String tempPath;
    private Boolean tempOverwrite;
    private String logFile;
    private String catalogName;
    private static final String EXECUTABLE_NAME = "sqlcmd";

    public SqlcmdRunner(ChangeSet changeSet, Sql[] sqlArray) {
        this.changeSet = changeSet;
        this.sqlStrings = sqlArray;
        this.setTimeout("1800");
    }

    public int hashCode() {
        return super.hashCode();
    }

    public boolean equals(Object object) {
        return super.equals(object);
    }

    public String getLogFile() {
        return this.logFile;
    }

    public void setLogFile(String string) {
        this.logFile = string;
    }

    public String getCatalogName() {
        return this.catalogName;
    }

    public void setCatalogName(String string) {
        this.catalogName = string;
    }

    protected List<String> createFinalCommandArray(Database database) {
        this.loadSqlcmdProperties();
        List list = super.createFinalCommandArray(database);
        String string = this.getCatalogName() != null ? this.getCatalogName() : database.getDefaultCatalogName();
        try {
            if (string != null && !((MSSQLDatabase)database).isAzureDb()) {
                this.writeSqlStrings(string);
            } else {
                this.writeSqlStrings(null);
            }
        }
        catch (Exception exception) {
            throw new UnexpectedLiquibaseException((Throwable)exception);
        }
        if (this.keepTempFile == null) {
            this.keepTempFile = (Boolean)SqlcmdConfiguration.TEMP_KEEP.getCurrentValue();
        }
        list.add("-S");
        list.add(this.getDatabaseHostname(database));
        String string2 = "";
        Object object = "";
        DatabaseConnection databaseConnection = database.getConnection();
        if (databaseConnection instanceof ProJdbcConnection) {
            object = (ProJdbcConnection)databaseConnection;
            string2 = ((ProJdbcConnection)((Object)object)).getUsername();
            if (string2 == null) {
                string2 = databaseConnection.getConnectionUserName();
            }
            string2 = StringUtil.trimToEmpty((String)string2);
            if ((object = StringUtil.trimToEmpty((String)((ProJdbcConnection)((Object)object)).getPassword())).equals("")) {
                string2 = "";
            }
        }
        if (StringUtil.isEmpty((String)string2) || StringUtil.isEmpty((String)object)) {
            Scope.getCurrentScope().getLog(SqlcmdRunner.class).fine("database connection is missing username and/or password. Assuming integratedSecurity.");
            list.add("-E");
        } else {
            Scope.getCurrentScope().getLog(SqlcmdRunner.class).fine("database connection has both username and password. Adding -U and -P to commandArray.");
            list.add("-U");
            list.add(string2);
            list.add("-P");
            list.add(object);
        }
        if (((MSSQLDatabase)database).isAzureDb()) {
            Scope.getCurrentScope().getLog(SqlcmdRunner.class).fine("database is AzureDB");
            list.add("-d");
            list.add(string);
        }
        if (this.isActiveDirectoryAuthentication(database)) {
            list.add("-G");
        }
        if (this.outFile != null) {
            list.add("-i");
            list.add(this.outFile.getAbsolutePath());
        }
        list.add("-b");
        list.add("-e");
        if (!this.args.isEmpty()) {
            list.addAll(Collections.unmodifiableList(this.args));
        }
        object = StringUtil.join((Collection)list, (String)" ").replaceAll("^(.*?) (.*?) -U (.*?) -P (.*?) (.*)", "$1 $2 -U ****** -P ****** $5");
        Scope.getCurrentScope().getLog(((Object)((Object)this)).getClass()).info("SQLCMD command:\n".concat(String.valueOf(object)));
        return list;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void executeCommand(Database object) {
        block10: {
            try {
                this.finalCommandArray = this.createFinalCommandArray((Database)object);
                super.executeCommand(object);
                if (this.outFile == null) break block10;
            }
            catch (TimeoutException timeoutException) {
                try {
                    try {
                        Thread.sleep(10000L);
                    }
                    catch (InterruptedException interruptedException) {
                        Thread.currentThread().interrupt();
                    }
                    this.processResult(0, null, null, (Database)object);
                    object = timeoutException.getMessage() + System.lineSeparator() + System.lineSeparator() + "The sqlcmd executable failed to return a response within the configured timeout.\nPlease check liquibase.sqlcmd.timeout specified in liquibase.sqlcmd.conf file, the LIQUIBASE_SQLCMD_TIMEOUT Environment variable, or other config locations.\nLearn more at https://docs.liquibase.com/concepts/advanced/runwith.html." + System.lineSeparator();
                    Scope.getCurrentScope().getUI().sendMessage("WARNING: ".concat(String.valueOf(object)));
                    Scope.getCurrentScope().getLog(SqlcmdRunner.class).warning((String)object);
                    throw new LiquibaseException((Throwable)timeoutException);
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw illegalArgumentException;
                    }
                    catch (Exception exception) {
                        throw new LiquibaseException((Throwable)exception);
                    }
                }
                catch (Throwable throwable) {
                    if (this.outFile != null && this.outFile.exists() && this.keepTempFile != null && this.keepTempFile.booleanValue()) {
                        Scope.getCurrentScope().getLog(((Object)((Object)this)).getClass()).info("SQLCMD run script can be located at: " + this.outFile.getAbsolutePath());
                    }
                    throw throwable;
                }
            }
            if (this.outFile.exists() && this.keepTempFile != null && this.keepTempFile.booleanValue()) {
                Scope.getCurrentScope().getLog(((Object)((Object)this)).getClass()).info("SQLCMD run script can be located at: " + this.outFile.getAbsolutePath());
                return;
            }
        }
    }

    protected void processResult(int n2, String string, String string2, Database database) {
        if (n2 != 0 && !StringUtil.isEmpty((String)string2)) {
            String string3 = this.getCommandString() + " returned a code of " + n2 + "\n" + string2;
            throw new UnexpectedLiquibaseException(string3);
        }
        super.processResult(n2, string, string2, database);
    }

    protected ExecuteShellCommandChange.StreamGobbler createErrorGobbler(InputStream inputStream, OutputStream outputStream) {
        return new ExecuteShellCommandChange.StreamGobbler((ExecuteShellCommandChange)this, inputStream, outputStream, Thread.currentThread());
    }

    private boolean isActiveDirectoryAuthentication(Database object) {
        return ((String)(object = object.getConnection().getURL())).toLowerCase().contains("authentication=activedirectorypassword") || ((String)object).toLowerCase().contains("authentication=activedirectorymsi") || ((String)object).toLowerCase().contains("activedirectoryintegrated");
    }

    private String getDatabaseHostname(Database object) {
        object = object.getConnection().getURL();
        Object object2 = Pattern.compile(".*?//(.*?):(\\d+);.*").matcher((CharSequence)object);
        if (((Matcher)object2).matches()) {
            object = ((Matcher)object2).group(1);
            object2 = ((Matcher)object2).group(2);
        } else {
            object = object.replaceFirst(".*?//", "").replaceFirst(":.*", "").replaceFirst(";.*", "");
            object2 = "1433";
        }
        return "tcp:" + (String)object + "," + (String)object2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void loadSqlcmdProperties() {
        this.setExecutable(NativeRunnerUtil.getExecutable(EXECUTABLE_NAME));
        File file = null;
        Properties properties = new Properties();
        Object object = (String)SqlcmdConfiguration.PATH.getCurrentValue();
        if (object != null) {
            file = new File((String)object);
        }
        object = (Integer)SqlcmdConfiguration.TIMEOUT.getCurrentValue();
        String string = (String)SqlcmdConfiguration.ARGS.getCurrentValue();
        this.assignPropertiesFromConfiguration();
        ResourceAccessor resourceAccessor = Scope.getCurrentScope().getResourceAccessor();
        InputStream inputStream = null;
        try {
            resourceAccessor = resourceAccessor.openStreams(null, "liquibase.sqlcmd.conf");
            Throwable throwable = null;
            try {
                if (resourceAccessor == null || resourceAccessor.size() == 0) {
                    Scope.getCurrentScope().getLog(((Object)((Object)this)).getClass()).info("No configuration file named 'liquibase.sqlcmd.conf' found.");
                } else {
                    String string2 = ((URI)resourceAccessor.getURIs().get(0)).getRawPath();
                    Scope.getCurrentScope().getLog(((Object)((Object)this)).getClass()).info("SQLCMD configuration file located at '" + string2 + "'.");
                    inputStream = (InputStream)resourceAccessor.iterator().next();
                    properties.load(inputStream);
                    if (properties.containsKey("liquibase.sqlcmd.path")) {
                        file = new File(properties.getProperty("liquibase.sqlcmd.path"));
                    }
                    if (properties.containsKey("liquibase.sqlcmd.timeout")) {
                        object = this.determineTimeout(properties);
                    }
                    if (properties.containsKey("liquibase.sqlcmd.args")) {
                        string = properties.getProperty("liquibase.sqlcmd.args");
                    }
                    this.overrideWithFileProperties(properties);
                }
            }
            catch (Throwable throwable2) {
                Throwable throwable3 = throwable2;
                throwable = throwable2;
                throw throwable3;
            }
            finally {
                if (resourceAccessor != null) {
                    if (throwable != null) {
                        try {
                            resourceAccessor.close();
                        }
                        catch (Throwable throwable4) {
                            throwable.addSuppressed(throwable4);
                        }
                    } else {
                        resourceAccessor.close();
                    }
                }
            }
        }
        catch (IOException iOException) {
            try {
                throw new UnexpectedLiquibaseException((Throwable)iOException);
            }
            catch (Throwable throwable5) {
                try {
                    if (inputStream == null) throw throwable5;
                    inputStream.close();
                    throw throwable5;
                }
                catch (Exception exception) {}
                throw throwable5;
            }
        }
        try {
            if (inputStream != null) {
                inputStream.close();
            }
        }
        catch (Exception exception) {}
        this.handleSqlcmdExecutable(file);
        this.handleTimeout((Integer)object);
        this.handleArgs(string);
        this.logProperties();
    }

    private void handleArgs(String string) {
        if (string != null) {
            string = string.trim();
            Scope.getCurrentScope().getLog(((Object)((Object)this)).getClass()).info("Executing 'sqlcmd' with a extra arguments of '" + string + "'");
            this.args = StringUtil.splitAndTrim((String)string, (String)" ");
        }
    }

    private void handleTimeout(Integer n2) {
        if (n2 != null) {
            NativeRunnerUtil.validateTimeout(n2);
            this.setTimeout(String.valueOf(n2));
            Scope.getCurrentScope().getLog(((Object)((Object)this)).getClass()).info("Executing 'sqlcmd' with a timeout of '" + n2 + "'");
        }
    }

    private void handleSqlcmdExecutable(File file) {
        if (file == null) {
            return;
        }
        this.checkSqlcmdExecutable(file);
        try {
            this.setExecutable(file.getCanonicalPath());
            Scope.getCurrentScope().getLog(((Object)((Object)this)).getClass()).info("Using the 'sqlcmd' executable located at:  '" + file.getCanonicalPath() + "'");
            return;
        }
        catch (IOException iOException) {
            throw new UnexpectedLiquibaseException((Throwable)iOException);
        }
    }

    private void assignPropertiesFromConfiguration() {
        this.tempName = (String)SqlcmdConfiguration.TEMP_NAME.getCurrentValue();
        this.tempPath = (String)SqlcmdConfiguration.TEMP_PATH.getCurrentValue();
        this.tempOverwrite = (Boolean)SqlcmdConfiguration.TEMP_OVERWRITE.getCurrentValue();
        this.logFile = (String)SqlcmdConfiguration.LOG_FILE.getCurrentValue();
        this.catalogName = (String)SqlcmdConfiguration.CATALOG_NAME.getCurrentValue();
        if (!SqlcmdConfiguration.TEMP_KEEP.getCurrentConfiguredValue().wasDefaultValueUsed()) {
            this.keepTempFile = (Boolean)SqlcmdConfiguration.TEMP_KEEP.getCurrentValue();
        }
    }

    private void logProperties() {
        if (this.keepTempFile != null) {
            Scope.getCurrentScope().getLog(((Object)((Object)this)).getClass()).info("Executing 'sqlcmd' with a keep temp file value of '" + this.keepTempFile + "'");
        }
        if (this.tempPath != null) {
            Scope.getCurrentScope().getLog(((Object)((Object)this)).getClass()).info("Executing 'sqlcmd' with a keep temp file path value of '" + this.tempPath + "'");
        }
        if (this.tempOverwrite != null) {
            Scope.getCurrentScope().getLog(((Object)((Object)this)).getClass()).info("Executing 'sqlcmd' with a keep temp file overwrite value of '" + this.tempOverwrite + "'");
        }
        if (this.tempName != null) {
            Scope.getCurrentScope().getLog(((Object)((Object)this)).getClass()).info("Executing 'sqlcmd' with a keep temp file name value of '" + this.tempName + "'");
        }
        if (this.logFile != null) {
            Scope.getCurrentScope().getLog(((Object)((Object)this)).getClass()).info("Executing 'sqlcmd' with a log file value of '" + this.logFile + "'");
        }
    }

    private void checkSqlcmdExecutable(File file) {
        if (!file.exists()) {
            throw new UnexpectedLiquibaseException("The 'sqlcmd' executable was not found at '" + file.getAbsolutePath() + "'.\nPlease check the liquibase.sqlcmd.path property in liquibase.sqlcmd.conf, the LIQUIBASE_SQLCMD_PATH Environment variable, \nor other config locations. Learn more at https://docs.liquibase.com/concepts/advanced/runwith.html.\n");
        }
        if (!file.canExecute()) {
            throw new UnexpectedLiquibaseException("The 'sqlcmd' executable located at '" + file.getAbsolutePath() + "' cannot be executed");
        }
    }

    private int determineTimeout(Properties object) {
        if ((object = ((Properties)object).getProperty("liquibase.sqlcmd.timeout")) == null) {
            return -1;
        }
        try {
            return Integer.parseInt((String)object);
        }
        catch (Exception exception) {
            throw new UnexpectedLiquibaseException("Invalid value '" + (String)object + "' for timeoutString 'liquibase.sqlcmd.timeout'. Must be a valid integer.  Learn more at https://docs.liquibase.com");
        }
    }

    private void overrideWithFileProperties(Properties properties) {
        if (properties.containsKey("liquibase.sqlcmd.keep.temp")) {
            this.keepTempFile = NativeRunnerUtil.getBooleanFromProperties(properties, "liquibase.sqlcmd.keep.temp");
        }
        if (properties.containsKey(SqlcmdConfiguration$ConfigurationKeys.getFullKey("keep.temp.name"))) {
            this.tempName = properties.getProperty(SqlcmdConfiguration$ConfigurationKeys.getFullKey("keep.temp.name"));
        }
        if (properties.containsKey(SqlcmdConfiguration$ConfigurationKeys.getFullKey("keep.temp.overwrite"))) {
            this.tempOverwrite = NativeRunnerUtil.getBooleanFromProperties(properties, SqlcmdConfiguration$ConfigurationKeys.getFullKey("keep.temp.overwrite"));
        }
        if (properties.containsKey(SqlcmdConfiguration$ConfigurationKeys.getFullKey("keep.temp.path"))) {
            this.tempPath = properties.getProperty(SqlcmdConfiguration$ConfigurationKeys.getFullKey("keep.temp.path"));
        }
        if (properties.containsKey(SqlcmdConfiguration$ConfigurationKeys.getFullKey("logFile"))) {
            this.logFile = properties.getProperty(SqlcmdConfiguration$ConfigurationKeys.getFullKey("logFile"));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void writeSqlStrings(String object) {
        BufferedWriter bufferedWriter;
        block17: {
            Object object2;
            if (this.sqlStrings == null) return;
            if (this.sqlStrings.length == 0) {
                return;
            }
            Scope.getCurrentScope().getLog(((Object)((Object)this)).getClass()).info("Creating the SQL run script");
            Object object3 = new NativeToolFileCreator(this.changeSet, this.tempName, this.tempPath, this.tempOverwrite == null ? ((Boolean)SqlcmdConfiguration.TEMP_OVERWRITE.getDefaultValue()).booleanValue() : this.tempOverwrite.booleanValue(), this.keepTempFile == null ? ((Boolean)SqlcmdConfiguration.TEMP_KEEP.getDefaultValue()).booleanValue() : this.keepTempFile.booleanValue());
            try {
                this.outFile = object3.generateTemporaryFile(NativeToolFileCreator$FileTypeEnum.sql);
            }
            catch (IOException iOException) {
                throw new UnexpectedLiquibaseException((Throwable)iOException);
            }
            object3 = this.sqlStrings;
            int n2 = this.sqlStrings.length;
            for (int i2 = 0; i2 < n2 && !this.warnOnOutStatements((Sql)(object2 = object3[i2])); ++i2) {
            }
            object3 = System.lineSeparator();
            bufferedWriter = Files.newBufferedWriter(Paths.get(this.outFile.getAbsolutePath(), new String[0]), new OpenOption[0]);
            object2 = null;
            try {
                if (object != null) {
                    bufferedWriter.write("USE [" + (String)object + "];" + (String)object3);
                    bufferedWriter.write("GO".concat(String.valueOf(object3)));
                }
                if (this.logFile != null) {
                    bufferedWriter.write("\n:OUT \"" + this.logFile + "\"" + (String)object3);
                }
                bufferedWriter.write(";".concat(String.valueOf(object3)));
                object = this.sqlStrings;
                int n3 = this.sqlStrings.length;
                for (n2 = 0; n2 < n3; ++n2) {
                    String string = object[n2].toSql().replace("\r", "");
                    bufferedWriter.write(string + "\n");
                }
                object = this.getEndDelimiter();
                if (object != null && ((String)object).equals("\n/$")) {
                    bufferedWriter.write("/\n");
                }
                bufferedWriter.write("GO\n");
                if (bufferedWriter == null) return;
                if (object2 == null) break block17;
            }
            catch (Throwable throwable) {
                try {
                    object = throwable;
                    object2 = throwable;
                    throw object;
                }
                catch (Throwable throwable2) {
                    if (bufferedWriter == null) throw throwable2;
                    if (object2 == null) {
                        bufferedWriter.close();
                        throw throwable2;
                    }
                    try {
                        bufferedWriter.close();
                        throw throwable2;
                    }
                    catch (Throwable throwable3) {
                        ((Throwable)object2).addSuppressed(throwable3);
                        throw throwable2;
                    }
                }
            }
            try {
                bufferedWriter.close();
                return;
            }
            catch (Throwable throwable) {
                ((Throwable)object2).addSuppressed(throwable);
                return;
            }
        }
        bufferedWriter.close();
    }

    private boolean warnOnOutStatements(Sql stringArray) {
        stringArray = stringArray.toSql().split("\n");
        int n2 = stringArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            if (!stringArray[i2].matches("(?im)^\\s*:out .*")) continue;
            Scope.getCurrentScope().getLog(SqlcmdRunner.class).warning("OUT statements were detected in your script for change set " + this.changeSet.getId() + "::" + this.changeSet.getAuthor() + ".\nThis may prevent SQLCMD output from being included in the Liquibase logs");
            return true;
        }
        return false;
    }

    private String getEndDelimiter() {
        Change change;
        String string = null;
        Iterator iterator = this.changeSet.getChanges().iterator();
        while (iterator.hasNext() && (!((change = (Change)iterator.next()) instanceof AbstractSQLChange) || (string = ((AbstractSQLChange)change).getEndDelimiter()) == null)) {
        }
        return string;
    }
}

