/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.flow.file;

import com.datical.liquibase.ext.flow.action.Action;
import com.datical.liquibase.ext.flow.condition.Condition;
import com.datical.liquibase.ext.flow.file.FlowFile;
import com.datical.liquibase.ext.flow.file.FlowFileDTO;
import com.datical.liquibase.ext.flow.file.FlowFileYaml;
import com.datical.liquibase.ext.flow.file.FlowVariableExpander;
import com.datical.liquibase.ext.flow.file.Stage;
import com.datical.liquibase.ext.flow.file.StageDTO;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.stream.Collectors;
import liquibase.Scope;
import liquibase.exception.CommandExecutionException;
import liquibase.exception.UnexpectedLiquibaseException;
import liquibase.util.CollectionUtil;
import liquibase.util.FileUtil;
import liquibase.util.StreamUtil;
import liquibase.util.StringUtil;
import org.yaml.snakeyaml.Yaml;

public class FlowFileHelper {
    private static final FlowFileYaml ffy = new FlowFileYaml();
    private static final Map<String, Action> cachedActions = Scope.getCurrentScope().getServiceLocator().findInstances(Action.class).stream().collect(Collectors.toMap(Action::getType, action -> action));

    private FlowFileHelper() {
    }

    public static FlowFile load(File object, boolean bl2) {
        ffy.setSkipMissingProperties(bl2);
        object = (FlowFileDTO)ffy.load(FileUtil.getContents((File)object));
        FlowFile flowFile = new FlowFile();
        flowFile.setGlobalVariables(((FlowFileDTO)object).getGlobalVariables());
        flowFile.setIncludedVariables(FlowFileHelper.getIncludedVariables(((FlowFileDTO)object).getInclude()));
        if (((FlowFileDTO)object).getStages() != null) {
            Iterator<Map.Entry<String, StageDTO>> iterator = ((FlowFileDTO)object).getStages().entrySet().iterator();
            while (iterator.hasNext()) {
                FlowFileHelper.processStage(iterator.next(), flowFile);
            }
        }
        flowFile.setEndStage(FlowFileHelper.processStage(((FlowFileDTO)object).getEndStage(), flowFile.getAllVariables()));
        return flowFile;
    }

    private static LinkedHashMap<String, Object> getIncludedVariables(LinkedHashMap<String, String> object) {
        if (object != null) {
            LinkedHashMap<String, Object> linkedHashMap = new LinkedHashMap<String, Object>();
            Yaml yaml = new Yaml();
            for (Map.Entry entry : ((LinkedHashMap)((Object)object)).entrySet()) {
                try {
                    String string = (String)entry.getKey();
                    String string2 = (String)entry.getValue();
                    Object object22 = new File(string2);
                    if (!((File)object22).exists()) {
                        throw new FileNotFoundException("File not found ".concat(String.valueOf(string2)));
                    }
                    if (StringUtil.isEmpty((String)(object22 = FileUtil.getContents((File)object22)))) {
                        throw new CommandExecutionException("Included file " + string2 + " is empty");
                    }
                    for (Object object22 : ((Map)yaml.load((String)object22)).entrySet()) {
                        Object v2 = object22.getValue();
                        object22 = (String)object22.getKey();
                        linkedHashMap.put(string + "." + (String)object22, v2);
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            return linkedHashMap;
        }
        return null;
    }

    public static File createDefaultFlowFile(String string) {
        File file = null;
        Throwable throwable = null;
        try (InputStream inputStream = FlowFileHelper.class.getClassLoader().getResourceAsStream("liquibase/flow/".concat(String.valueOf(string)));){
            if (inputStream != null) {
                String string2 = StreamUtil.readStreamAsString((InputStream)inputStream);
                file = new File(string);
                FileUtil.write((String)string2, (File)file);
            }
        }
        catch (Throwable throwable2) {
            Throwable throwable3 = throwable2;
            throwable = throwable2;
            throw throwable3;
        }
        return file;
    }

    private static Stage processStage(StageDTO stageDTO, LinkedHashMap<String, Object> linkedHashMap) {
        if (stageDTO == null) {
            return null;
        }
        Stage stage = new Stage();
        for (Map map : CollectionUtil.createIfNull(stageDTO.getActions())) {
            stage.getActions().add(FlowFileHelper.generateAction(map, linkedHashMap));
        }
        stage.setGlobalArgs(FlowVariableExpander.expandVariables(stageDTO.getGlobalArgs(), linkedHashMap));
        if (StringUtil.isNotEmpty((String)stageDTO.getCondition())) {
            stage.setCondition(Condition.fromString(stageDTO.getCondition(), linkedHashMap));
        }
        return stage;
    }

    private static void processStage(Map.Entry<String, StageDTO> object, FlowFile flowFile) {
        Object object2;
        LinkedHashMap<String, Object> linkedHashMap = flowFile.getAllVariables();
        StageDTO stageDTO = object.getValue();
        if (stageDTO != null) {
            object2 = stageDTO.getStageVariables();
            if (linkedHashMap != null && object2 != null) {
                linkedHashMap.putAll((Map<String, Object>)object2);
            }
        }
        object2 = FlowFileHelper.processStage(stageDTO, linkedHashMap);
        object = object.getKey();
        flowFile.getStages().put((String)object, (Stage)object2);
    }

    private static Action generateAction(Map<String, Object> map, Map<String, Object> map2) {
        Action action;
        Object object = map.containsKey("type") ? (String)map.get("type") : "liquibase";
        if (StringUtil.isEmpty((String)object)) {
            object = "liquibase";
        }
        if ((action = FlowFileHelper.findAction((String)object)) == null) {
            throw new UnexpectedLiquibaseException("Unable to locate action '" + (String)object + "'");
        }
        object = action.fromAction(map, map2);
        ((Action)object).setCondition(map, map2);
        return object;
    }

    private static Action findAction(String string) {
        return FlowFileHelper.findAllActions().get(string);
    }

    private static Map<String, Action> findAllActions() {
        return cachedActions;
    }
}

