/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.checks.dynamic;

import com.datical.liquibase.ext.checks.config.DynamicRuleParameterEnum;
import com.datical.liquibase.ext.checks.config.cli.RuleParameter;
import com.datical.liquibase.ext.checks.config.model.DynamicRule;
import com.datical.liquibase.ext.checks.config.model.DynamicRuleParameter;
import com.datical.liquibase.ext.rules.api.ScopeEnum;
import com.datical.liquibase.ext.rules.api.SeverityEnum;
import com.datical.liquibase.ext.rules.core.AbstractLiquibaseDynamicForecastRule;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.regex.Pattern;
import liquibase.Scope;
import liquibase.change.AbstractSQLChange;
import liquibase.change.Change;
import liquibase.changelog.ChangeSet;
import liquibase.database.Database;
import liquibase.structure.DatabaseObject;
import liquibase.util.StringUtil;

public class CheckForSpecificPatternsInSQL
extends AbstractLiquibaseDynamicForecastRule {
    public CheckForSpecificPatternsInSQL() {
        this.setSeverity(SeverityEnum.INFO);
    }

    @Override
    public List<ScopeEnum> getScope() {
        return Collections.singletonList(ScopeEnum.CHANGELOG);
    }

    @Override
    public List<String> getTags() {
        return null;
    }

    @Override
    public String getMinLiquibaseVersion() {
        return null;
    }

    @Override
    public String getMaxLiquibaseVersion() {
        return null;
    }

    @Override
    public boolean internalEvaluate(ChangeSet changeSet, DynamicRule dynamicRule) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean internalEvaluate(ChangeSet changeSet, Database database, DynamicRule dynamicRule) {
        Object object = dynamicRule.getParameter(DynamicRuleParameterEnum.SEARCH_STRING);
        Object object2 = dynamicRule.getParameter(DynamicRuleParameterEnum.MESSAGE);
        Object object3 = dynamicRule.getParameter(DynamicRuleParameterEnum.STRIP_COMMENTS);
        Objects.requireNonNull(object);
        Objects.requireNonNull(object2);
        Objects.requireNonNull(object3);
        object = Pattern.compile((String)((DynamicRuleParameter)object).getValue());
        object2 = (String)((DynamicRuleParameter)object2).getValue();
        object3 = (Boolean)((DynamicRuleParameter)object3).getValue();
        for (Change change : changeSet.getChanges()) {
            try {
                if (!this.doCheck(change, database, (Pattern)object, (Boolean)object3)) continue;
                this.addFailureRuleIteration(changeSet, this.getFailureMessage((String)object2, (Pattern)object, changeSet), dynamicRule);
            }
            catch (IllegalStateException illegalStateException) {
                Scope.getCurrentScope().getLog(CheckForSpecificPatternsInSQL.class).info("Error generating SQL for change '" + change.getDescription() + "': " + illegalStateException.getMessage());
                this.addFailureRuleIteration(changeSet, "Unable to generate SQL for change '" + change.getDescription() + "'. Checks executed against the H2 database for this object type are not available.", dynamicRule);
            }
        }
        return this.returnAtEndOfRule(changeSet, dynamicRule);
    }

    @Override
    public boolean internalEvaluate(DatabaseObject databaseObject, DynamicRule dynamicRule) {
        throw new UnsupportedOperationException();
    }

    private boolean doCheck(Change object, Database database, Pattern pattern, boolean bl2) {
        object = object instanceof AbstractSQLChange ? this.getSql((AbstractSQLChange)object) : this.generateSqlFromChange((Change)object, database);
        if (bl2) {
            object = StringUtil.stripComments((String)object);
        }
        if (StringUtil.isEmpty((String)object)) {
            return false;
        }
        return pattern.matcher((CharSequence)object).find();
    }

    private String getFailureMessage(String string, Pattern pattern, ChangeSet changeSet) {
        return string.replace("<" + (Object)((Object)DynamicRuleParameterEnum.SEARCH_STRING) + ">", pattern.pattern()).replace("<CHANGESET>", changeSet.getId());
    }

    @Override
    public String getDescription() {
        return "This check scans SQL for the presence of specific patterns and warns the user when they are found.";
    }

    @Override
    public String getShortName() {
        return "SqlUserDefinedPatternCheck";
    }

    @Override
    public int getPriority() {
        return 60;
    }

    @Override
    public List<RuleParameter<?>> getParameters() {
        return Arrays.asList(new RuleParameter(DynamicRuleParameterEnum.SEARCH_STRING), new RuleParameter(DynamicRuleParameterEnum.MESSAGE), new RuleParameter(DynamicRuleParameterEnum.STRIP_COMMENTS));
    }
}

