/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.init;

import com.datical.liquibase.ext.checks.config.ChecksFileAccessor;
import com.datical.liquibase.ext.checks.config.cli.FilenameGetter;
import com.datical.liquibase.ext.command.init.InitProjectCommandStep;
import com.datical.liquibase.ext.init.InitProjectUtil$FileCreationResultEnum;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import liquibase.Scope;
import liquibase.command.CommandResultsBuilder;
import liquibase.configuration.ConfiguredValue;
import liquibase.exception.CommandExecutionException;
import liquibase.resource.PathHandlerFactory;
import liquibase.resource.Resource;
import liquibase.util.FileUtil;
import liquibase.util.StreamUtil;
import liquibase.util.StringUtil;

public class InitProjectUtil {
    public static final String SQL = "sql";
    public static final String JSON = "json";
    public static final String YML = "yml";
    public static final String YAML = "yaml";
    public static final String XML = "xml";
    public static final String MODIFIED_DEFAULTS_FILE_CONTENTS = "modifiedDefaultsFileContents";

    public static void createProjectDirectory(File object) {
        if (!(((File)object).exists() || ((File)object).mkdirs() || ((File)object).exists())) {
            object = "Unable to create specified project directory '" + ((File)object).getAbsolutePath() + "'.\nPlease check permission and try 'liquibase init project' again";
            throw new CommandExecutionException((String)object);
        }
    }

    public static void validateChangelogFilePath(String string) {
        new FilenameGetter().validate(string);
    }

    public static void validateProjectDirectory(File object) {
        if (((File)object).exists() && ((File)object).isFile()) {
            object = System.lineSeparator() + System.lineSeparator() + "The specified project directory '" + ((File)object).getAbsolutePath() + "' cannot be a file" + System.lineSeparator() + System.lineSeparator();
            throw new CommandExecutionException((String)object);
        }
    }

    public static void updateDefaultsFile(File file, boolean bl2, String string, ConfiguredValue<String> object, ConfiguredValue<String> configuredValue, ConfiguredValue<String> configuredValue2, ConfiguredValue<String> configuredValue3, InitProjectUtil$FileCreationResultEnum initProjectUtil$FileCreationResultEnum, Boolean bl3, CommandResultsBuilder commandResultsBuilder) {
        String string2 = FileUtil.getContents((File)file);
        if (string2 == null) {
            return;
        }
        String string3 = string2;
        if (initProjectUtil$FileCreationResultEnum == InitProjectUtil$FileCreationResultEnum.already_existed || initProjectUtil$FileCreationResultEnum == InitProjectUtil$FileCreationResultEnum.created) {
            if (!object.wasDefaultValueUsed()) {
                if (!((String)(object = (String)object.getValue())).contains(".".concat(String.valueOf(string)))) {
                    object = object + "." + string;
                }
                string3 = InitProjectUtil.replaceProperty("changeLogFile", object, string3, bl2);
            } else if (string.equalsIgnoreCase(YML)) {
                string3 = InitProjectUtil.replaceProperty("changeLogFile", "example-changelog.yml", string3, bl2);
            }
        } else {
            string3 = InitProjectUtil.replaceProperty("changeLogFile", "", string3, true, true, false, bl2, true);
        }
        if (!configuredValue.wasDefaultValueUsed()) {
            string3 = InitProjectUtil.replaceProperty("url", configuredValue, string3, bl2);
        }
        if (!configuredValue2.wasDefaultValueUsed()) {
            string3 = InitProjectUtil.replaceProperty("username", configuredValue2, string3, bl2);
        }
        if (!configuredValue3.wasDefaultValueUsed()) {
            string3 = InitProjectUtil.replaceProperty("password", configuredValue3, string3, bl2);
        }
        if (bl2 || string2.equals(string3)) {
            FileUtil.write((String)string3, (File)file, (boolean)false);
            return;
        }
        if (Boolean.FALSE.equals(bl3)) {
            commandResultsBuilder.addResult(MODIFIED_DEFAULTS_FILE_CONTENTS, (Object)string3);
            return;
        }
        object = InitProjectUtil.calcBackupFile(file);
        Resource resource = ((PathHandlerFactory)Scope.getCurrentScope().getSingleton(PathHandlerFactory.class)).getResource(file.getAbsolutePath());
        string = ((PathHandlerFactory)Scope.getCurrentScope().getSingleton(PathHandlerFactory.class)).getResource(((File)object).getAbsolutePath());
        ChecksFileAccessor.makeBackup(resource, (Resource)string, string2, null, false);
        FileUtil.write((String)string3, (File)file, (boolean)false);
        InitProjectUtil.outputBackedUpDefaultsFileMessage(file.getAbsolutePath());
    }

    public static void outputBackedUpDefaultsFileMessage(String string) {
        string = String.format("%sThe defaults file '%s' was backed up and then updated with your supplied values.%s", System.lineSeparator(), InitProjectUtil.removeDotsFromPath(string), System.lineSeparator());
        Scope.getCurrentScope().getUI().sendMessage(string);
        Scope.getCurrentScope().getLog(InitProjectUtil.class).info(string);
    }

    public static String replaceProperty(String string, ConfiguredValue<String> configuredValue, String string2, boolean bl2) {
        return InitProjectUtil.replaceProperty(string, (String)configuredValue.getValue(), string2, bl2);
    }

    public static String replaceProperty(String string, String string2, String string3, boolean bl2) {
        return InitProjectUtil.replaceProperty(string, string2, string3, false, true, true, bl2, false);
    }

    public static String replaceProperty(String string, String string2, String string3, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6) {
        String string4 = string3;
        Object object = "^[\\s]*liquibase\\.command\\." + string + "[\\s]*[=:][\\s]*(.*?)$";
        String string5 = (bl3 ? "liquibase.command." : "") + string;
        if (((Matcher)(object = Pattern.compile((String)object, 42).matcher(string3.toLowerCase()))).find()) {
            string3 = InitProjectUtil.obfuscateValue(string2, string);
            String string6 = ((Matcher)object).group(1).trim();
            Scope.getCurrentScope().getLog(InitProjectUtil.class).info("Replacing value for 'liquibase.command." + string + "' with '" + string3 + "'");
            if (bl6 && !bl5 && StringUtil.isNotEmpty((String)string6)) {
                return string4;
            }
            string4 = string4.replaceAll("liquibase\\.command\\.(?i)" + string + "[\\s]*([=:])[\\s]*(.*)", (InitProjectUtil.shouldCommentProperty(bl2, bl5, StringUtil.isEmpty((String)string6)) ? "#" : "") + string5 + "$1" + (string2 == null ? string2 : Matcher.quoteReplacement(string2))).replace(string5 + ":" + string2, "liquibase.command." + string + ": " + string2);
        } else {
            object = Pattern.compile("^[\\s]*(?i)" + string + "[\\s]*[=:][\\s]*(.*?)$", 42).matcher(string3.toLowerCase());
            if (((Matcher)object).find()) {
                string3 = InitProjectUtil.obfuscateValue(string2, string);
                String string7 = ((Matcher)object).group(1).trim();
                if (bl6 && !bl5 && StringUtil.isNotEmpty((String)string7)) {
                    return string4;
                }
                string4 = string4.replaceAll("(?i)" + string + "[\\s]*([=:])[\\s]*(.*)", (InitProjectUtil.shouldCommentProperty(bl2, bl5, StringUtil.isEmpty((String)string7)) ? "#" : "") + string + "$1" + (string2 == null ? string2 : Matcher.quoteReplacement(string2)));
                Scope.getCurrentScope().getLog(InitProjectUtil.class).info("Replacing value for '" + string + "' with '" + string3 + "'");
                string4 = string4.replace(string + ":" + string2, string + ": " + string2);
            } else if (bl4) {
                Scope.getCurrentScope().getLog(InitProjectUtil.class).info("Adding property 'liquibase.command." + string + "' with value '" + string2 + "'");
                string4 = string4 + "\n" + string5 + "=" + string2;
            }
        }
        return string4;
    }

    private static String obfuscateValue(String string, String string2) {
        if (string2.toLowerCase().contains("username") || string2.toLowerCase().contains("password")) {
            string = "*****";
        }
        if (string != null) {
            string = string.trim();
        }
        return string;
    }

    private static boolean shouldCommentProperty(boolean bl2, boolean bl3, boolean bl4) {
        return bl2 && (bl3 || bl4);
    }

    public static File copyExampleProperties(String string, String string2, String string3) {
        try {
            if (string == null || string.equalsIgnoreCase(SQL)) {
                string = "liquibase/examples/sql/liquibase.properties";
            } else if (string.equalsIgnoreCase(XML)) {
                string = "liquibase/examples/xml/liquibase.properties";
            } else if (string.equalsIgnoreCase(JSON)) {
                string = "liquibase/examples/json/liquibase.properties";
            } else if (string.equalsIgnoreCase(YAML) || string.equalsIgnoreCase(YML)) {
                string = "liquibase/examples/yaml/liquibase.properties";
            } else {
                throw new CommandExecutionException("Unknown format '" + string + "'");
            }
            Object object = InitProjectUtil.class.getClassLoader().getResourceAsStream(string);
            Object object2 = null;
            try {
                string = StreamUtil.readStreamAsString((InputStream)object);
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                object2 = throwable;
                throw throwable2;
            }
            finally {
                if (object != null) {
                    if (object2 != null) {
                        try {
                            ((InputStream)object).close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object2).addSuppressed(throwable);
                        }
                    } else {
                        ((InputStream)object).close();
                    }
                }
            }
            if (StringUtil.isEmpty((String)string)) {
                throw new CommandExecutionException("Unable to read the example changelog file resource.");
            }
            object = new File(string2, string3);
            FileUtil.write((String)string, (File)object, (boolean)false);
            object2 = InitProjectUtil.removeDotsFromPath(((File)object).getAbsolutePath());
            String string4 = "Created example defaults file '" + (String)object2 + "'";
            Scope.getCurrentScope().getLog(InitProjectUtil.class).info(string4);
            Scope.getCurrentScope().getUI().sendMessage(string4);
            return object;
        }
        catch (IOException iOException) {
            throw new CommandExecutionException("Unable to create the example properties file", (Throwable)iOException);
        }
    }

    public static InitProjectUtil$FileCreationResultEnum copyExampleChangelog(String string, File file, String string2, ConfiguredValue<String> configuredValue) {
        try {
            Object object;
            Object object2 = InitProjectUtil.findChangeLogsInProjectDir(file);
            if (string2 != null && object2 != null && ((File[])object2).length > 0) {
                object = new File(file, string2);
                if (Arrays.stream(object2).anyMatch(arg_0 -> InitProjectUtil.lambda$copyExampleChangelog$0((File)object, arg_0))) {
                    return InitProjectUtil$FileCreationResultEnum.already_existed;
                }
            }
            if (string.equalsIgnoreCase(SQL)) {
                object = "liquibase/examples/sql/example-changelog.sql";
            } else if (string.equalsIgnoreCase(XML)) {
                object = "liquibase/examples/xml/example-changelog.xml";
            } else if (string.equalsIgnoreCase(JSON)) {
                object = "liquibase/examples/json/example-changelog.json";
            } else if (string.equalsIgnoreCase(YAML) || string.equalsIgnoreCase(YML)) {
                object = "liquibase/examples/yaml/example-changelog.yaml";
            } else {
                throw new CommandExecutionException("Unknown format '" + string + "'");
            }
            object = InitProjectUtil.class.getClassLoader().getResourceAsStream((String)object);
            Object object3 = null;
            try {
                object2 = StreamUtil.readStreamAsString((InputStream)object);
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                object3 = throwable;
                throw throwable2;
            }
            finally {
                if (object != null) {
                    if (object3 != null) {
                        try {
                            ((InputStream)object).close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object3).addSuppressed(throwable);
                        }
                    } else {
                        ((InputStream)object).close();
                    }
                }
            }
            if (StringUtil.isEmpty((String)object2)) {
                throw new CommandExecutionException("Unable to read the example changelog file resource.");
            }
            object = string2 != null && !configuredValue.wasDefaultValueUsed() ? (string2.contains(".".concat(String.valueOf(string))) ? new File(file, string2) : new File(file, string2 + "." + string)) : new File(file, "example-changelog.".concat(String.valueOf(string)));
            FileUtil.write((String)object2, (File)object, (boolean)false);
            object3 = InitProjectUtil.removeDotsFromPath(((File)object).getAbsolutePath());
            String string3 = System.lineSeparator() + "Created example changelog file '" + (String)object3 + "'";
            Scope.getCurrentScope().getLog(InitProjectUtil.class).info(string3);
            Scope.getCurrentScope().getUI().sendMessage(string3);
        }
        catch (IOException iOException) {
            throw new CommandExecutionException("Unable to create the example changelog", (Throwable)iOException);
        }
        return InitProjectUtil$FileCreationResultEnum.created;
    }

    public static void copyExampleFlowFiles(String object, File file) {
        try {
            for (Map.Entry<String, String> entry : InitProjectUtil.buildFlowFilePaths((String)(object == null ? SQL : object)).entrySet()) {
                Object object2;
                String string;
                Object object3;
                String string2 = entry.getKey();
                String string3 = entry.getValue();
                if (Files.exists(Paths.get(file.getPath() + "/" + string2, new String[0]), new LinkOption[0])) {
                    object3 = "Flow file '" + string2 + "' already exists! Skipping example generation.";
                    Scope.getCurrentScope().getLog(InitProjectUtil.class).info((String)object3);
                    continue;
                }
                object3 = InitProjectUtil.class.getClassLoader().getResourceAsStream(string3);
                Object object4 = null;
                try {
                    string = StreamUtil.readStreamAsString((InputStream)object3);
                }
                catch (Throwable throwable) {
                    object2 = throwable;
                    object4 = throwable;
                    throw object2;
                }
                finally {
                    if (object3 != null) {
                        if (object4 != null) {
                            try {
                                ((InputStream)object3).close();
                            }
                            catch (Throwable throwable) {
                                ((Throwable)object4).addSuppressed(throwable);
                            }
                        } else {
                            ((InputStream)object3).close();
                        }
                    }
                }
                if (StringUtil.isEmpty((String)string)) {
                    throw new CommandExecutionException("Unable to read the example flow file resource.");
                }
                object3 = new File(file, string2);
                FileUtil.write((String)string, (File)object3, (boolean)false);
                object4 = InitProjectUtil.removeDotsFromPath(((File)object3).getAbsolutePath());
                object2 = "Created example flow file '" + (String)object4 + "'";
                Scope.getCurrentScope().getLog(InitProjectUtil.class).info((String)object2);
                Scope.getCurrentScope().getUI().sendMessage((String)object2);
            }
            return;
        }
        catch (IOException iOException) {
            throw new CommandExecutionException("Unable to create the example flow files", (Throwable)iOException);
        }
    }

    private static Map<String, String> buildFlowFilePaths(String string2) {
        List<String> list = Arrays.asList("liquibase.flowfile.yaml", "liquibase.advanced.flow", "liquibase.endstage.flow", "liquibase.flowvariables.yaml");
        String string4 = "liquibase/examples/%s/%s";
        if (Arrays.asList(SQL, JSON, YAML, YML, XML).contains(string2.toLowerCase())) {
            string2 = string2.equalsIgnoreCase(YML) ? YAML : string2;
            return list.stream().collect(Collectors.toMap(string -> string, string3 -> String.format(string4, string2, string3)));
        }
        throw new CommandExecutionException("Unknown format '" + string2 + "'");
    }

    public static boolean wasH2Used(ConfiguredValue<String> configuredValue, ConfiguredValue<String> configuredValue2, ConfiguredValue<String> configuredValue3) {
        return configuredValue.wasDefaultValueUsed() && configuredValue2.wasDefaultValueUsed() && configuredValue3.wasDefaultValueUsed() || ((String)configuredValue.getValue()).equals(InitProjectCommandStep.URL_ARG.getDefaultValue()) && ((String)configuredValue2.getValue()).equals(InitProjectCommandStep.USERNAME_ARG.getDefaultValue()) && ((String)configuredValue3.getValue()).equals(InitProjectCommandStep.PASSWORD_ARG.getDefaultValue());
    }

    public static String removeDotsFromPath(String string) {
        return string.replaceAll("(?<!\\.)\\./", "").replaceAll("(?<!\\.)\\.\\\\", "");
    }

    public static String determineFormatType(String string, String string2) {
        if ((string = InitProjectUtil.getExtension(string)) == null) {
            if (string2 != null) {
                return string2;
            }
            return null;
        }
        switch (string) {
            case "sql": 
            case "json": 
            case "yml": 
            case "yaml": 
            case "xml": {
                return string;
            }
        }
        return null;
    }

    public static String getExtension(String stringArray) {
        if (stringArray.isEmpty()) {
            return null;
        }
        if ((stringArray = stringArray.split("\\.")).length == 1) {
            return null;
        }
        return stringArray[stringArray.length - 1].toLowerCase();
    }

    public static File[] findChangeLogsInProjectDir(File file2) {
        FileFilter fileFilter = file -> !file.isDirectory() && file.getName().toLowerCase().contains("changelog") && InitProjectUtil.hasRecognizedExtension(file);
        return file2.listFiles(fileFilter);
    }

    public static boolean hasRecognizedExtension(File file) {
        return InitProjectUtil.determineFormatType(file.getName(), null) != null;
    }

    public static File calcBackupFile(File file) {
        int n2 = 1;
        File file2 = new File(file.getParentFile(), file.getName() + ".backup." + InitProjectUtil.newVersion(1));
        boolean bl2 = true;
        while (bl2) {
            bl2 = file2.exists();
            if (!bl2) {
                bl2 = false;
                continue;
            }
            file2 = new File(file.getParentFile(), file.getName() + ".backup." + InitProjectUtil.newVersion(++n2));
        }
        return file2;
    }

    private static String newVersion(int n2) {
        if (n2 < 10) {
            return "0" + Integer.toString(n2);
        }
        return Integer.toString(n2);
    }

    private static /* synthetic */ boolean lambda$copyExampleChangelog$0(File file, File file2) {
        return file2.getAbsolutePath().equalsIgnoreCase(file.getAbsolutePath());
    }
}

