/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.command;

import com.datical.liquibase.ext.command.AbstractFlowCommand;
import com.datical.liquibase.ext.command.FlowValidateCommandStep;
import com.datical.liquibase.ext.flow.action.Action;
import com.datical.liquibase.ext.flow.action.LiquibaseCommandAction;
import com.datical.liquibase.ext.flow.file.FlowFile;
import com.datical.liquibase.ext.flow.file.Stage;
import com.datical.liquibase.ext.flow.provider.StageGlobalArgsValueProvider;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import liquibase.Scope;
import liquibase.command.CommandArgumentDefinition;
import liquibase.command.CommandBuilder;
import liquibase.command.CommandDefinition;
import liquibase.command.CommandResults;
import liquibase.command.CommandResultsBuilder;
import liquibase.command.CommandScope;
import liquibase.configuration.ConfigurationValueProvider;
import liquibase.configuration.ConfiguredValue;
import liquibase.configuration.LiquibaseConfiguration;
import liquibase.exception.CommandExecutionException;
import liquibase.exception.CommandValidationException;

public class FlowCommandStep
extends AbstractFlowCommand {
    public static final String[] COMMAND_NAME = new String[]{"flow"};
    public static final CommandArgumentDefinition<String> FLOW_FILE;
    public static final CommandArgumentDefinition<String> FLOW_INTEGRATION;
    public static final CommandArgumentDefinition<Boolean> FLOW_FILE_STRICT_PARSING;
    public static final CommandArgumentDefinition<String> FLOW_SHELL_INTERPRETER;
    public static final CommandArgumentDefinition<Boolean> FLOW_SHELL_KEEP_TEMP_FILES;
    public static final String DEFAULT_FLOW_FILE_NAME = "liquibase.flowfile.yaml";
    public static final String BANNER = "******************************************************************************";
    private Boolean validated;
    private FlowFile flowFile;

    @Override
    public void validate(CommandScope commandScope) {
        super.validate(commandScope);
        try {
            CommandScope commandScope2 = new CommandScope(FlowValidateCommandStep.COMMAND_NAME);
            for (Map.Entry entry : commandScope2.getCommand().getArguments().entrySet()) {
                ConfiguredValue configuredValue = commandScope.getConfiguredValue((CommandArgumentDefinition)entry.getValue());
                if (configuredValue.wasDefaultValueUsed()) continue;
                commandScope2.addArgumentValue((String)entry.getKey(), configuredValue.getValue());
            }
            CommandResults commandResults = commandScope2.execute();
            this.validated = (Boolean)commandResults.getResult("validated");
            this.flowFile = (FlowFile)commandResults.getResult("flowFile");
            return;
        }
        catch (CommandExecutionException commandExecutionException) {
            Scope.getCurrentScope().getLog(((Object)((Object)this)).getClass()).severe("Error during validation", (Throwable)commandExecutionException);
            throw new CommandValidationException("Error during validation: " + commandExecutionException.getMessage());
        }
    }

    public String[][] defineCommandNames() {
        return new String[][]{COMMAND_NAME};
    }

    /*
     * Could not resolve type clashes
     * Loose catch block
     */
    public void run(CommandResultsBuilder object) {
        block23: {
            Object object2;
            block22: {
                if (this.validated == null || Boolean.FALSE.equals(this.validated)) {
                    object.addResult("statusCode", (Object)0);
                    return;
                }
                if (this.flowFile == null) {
                    object.addResult("statusCode", (Object)0);
                    return;
                }
                Iterator<Map.Entry<String, OutputStream>> iterator = this.flowFile.getStages();
                if (iterator == null || ((HashMap)((Object)iterator)).isEmpty()) {
                    Scope.getCurrentScope().getUI().sendMessage("No stages found.");
                    break block22;
                }
                for (Object object3 : ((LinkedHashMap)((Object)iterator)).entrySet()) {
                    object2 = (String)object3.getKey();
                    object3 = (Stage)object3.getValue();
                    this.executeStage((Stage)object3, (String)object2, (CommandResultsBuilder)object);
                }
            }
            try {
                FlowCommandStep flowCommandStep = this;
                flowCommandStep.executeStage(flowCommandStep.flowFile.getEndStage(), "endStage", (CommandResultsBuilder)object);
            }
            catch (Throwable throwable) {
                for (Object object3 : LiquibaseCommandAction.OPENED_OUTPUT_STREAMS.entrySet()) {
                    object2 = object3.getValue();
                    object3 = object3.getKey();
                    try {
                        ((OutputStream)object2).close();
                    }
                    catch (Exception exception) {
                        Scope.getCurrentScope().getLog(((Object)((Object)this)).getClass()).warning("Failed to close output stream for file ".concat(String.valueOf(object3)), (Throwable)exception);
                    }
                }
                throw throwable;
            }
            for (Object object3 : LiquibaseCommandAction.OPENED_OUTPUT_STREAMS.entrySet()) {
                object2 = object3.getValue();
                object3 = (String)object3.getKey();
                try {
                    ((OutputStream)object2).close();
                }
                catch (Exception exception) {
                    Scope.getCurrentScope().getLog(((Object)((Object)this)).getClass()).warning("Failed to close output stream for file ".concat(String.valueOf(object3)), (Throwable)exception);
                }
            }
            break block23;
            catch (Throwable throwable) {
                try {
                    FlowCommandStep flowCommandStep = this;
                    flowCommandStep.executeStage(flowCommandStep.flowFile.getEndStage(), "endStage", (CommandResultsBuilder)object);
                }
                catch (Throwable throwable2) {
                    for (Object object4 : LiquibaseCommandAction.OPENED_OUTPUT_STREAMS.entrySet()) {
                        OutputStream outputStream = object4.getValue();
                        object4 = object4.getKey();
                        try {
                            outputStream.close();
                        }
                        catch (Exception exception) {
                            Scope.getCurrentScope().getLog(((Object)((Object)this)).getClass()).warning("Failed to close output stream for file ".concat(String.valueOf(object4)), (Throwable)exception);
                        }
                    }
                    throw throwable2;
                }
                for (Object object5 : LiquibaseCommandAction.OPENED_OUTPUT_STREAMS.entrySet()) {
                    OutputStream outputStream = (OutputStream)object5.getValue();
                    object5 = (String)object5.getKey();
                    try {
                        outputStream.close();
                    }
                    catch (Exception exception) {
                        Scope.getCurrentScope().getLog(((Object)((Object)this)).getClass()).warning("Failed to close output stream for file ".concat(String.valueOf(object5)), (Throwable)exception);
                    }
                }
                throw throwable;
            }
        }
        object.addResult("statusCode", (Object)0);
    }

    /*
     * WARNING - void declaration
     */
    private void executeStage(Stage object, String object22, CommandResultsBuilder commandResultsBuilder) {
        if (object == null) {
            Scope.getCurrentScope().getUI().sendMessage(this.createBanner("Empty stage '" + (String)object22 + "' found"));
            return;
        }
        if (((Stage)((Object)object)).getActions() == null || ((Stage)((Object)object)).getActions().isEmpty()) {
            Scope.getCurrentScope().getUI().sendMessage(this.createBanner("No actions found for Stage: ".concat(String.valueOf(object22))));
            return;
        }
        if (((Stage)((Object)object)).getCondition() != null && !((Stage)((Object)object)).getCondition().evaluate()) {
            Scope.getCurrentScope().getUI().sendMessage(this.createBanner("Skipping stage: " + (String)object22 + " because condition '" + ((Stage)((Object)object)).getCondition().getRawConditionText() + "' evaluated to false."));
            return;
        }
        LiquibaseConfiguration liquibaseConfiguration = (LiquibaseConfiguration)Scope.getCurrentScope().getSingleton(LiquibaseConfiguration.class);
        StageGlobalArgsValueProvider stageGlobalArgsValueProvider = new StageGlobalArgsValueProvider(((Stage)((Object)object)).getGlobalArgs());
        try {
            liquibaseConfiguration.registerProvider((ConfigurationValueProvider)stageGlobalArgsValueProvider);
            Scope.getCurrentScope().getUI().sendMessage(this.createBanner("Executing Stage: ".concat(String.valueOf(object22))));
            for (Action action : ((Stage)((Object)object)).getActions()) {
                void var3_6;
                this.runAction((CommandResultsBuilder)var3_6, action);
            }
            return;
        }
        finally {
            liquibaseConfiguration.unregisterProvider((ConfigurationValueProvider)stageGlobalArgsValueProvider);
        }
    }

    private void runAction(CommandResultsBuilder commandResultsBuilder, Action action) {
        if (action.getCondition() != null && !action.getCondition().evaluate()) {
            Scope.getCurrentScope().getUI().sendMessage(this.createBanner("Skipping action: " + action + " because condition '" + action.getCondition().getRawConditionText() + "' evaluated to false."));
            return;
        }
        Scope.getCurrentScope().getUI().sendMessage(this.createBanner(String.format("Executing %s", action)));
        action.execute(commandResultsBuilder);
        Scope.getCurrentScope().getUI().sendMessage("");
    }

    private String createBanner(String string) {
        return String.format("%s%n* %n* %s%n* %n%s%n", BANNER, string, BANNER);
    }

    public void adjustCommandDefinition(CommandDefinition commandDefinition) {
        super.adjustCommandDefinition(commandDefinition);
        commandDefinition.setShortDescription("Run a series of commands contained in one or more stages, as configured in a liquibase flow-file.");
    }

    static {
        CommandBuilder commandBuilder = new CommandBuilder((String[][])new String[][]{COMMAND_NAME});
        FLOW_FILE = commandBuilder.argument("flowFile", String.class).defaultValue((Object)DEFAULT_FLOW_FILE_NAME).description("The path to the configuration yaml file which contains one or more 'stages' of commands to be executed in a liquibase flow operation. Defaults to yaml file named \"liquibase.flowfile.yaml\" in the current working directory.").build();
        FLOW_INTEGRATION = commandBuilder.argument("flowIntegration", String.class).hidden().defaultValue((Object)"cli").description("Name of the integration that is executing flow").build();
        FLOW_FILE_STRICT_PARSING = commandBuilder.argument("flowFileStrictParsing", Boolean.class).defaultValue((Object)Boolean.TRUE).description("Parse flow-file YAML to allow only Liquibase flow-file specific properties, indentations, and structure.").build();
        FLOW_SHELL_INTERPRETER = commandBuilder.argument("flowShellInterpreter", String.class).description("The default interpreter used to execute shell commands.").build();
        FLOW_SHELL_KEEP_TEMP_FILES = commandBuilder.argument("flowShellKeepTempFiles", Boolean.class).defaultValue((Object)Boolean.FALSE).description("Do not delete temporary files created by the shell command execution").build();
    }
}

