/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.storedlogic.databasepackage.change;

import com.datical.liquibase.ext.license.LicenseValidationChange;
import com.datical.liquibase.ext.storedlogic.databasepackage.change.CreatePackageStatement;
import com.datical.liquibase.ext.storedlogic.databasepackage.change.DropPackageChange;
import liquibase.change.Change;
import liquibase.change.DatabaseChange;
import liquibase.change.DatabaseChangeProperty;
import liquibase.change.core.CreateProcedureChange;
import liquibase.database.Database;
import liquibase.exception.ValidationErrors;
import liquibase.license.pro.LicenseTier;
import liquibase.serializer.LiquibaseSerializable;
import liquibase.statement.SqlStatement;

@DatabaseChange(name="createPackage", description="Creates a package", priority=101, appliesTo={"package"})
public class CreatePackageChange
extends CreateProcedureChange {
    private String packageName;
    private String packageText;

    public ValidationErrors validate(Database database) {
        ValidationErrors validationErrors = LicenseValidationChange.checkForValidLicense(LicenseTier.PRO, (Change)this);
        if (validationErrors.hasErrors()) {
            return validationErrors;
        }
        return super.validate(database);
    }

    @DatabaseChangeProperty(isChangeProperty=false)
    public String getProcedureName() {
        return this.getPackageName();
    }

    public void setProcedureName(String string) {
        this.setPackageName(string);
    }

    @DatabaseChangeProperty(isChangeProperty=false)
    public String getProcedureText() {
        return this.getPackageText();
    }

    public void setProcedureText(String string) {
        this.setPackageText(string);
    }

    @DatabaseChangeProperty(mustEqualExisting="package", description="Name of the package to drop")
    public String getPackageName() {
        return this.packageName;
    }

    public void setPackageName(String string) {
        this.packageName = string;
    }

    @DatabaseChangeProperty(serializationType=LiquibaseSerializable.SerializationType.DIRECT_VALUE)
    public String getPackageText() {
        return this.packageText;
    }

    public void setPackageText(String string) {
        this.packageText = string;
    }

    public String getConfirmationMessage() {
        return "Package " + this.getPackageName() + " created";
    }

    protected SqlStatement[] generateStatements(String string, String string2, Database database) {
        return new SqlStatement[]{new CreatePackageStatement(this.getCatalogName(), this.getSchemaName(), this.getPackageName(), string, string2)};
    }

    protected Change[] createInverses() {
        DropPackageChange dropPackageChange = new DropPackageChange();
        dropPackageChange.setCatalogName(this.getCatalogName());
        dropPackageChange.setSchemaName(this.getSchemaName());
        dropPackageChange.setPackageName(this.getPackageName());
        return new Change[]{dropPackageChange};
    }

    public String getSerializedObjectNamespace() {
        return "http://www.liquibase.org/xml/ns/pro";
    }
}

