/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.storedlogic.function.change;

import com.datical.liquibase.ext.license.LicenseValidationChange;
import com.datical.liquibase.ext.storedlogic.function.change.CreateFunctionStatement;
import com.datical.liquibase.ext.storedlogic.function.change.DropFunctionChange;
import com.datical.liquibase.ext.util.RefactoringUtils;
import liquibase.change.Change;
import liquibase.change.DatabaseChange;
import liquibase.change.DatabaseChangeProperty;
import liquibase.change.core.CreateProcedureChange;
import liquibase.database.Database;
import liquibase.database.core.AbstractDb2Database;
import liquibase.database.core.MSSQLDatabase;
import liquibase.database.core.MySQLDatabase;
import liquibase.database.core.OracleDatabase;
import liquibase.database.core.PostgresDatabase;
import liquibase.database.core.SnowflakeDatabase;
import liquibase.exception.ValidationErrors;
import liquibase.license.pro.LicenseTier;
import liquibase.serializer.LiquibaseSerializable;
import liquibase.statement.SqlStatement;

@DatabaseChange(name="createFunction", description="Creates a stored function", priority=101, appliesTo={"function"})
public class CreateFunctionChange
extends CreateProcedureChange {
    private String functionName;
    private String functionBody;

    public ValidationErrors validate(Database database) {
        if (database instanceof OracleDatabase || database instanceof MSSQLDatabase || database instanceof MySQLDatabase || database instanceof AbstractDb2Database || database instanceof PostgresDatabase || database instanceof SnowflakeDatabase) {
            ValidationErrors validationErrors = LicenseValidationChange.checkForValidLicense(LicenseTier.PRO, (Change)this);
            if (validationErrors.hasErrors()) {
                return validationErrors;
            }
            return super.validate(database);
        }
        return RefactoringUtils.createValidationErrors(database, (Change)this);
    }

    @DatabaseChangeProperty(isChangeProperty=false)
    public String getProcedureName() {
        return this.getFunctionName();
    }

    public void setProcedureName(String string) {
        this.setFunctionName(string);
    }

    @DatabaseChangeProperty(isChangeProperty=false)
    public String getProcedureText() {
        return this.getFunctionBody();
    }

    public void setProcedureText(String string) {
        this.setFunctionBody(string);
    }

    @DatabaseChangeProperty(mustEqualExisting="function", description="Name of the function to drop")
    public String getFunctionName() {
        return this.functionName;
    }

    public void setFunctionName(String string) {
        this.functionName = string;
    }

    @DatabaseChangeProperty(serializationType=LiquibaseSerializable.SerializationType.DIRECT_VALUE)
    public String getFunctionBody() {
        return this.functionBody;
    }

    public void setFunctionBody(String string) {
        this.functionBody = string;
    }

    public String getConfirmationMessage() {
        return "Function " + this.getFunctionName() + " created";
    }

    protected SqlStatement[] generateStatements(String object, String string, Database database) {
        object = new CreateFunctionStatement(this.getCatalogName(), this.getSchemaName(), this.getFunctionName(), (String)object, string);
        object.setReplaceIfExists(this.getReplaceIfExists());
        return new SqlStatement[]{object};
    }

    protected Change[] createInverses() {
        DropFunctionChange dropFunctionChange = new DropFunctionChange();
        dropFunctionChange.setCatalogName(this.getCatalogName());
        dropFunctionChange.setSchemaName(this.getSchemaName());
        dropFunctionChange.setFunctionName(this.getFunctionName());
        return new Change[]{dropFunctionChange};
    }

    public String getSerializedObjectNamespace() {
        return "http://www.liquibase.org/xml/ns/pro";
    }
}

