/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.checks.dynamic;

import com.datical.liquibase.ext.checks.config.DynamicRuleParameterEnum;
import com.datical.liquibase.ext.checks.config.cli.RuleParameter;
import com.datical.liquibase.ext.checks.config.cli.StringListGetter;
import com.datical.liquibase.ext.checks.config.model.DynamicRule;
import com.datical.liquibase.ext.rules.api.ScopeEnum;
import com.datical.liquibase.ext.rules.api.SeverityEnum;
import com.datical.liquibase.ext.rules.core.AbstractLiquibaseDynamicForecastRule;
import com.datical.liquibase.ext.rules.core.AbstractLiquibaseRule$SupportedChangesetFormats;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import liquibase.change.Change;
import liquibase.change.core.CreateTableChange;
import liquibase.changelog.ChangeSet;
import liquibase.database.Database;
import liquibase.structure.DatabaseObject;

public class PrimaryKeyOnCreateTable
extends AbstractLiquibaseDynamicForecastRule {
    public PrimaryKeyOnCreateTable() {
        this.setSeverity(SeverityEnum.INFO);
    }

    @Override
    public List<String> getTags() {
        return null;
    }

    @Override
    public String getMinLiquibaseVersion() {
        return null;
    }

    @Override
    public String getMaxLiquibaseVersion() {
        return null;
    }

    @Override
    public List<ScopeEnum> getScope() {
        return Collections.singletonList(ScopeEnum.CHANGELOG);
    }

    @Override
    public boolean internalEvaluate(ChangeSet changeSet, DynamicRule dynamicRule) {
        return this.doEvaluate(changeSet.getChanges(), changeSet, dynamicRule, false);
    }

    private boolean doEvaluate(List<Change> object, ChangeSet changeSet, DynamicRule dynamicRule, boolean bl2) {
        List<String> list = StringListGetter.split((String)dynamicRule.getParameter(DynamicRuleParameterEnum.EXCEPTIONS_LIST).getValue());
        Boolean bl3 = (Boolean)dynamicRule.getParameter(DynamicRuleParameterEnum.CASE_SENSITIVE).getValue();
        object = object.iterator();
        while (object.hasNext()) {
            Change change = (Change)object.next();
            if (!(change instanceof CreateTableChange)) continue;
            String string = ((CreateTableChange)change).getTableName();
            boolean bl4 = ((CreateTableChange)change).getColumns().stream().anyMatch(columnConfig -> columnConfig.getConstraints() != null && columnConfig.getConstraints().isPrimaryKey() != null && columnConfig.getConstraints().isPrimaryKey() != false);
            boolean bl5 = list.stream().noneMatch(string2 -> {
                if (bl3.booleanValue()) {
                    return string.equals(string2);
                }
                return string.equalsIgnoreCase((String)string2);
            });
            if (bl4 || !bl5) continue;
            this.addFailureRuleIteration(changeSet, "Create table actions must include a primary key. If you do not require a primary key on \"" + string + "\" add it to the EXCEPTIONS_LIST to avoid this warning.", dynamicRule, bl2);
        }
        return this.returnAtEndOfRule(changeSet, dynamicRule, bl2);
    }

    @Override
    public boolean internalRollbackEvaluate(ChangeSet changeSet, List<Change> list, Database database, DynamicRule dynamicRule) {
        return this.doEvaluate(list, changeSet, dynamicRule, true);
    }

    @Override
    public boolean internalEvaluate(DatabaseObject databaseObject, DynamicRule dynamicRule) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getDescription() {
        return "This check warns when a create table action doesn't also include a primary key.";
    }

    @Override
    public String getShortName() {
        return "PrimaryKeyOnCreateTable";
    }

    @Override
    public String getName() {
        return "Require primary key when creating table";
    }

    @Override
    public int getPriority() {
        return 225;
    }

    @Override
    public List<RuleParameter<?>> getParameters() {
        return Arrays.asList(new RuleParameter(DynamicRuleParameterEnum.EXCEPTIONS_LIST), new RuleParameter(DynamicRuleParameterEnum.CASE_SENSITIVE));
    }

    @Override
    public List<String> getSupportedChangesetFormats() {
        return AbstractLiquibaseRule$SupportedChangesetFormats.MODELED;
    }
}

