/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.command;

import com.datical.liquibase.ext.changelog.filter.SinglePendingChangeSetFilter;
import com.datical.liquibase.ext.command.checks.LazyDatabaseSnapshot;
import com.datical.liquibase.ext.util.ProStringUtil;
import java.io.Writer;
import java.sql.SQLException;
import java.util.Date;
import java.util.ResourceBundle;
import liquibase.Liquibase;
import liquibase.RuntimeEnvironment;
import liquibase.Scope;
import liquibase.changelog.ChangeLogHistoryServiceFactory;
import liquibase.changelog.ChangeLogIterator;
import liquibase.changelog.ChangeLogParameters;
import liquibase.changelog.DatabaseChangeLog;
import liquibase.changelog.filter.ChangeSetFilter;
import liquibase.changelog.filter.ShouldRunChangeSetFilter;
import liquibase.changelog.visitor.ChangeExecListener;
import liquibase.changelog.visitor.ChangeSetVisitor;
import liquibase.changelog.visitor.UpdateVisitor;
import liquibase.command.AbstractCommandStep;
import liquibase.command.CommandArgumentDefinition;
import liquibase.command.CommandBuilder;
import liquibase.command.CommandDefinition;
import liquibase.command.CommandResultsBuilder;
import liquibase.command.CommandScope;
import liquibase.command.CommonArgumentNames;
import liquibase.configuration.ConfigurationValueObfuscator;
import liquibase.database.Database;
import liquibase.exception.LiquibaseException;
import liquibase.exception.LockException;
import liquibase.executor.Executor;
import liquibase.executor.ExecutorService;
import liquibase.executor.LoggingExecutor;
import liquibase.hub.HubUpdater;
import liquibase.hub.listener.HubChangeExecListener;
import liquibase.hub.model.Connection;
import liquibase.hub.model.Operation;
import liquibase.license.LicenseServiceUtils;
import liquibase.lockservice.LockServiceFactory;
import liquibase.logging.LogService;
import liquibase.logging.Logger;
import liquibase.logging.core.BufferedLogService;
import liquibase.logging.core.CompositeLogService;
import liquibase.parser.ChangeLogParserFactory;
import liquibase.resource.ResourceAccessor;

public class UpdateOneChangeSetCommandStep
extends AbstractCommandStep {
    public static final String[] COMMAND_NAME = new String[]{"updateOneChangeset"};
    public static final CommandArgumentDefinition<String> CHANGESET_ID;
    public static final CommandArgumentDefinition<String> CHANGESET_AUTHOR;
    public static final CommandArgumentDefinition<String> CHANGESET_PATH;
    public static final CommandArgumentDefinition<Boolean> FORCE;
    public static final CommandArgumentDefinition<String> URL_ARG;
    public static final CommandArgumentDefinition<String> DEFAULT_SCHEMA_NAME_ARG;
    public static final CommandArgumentDefinition<String> DEFAULT_CATALOG_NAME_ARG;
    public static final CommandArgumentDefinition<String> USERNAME_ARG;
    public static final CommandArgumentDefinition<String> PASSWORD_ARG;
    public static final CommandArgumentDefinition<String> DRIVER_ARG;
    public static final CommandArgumentDefinition<String> DRIVER_PROPERTIES_FILE_ARG;
    private Database database;
    private String changeSetId;
    private String changeSetAuthor;
    private String changeSetPath;
    private Boolean force;
    private ChangeExecListener changeExecListener;
    private Writer writer;
    private static final ResourceBundle coreBundle;

    public String[][] defineCommandNames() {
        return new String[][]{COMMAND_NAME};
    }

    public void adjustCommandDefinition(CommandDefinition commandDefinition) {
        commandDefinition.setShortDescription(ProStringUtil.markWithPro("Runs single changeset"));
    }

    public void run(CommandResultsBuilder commandResultsBuilder) {
        LicenseServiceUtils.checkProLicenseAndThrowException((String[])COMMAND_NAME);
        Logger logger = Scope.getCurrentScope().getLog(((Object)((Object)this)).getClass());
        CommandScope commandScope = commandResultsBuilder.getCommandScope();
        this.setup(commandScope);
        commandScope = new ChangeLogParameters(this.database);
        DatabaseChangeLog databaseChangeLog = UpdateOneChangeSetCommandStep.parseChangeLogFile(this.changeSetPath, (ChangeLogParameters)commandScope);
        databaseChangeLog.validate(this.database, commandScope.getContexts(), commandScope.getLabels());
        SinglePendingChangeSetFilter singlePendingChangeSetFilter = new SinglePendingChangeSetFilter(this.changeSetId, this.changeSetAuthor, this.changeSetPath, databaseChangeLog);
        ShouldRunChangeSetFilter shouldRunChangeSetFilter = new ShouldRunChangeSetFilter(this.database, true);
        ChangeLogIterator changeLogIterator = new ChangeLogIterator(databaseChangeLog, new ChangeSetFilter[]{singlePendingChangeSetFilter, shouldRunChangeSetFilter});
        singlePendingChangeSetFilter = new ChangeLogIterator(databaseChangeLog, new ChangeSetFilter[]{singlePendingChangeSetFilter, shouldRunChangeSetFilter});
        shouldRunChangeSetFilter = new Liquibase(databaseChangeLog, Scope.getCurrentScope().getResourceAccessor(), this.database).getConnection(databaseChangeLog);
        boolean bl2 = shouldRunChangeSetFilter != null && this.writer == null;
        databaseChangeLog = new HubUpdater(new Date(), databaseChangeLog, this.database);
        Operation operation = null;
        BufferedLogService bufferedLogService = new BufferedLogService();
        CompositeLogService compositeLogService = new CompositeLogService(true, new LogService[]{bufferedLogService});
        this.setupSqlLogging();
        try {
            UpdateOneChangeSetCommandStep updateOneChangeSetCommandStep = this;
            updateOneChangeSetCommandStep.setupExecutionServices(updateOneChangeSetCommandStep.database);
            if (bl2) {
                operation = databaseChangeLog.preUpdateHub("UPDATE", COMMAND_NAME[0], (Connection)shouldRunChangeSetFilter, this.changeSetPath, commandScope.getContexts(), commandScope.getLabels(), (ChangeLogIterator)singlePendingChangeSetFilter);
                this.changeExecListener = new HubChangeExecListener(operation, this.changeExecListener);
            }
            singlePendingChangeSetFilter = new UpdateVisitor(this.database, this.changeExecListener);
            Scope.child((String)Scope.Attr.logService.name(), (Object)compositeLogService, () -> this.lambda$run$0(changeLogIterator, (UpdateVisitor)singlePendingChangeSetFilter, (ChangeLogParameters)commandScope));
            if (bl2) {
                databaseChangeLog.postUpdateHub(operation, bufferedLogService);
            }
            commandResultsBuilder.addResult("statusCode", (Object)0);
            return;
        }
        catch (SQLException | LiquibaseException throwable) {
            if (bl2) {
                databaseChangeLog.postUpdateHubExceptionHandling(operation, bufferedLogService, throwable.getMessage());
            }
            throw new RuntimeException(throwable);
        }
        finally {
            try {
                LockServiceFactory.getInstance().getLockService(this.database).releaseLock();
            }
            catch (LockException lockException) {
                logger.severe(coreBundle.getString("could.not.release.lock"), (Throwable)lockException);
            }
            this.resetExecutionServices();
        }
    }

    private void setup(CommandScope commandScope) {
        String string = (String)commandScope.getArgumentValue(URL_ARG);
        String string2 = (String)commandScope.getArgumentValue(USERNAME_ARG);
        String string3 = (String)commandScope.getArgumentValue(PASSWORD_ARG);
        String string4 = (String)commandScope.getArgumentValue(DEFAULT_SCHEMA_NAME_ARG);
        String string5 = (String)commandScope.getArgumentValue(DEFAULT_CATALOG_NAME_ARG);
        String string6 = (String)commandScope.getArgumentValue(DRIVER_ARG);
        String string7 = (String)commandScope.getArgumentValue(DRIVER_PROPERTIES_FILE_ARG);
        this.database = LazyDatabaseSnapshot.createDatabaseObject(string, string2, string3, string4, string5, string6, string7);
        this.changeSetId = (String)commandScope.getArgumentValue(CHANGESET_ID);
        this.changeSetAuthor = (String)commandScope.getArgumentValue(CHANGESET_AUTHOR);
        this.changeSetPath = (String)commandScope.getArgumentValue(CHANGESET_PATH);
        this.force = (Boolean)commandScope.getArgumentValue(FORCE);
        this.checkArgs();
    }

    private void checkArgs() {
        if (this.changeSetId == null || this.changeSetAuthor == null || this.changeSetPath == null) {
            throw new LiquibaseException(coreBundle.getString("id.author.path.required"));
        }
        if (!(this.writer != null || this.force != null && this.force.booleanValue())) {
            String string = "\nWARNING: Targeted update of this changeset may result in unexpected outcomes.  To review the update\nSQL before executing it, please run 'update-one-changeset-sql'. This message can be suppressed by adding the --force flag.";
            throw new LiquibaseException(string);
        }
    }

    private static DatabaseChangeLog parseChangeLogFile(String string, ChangeLogParameters changeLogParameters) {
        ResourceAccessor resourceAccessor = Scope.getCurrentScope().getResourceAccessor();
        return ChangeLogParserFactory.getInstance().getParser(string, resourceAccessor).parse(string, changeLogParameters, resourceAccessor);
    }

    private void resetExecutionServices() {
        LockServiceFactory.getInstance().resetAll();
        ((ExecutorService)Scope.getCurrentScope().getSingleton(ExecutorService.class)).reset();
        ChangeLogHistoryServiceFactory.getInstance().resetAll();
    }

    private void setupExecutionServices(Database database) {
        LockServiceFactory.getInstance().getLockService(database).waitForLock();
        database = ChangeLogHistoryServiceFactory.getInstance().getChangeLogService(database);
        database.init();
        database.generateDeploymentId();
    }

    public void setWriter(Writer writer) {
        this.writer = writer;
    }

    private void setupSqlLogging() {
        if (this.writer != null) {
            Executor executor = ((ExecutorService)Scope.getCurrentScope().getSingleton(ExecutorService.class)).getExecutor("jdbc", this.database);
            executor = new LoggingExecutor(executor, this.writer, this.database);
            ((ExecutorService)Scope.getCurrentScope().getSingleton(ExecutorService.class)).setExecutor("jdbc", this.database, executor);
            ((ExecutorService)Scope.getCurrentScope().getSingleton(ExecutorService.class)).setExecutor("logging", this.database, executor);
        }
    }

    private /* synthetic */ void lambda$run$0(ChangeLogIterator changeLogIterator, UpdateVisitor updateVisitor, ChangeLogParameters changeLogParameters) {
        changeLogIterator.run((ChangeSetVisitor)updateVisitor, new RuntimeEnvironment(this.database, changeLogParameters.getContexts(), changeLogParameters.getLabels()));
    }

    static {
        coreBundle = ResourceBundle.getBundle("liquibase/i18n/liquibase-core");
        CommandBuilder commandBuilder = new CommandBuilder((String[][])new String[][]{COMMAND_NAME});
        CHANGESET_ID = commandBuilder.argument("changesetId", String.class).description("Id of the changeset to execute").required().build();
        CHANGESET_AUTHOR = commandBuilder.argument("changesetAuthor", String.class).description("Author of the changeset to execute").required().build();
        CHANGESET_PATH = commandBuilder.argument("changesetPath", String.class).description("Path to the changeset to execute").required().build();
        FORCE = commandBuilder.argument("force", Boolean.class).description("A required safety flag to indicate you intend to use this feature").defaultValue((Object)Boolean.FALSE).build();
        URL_ARG = commandBuilder.argument(CommonArgumentNames.URL, String.class).required().description("The JDBC target database connection URL").build();
        DEFAULT_SCHEMA_NAME_ARG = commandBuilder.argument("defaultSchemaName", String.class).description("The default schema name to use for the database connection").build();
        DEFAULT_CATALOG_NAME_ARG = commandBuilder.argument("defaultCatalogName", String.class).description("The default catalog name to use for the database connection").build();
        DRIVER_ARG = commandBuilder.argument("driver", String.class).description("The JDBC driver class").build();
        DRIVER_PROPERTIES_FILE_ARG = commandBuilder.argument("driverPropertiesFile", String.class).description("The JDBC driver properties file").build();
        USERNAME_ARG = commandBuilder.argument(CommonArgumentNames.USERNAME, String.class).description("The target database username").build();
        PASSWORD_ARG = commandBuilder.argument(CommonArgumentNames.PASSWORD, String.class).description("The target database password").setValueObfuscator(ConfigurationValueObfuscator.STANDARD).build();
    }
}

