/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.tools;

import com.datical.liquibase.ext.tools.AbstractNativeToolExecutor;
import com.datical.liquibase.ext.tools.SqlcmdRunner;
import java.util.List;
import liquibase.Scope;
import liquibase.exception.DatabaseException;
import liquibase.sql.Sql;
import liquibase.sql.visitor.SqlVisitor;
import liquibase.sqlgenerator.SqlGeneratorFactory;
import liquibase.statement.SqlStatement;

public class MssqlSqlcmdExecutor
extends AbstractNativeToolExecutor {
    public MssqlSqlcmdExecutor() {
        super("sqlcmd");
    }

    public String getName() {
        return "sqlcmd";
    }

    public int getPriority() {
        return 101;
    }

    public void execute(SqlStatement object, List<SqlVisitor> logger) {
        logger = Scope.getCurrentScope().getLog(((Object)((Object)this)).getClass());
        logger.info("Executing with the '" + this.getName() + "' executor");
        object = SqlGeneratorFactory.getInstance().generateSql((SqlStatement)object, this.database);
        try {
            SqlcmdRunner sqlcmdRunner = new SqlcmdRunner(this.changeSet, null);
            sqlcmdRunner.addArg("-?");
            sqlcmdRunner.executeCommand(this.database);
            logger.info("Successfully validated 'sqlcmd'");
            new SqlcmdRunner(this.changeSet, (Sql[])object).executeCommand(this.database);
            object = String.format("%nSuccess!  Changeset '%s' by '%s' deployed by 'sqlcmd'", this.changeSet.getId(), this.changeSet.getAuthor());
            logger.info((String)object);
            return;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw illegalArgumentException;
        }
        catch (Exception exception) {
            object = String.format("%nChangeset '%s' by '%s' failed to deploy with 'sqlcmd'. Please check sqlcmd logs or use the --log-level flag for more information.", this.changeSet.getId(), this.changeSet.getAuthor());
            logger.warning((String)object);
            throw new DatabaseException((Throwable)exception);
        }
    }
}

