/*
 * Decompiled with CFR 0.152.
 */
package liquibase.configuration.pro;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import liquibase.Scope;
import liquibase.SingletonObject;
import liquibase.configuration.ConfigurationDefinition;
import liquibase.configuration.pro.UnlicensedVariableList;
import liquibase.servicelocator.ServiceLocator;

public class UnlicensedVariableFactory
implements SingletonObject {
    private final List<UnlicensedVariableList> allLists = new ArrayList<UnlicensedVariableList>();

    private UnlicensedVariableFactory() {
        ServiceLocator serviceLocator = Scope.getCurrentScope().getServiceLocator();
        this.allLists.addAll(serviceLocator.findInstances(UnlicensedVariableList.class));
    }

    private Set<ConfigurationDefinition<?>> getUnlicensedVariables() {
        HashSet hashSet = new HashSet();
        for (UnlicensedVariableList unlicensedVariableList : this.allLists) {
            hashSet.addAll(unlicensedVariableList.getUnlicensedVariables());
        }
        return hashSet;
    }

    public boolean isUnlicensed(ConfigurationDefinition<?> configurationDefinition) {
        return this.getUnlicensedVariables().contains(configurationDefinition);
    }
}

