/*
 * Decompiled with CFR 0.152.
 */
package liquibase.repackaged.net.sf.jsqlparser.util.deparser;

import java.util.Iterator;
import java.util.stream.Collectors;
import liquibase.repackaged.net.sf.jsqlparser.expression.ExpressionVisitor;
import liquibase.repackaged.net.sf.jsqlparser.expression.ExpressionVisitorAdapter;
import liquibase.repackaged.net.sf.jsqlparser.schema.Table;
import liquibase.repackaged.net.sf.jsqlparser.statement.delete.Delete;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.Join;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.PlainSelect;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.WithItem;
import liquibase.repackaged.net.sf.jsqlparser.util.deparser.AbstractDeParser;
import liquibase.repackaged.net.sf.jsqlparser.util.deparser.LimitDeparser;
import liquibase.repackaged.net.sf.jsqlparser.util.deparser.OrderByDeParser;

public class DeleteDeParser
extends AbstractDeParser<Delete> {
    private ExpressionVisitor expressionVisitor = new ExpressionVisitorAdapter();

    public DeleteDeParser() {
        super(new StringBuilder());
    }

    public DeleteDeParser(ExpressionVisitor expressionVisitor, StringBuilder stringBuilder) {
        super(stringBuilder);
        this.expressionVisitor = expressionVisitor;
    }

    @Override
    public void deParse(Delete delete) {
        if (delete.getWithItemsList() != null && !delete.getWithItemsList().isEmpty()) {
            this.buffer.append("WITH ");
            Iterator<Object> iterator = delete.getWithItemsList().iterator();
            while (iterator.hasNext()) {
                WithItem object = iterator.next();
                this.buffer.append(object);
                if (iterator.hasNext()) {
                    this.buffer.append(",");
                }
                this.buffer.append(" ");
            }
        }
        this.buffer.append("DELETE");
        if (delete.getModifierPriority() != null) {
            this.buffer.append(" ").append((Object)delete.getModifierPriority());
        }
        if (delete.isModifierQuick()) {
            this.buffer.append(" QUICK");
        }
        if (delete.isModifierIgnore()) {
            this.buffer.append(" IGNORE");
        }
        if (delete.getTables() != null && !delete.getTables().isEmpty()) {
            this.buffer.append(delete.getTables().stream().map(Table::getFullyQualifiedName).collect(Collectors.joining(", ", " ", "")));
        }
        if (delete.getOutputClause() != null) {
            delete.getOutputClause().appendTo(this.buffer);
        }
        if (delete.isHasFrom()) {
            this.buffer.append(" FROM");
        }
        this.buffer.append(" ").append(delete.getTable().toString());
        if (delete.getUsingList() != null && !delete.getUsingList().isEmpty()) {
            this.buffer.append(" USING").append(delete.getUsingList().stream().map(Table::toString).collect(Collectors.joining(", ", " ", "")));
        }
        if (delete.getJoins() != null) {
            for (Join join : delete.getJoins()) {
                if (join.isSimple()) {
                    this.buffer.append(", ").append(join);
                    continue;
                }
                this.buffer.append(" ").append(join);
            }
        }
        if (delete.getWhere() != null) {
            this.buffer.append(" WHERE ");
            delete.getWhere().accept(this.expressionVisitor);
        }
        if (delete.getOrderByElements() != null) {
            new OrderByDeParser(this.expressionVisitor, this.buffer).deParse(delete.getOrderByElements());
        }
        if (delete.getLimit() != null) {
            new LimitDeparser(this.buffer).deParse(delete.getLimit());
        }
        if (delete.getReturningExpressionList() != null) {
            this.buffer.append(" RETURNING ").append(PlainSelect.getStringList(delete.getReturningExpressionList(), true, false));
        }
    }

    public ExpressionVisitor getExpressionVisitor() {
        return this.expressionVisitor;
    }

    public void setExpressionVisitor(ExpressionVisitor expressionVisitor) {
        this.expressionVisitor = expressionVisitor;
    }
}

