/*
 * Decompiled with CFR 0.152.
 */
package liquibase.pro.packaged;

import java.util.Arrays;
import java.util.BitSet;
import java.util.concurrent.atomic.AtomicReference;
import liquibase.pro.packaged.av;
import liquibase.pro.packaged.cH;
import liquibase.pro.packaged.cs;
import liquibase.pro.packaged.ct;

public final class cr {
    public static final int HASH_MULT = 33;
    private static final int DEFAULT_T_SIZE = 64;
    private static final int MAX_T_SIZE = 65536;
    static final int MAX_ENTRIES_FOR_REUSE = 12000;
    static final int MAX_COLL_CHAIN_LENGTH = 150;
    protected final cr _parent;
    protected final AtomicReference<ct> _tableInfo;
    protected final int _seed;
    protected final int _flags;
    protected boolean _canonicalize;
    protected String[] _symbols;
    protected cs[] _buckets;
    protected int _size;
    protected int _sizeThreshold;
    protected int _indexMask;
    protected int _longestCollisionList;
    protected boolean _hashShared;
    protected BitSet _overflows;

    private cr(int n2) {
        this._parent = null;
        this._seed = n2;
        this._canonicalize = true;
        this._flags = -1;
        this._hashShared = false;
        this._longestCollisionList = 0;
        this._tableInfo = new AtomicReference<ct>(ct.createInitial(64));
    }

    private cr(cr cr2, int n2, int n3, ct ct2) {
        this._parent = cr2;
        this._seed = n3;
        this._tableInfo = null;
        this._flags = n2;
        this._canonicalize = av.CANONICALIZE_FIELD_NAMES.enabledIn(n2);
        this._symbols = ct2.symbols;
        this._buckets = ct2.buckets;
        this._size = ct2.size;
        this._longestCollisionList = ct2.longestCollisionList;
        int n4 = this._symbols.length;
        this._sizeThreshold = cr._thresholdSize(n4);
        this._indexMask = n4 - 1;
        this._hashShared = true;
    }

    private static int _thresholdSize(int n2) {
        int n3 = n2;
        return n3 - (n3 >> 2);
    }

    public static cr createRoot() {
        long l2 = System.currentTimeMillis();
        return cr.createRoot((int)l2 + (int)(l2 >>> 32) | 1);
    }

    protected static cr createRoot(int n2) {
        return new cr(n2);
    }

    public final cr makeChild(int n2) {
        return new cr(this, n2, this._seed, this._tableInfo.get());
    }

    public final void release() {
        if (!this.maybeDirty()) {
            return;
        }
        if (this._parent != null && this._canonicalize) {
            this._parent.mergeChild(new ct(this));
            this._hashShared = true;
        }
    }

    private void mergeChild(ct ct2) {
        int n2 = ct2.size;
        ct ct3 = this._tableInfo.get();
        if (n2 == ct3.size) {
            return;
        }
        if (n2 > 12000) {
            ct2 = ct.createInitial(64);
        }
        this._tableInfo.compareAndSet(ct3, ct2);
    }

    public final int size() {
        if (this._tableInfo != null) {
            return this._tableInfo.get().size;
        }
        return this._size;
    }

    public final int bucketCount() {
        return this._symbols.length;
    }

    public final boolean maybeDirty() {
        return !this._hashShared;
    }

    public final int hashSeed() {
        return this._seed;
    }

    public final int collisionCount() {
        int n2 = 0;
        cs[] csArray = this._buckets;
        int n3 = this._buckets.length;
        for (int i2 = 0; i2 < n3; ++i2) {
            cs cs2 = csArray[i2];
            if (cs2 == null) continue;
            n2 += cs2.length;
        }
        return n2;
    }

    public final int maxCollisionLength() {
        return this._longestCollisionList;
    }

    public final String findSymbol(char[] cArray, int n2, int n3, int n4) {
        if (n3 <= 0) {
            return "";
        }
        if (!this._canonicalize) {
            return new String(cArray, n2, n3);
        }
        int n5 = this._hashToIndex(n4);
        String string = this._symbols[n5];
        if (string != null) {
            cs cs2;
            if (string.length() == n3) {
                int n6 = 0;
                while (string.charAt(n6) == cArray[n2 + n6]) {
                    if (++n6 != n3) continue;
                    return string;
                }
            }
            if ((cs2 = this._buckets[n5 >> 1]) != null) {
                string = cs2.has(cArray, n2, n3);
                if (string != null) {
                    return string;
                }
                string = this._findSymbol2(cArray, n2, n3, cs2.next);
                if (string != null) {
                    return string;
                }
            }
        }
        return this._addSymbol(cArray, n2, n3, n4, n5);
    }

    private String _findSymbol2(char[] cArray, int n2, int n3, cs cs2) {
        while (cs2 != null) {
            String string = cs2.has(cArray, n2, n3);
            if (string != null) {
                return string;
            }
            cs2 = cs2.next;
        }
        return null;
    }

    private String _addSymbol(char[] object, int n2, int n3, int n4, int n5) {
        if (this._hashShared) {
            this.copyArrays();
            this._hashShared = false;
        } else if (this._size >= this._sizeThreshold) {
            this.rehash();
            cr cr2 = this;
            n5 = cr2._hashToIndex(cr2.calcHash((char[])object, n2, n3));
        }
        object = new String((char[])object, n2, n3);
        if (av.INTERN_FIELD_NAMES.enabledIn(this._flags)) {
            object = cH.instance.intern((String)object);
        }
        ++this._size;
        if (this._symbols[n5] == null) {
            this._symbols[n5] = object;
        } else {
            n2 = n5 >> 1;
            cs cs2 = new cs((String)object, this._buckets[n2]);
            n4 = cs2.length;
            if (n4 > 150) {
                this._handleSpillOverflow(n2, cs2, n5);
            } else {
                this._buckets[n2] = cs2;
                this._longestCollisionList = Math.max(n4, this._longestCollisionList);
            }
        }
        return object;
    }

    /*
     * Unable to fully structure code
     */
    private void _handleSpillOverflow(int var1_1, cs var2_2, int var3_3) {
        block3: {
            if (this._overflows != null) break block3;
            this._overflows = new BitSet();
            ** GOTO lbl-1000
        }
        if (this._overflows.get(var1_1)) {
            if (av.FAIL_ON_SYMBOL_HASH_OVERFLOW.enabledIn(this._flags)) {
                this._reportTooManyCollisions(150);
            }
            this._canonicalize = false;
        } else lbl-1000:
        // 2 sources

        {
            this._overflows.set(var1_1);
        }
        this._symbols[var3_3] = var2_2.symbol;
        this._buckets[var1_1] = null;
        this._size -= var2_2.length;
        this._longestCollisionList = -1;
    }

    public final int _hashToIndex(int n2) {
        int n3 = n2;
        int n4 = n3 + (n3 >>> 15);
        int n5 = n4 ^ n4 << 7;
        return n5 + (n5 >>> 3) & this._indexMask;
    }

    public final int calcHash(char[] cArray, int n2, int n3) {
        int n4 = this._seed;
        int n5 = n2;
        n2 += n3;
        while (n5 < n2) {
            n4 = n4 * 33 + cArray[n5];
            ++n5;
        }
        if (n4 == 0) {
            return 1;
        }
        return n4;
    }

    public final int calcHash(String string) {
        int n2 = string.length();
        int n3 = this._seed;
        for (int i2 = 0; i2 < n2; ++i2) {
            n3 = n3 * 33 + string.charAt(i2);
        }
        if (n3 == 0) {
            return 1;
        }
        return n3;
    }

    private void copyArrays() {
        Object[] objectArray = this._symbols;
        this._symbols = Arrays.copyOf(objectArray, objectArray.length);
        objectArray = this._buckets;
        this._buckets = (cs[])Arrays.copyOf(objectArray, objectArray.length);
    }

    private void rehash() {
        int n2;
        int n3 = this._symbols.length;
        int n4 = n3 + n3;
        if (n4 > 65536) {
            this._size = 0;
            this._canonicalize = false;
            this._symbols = new String[64];
            this._buckets = new cs[32];
            this._indexMask = 63;
            this._hashShared = false;
            return;
        }
        Object object = this._symbols;
        cs[] csArray = this._buckets;
        this._symbols = new String[n4];
        this._buckets = new cs[n4 >> 1];
        this._indexMask = n4 - 1;
        this._sizeThreshold = cr._thresholdSize(n4);
        n4 = 0;
        int n5 = 0;
        for (n2 = 0; n2 < n3; ++n2) {
            cs cs2;
            String string = object[n2];
            if (string == null) continue;
            ++n4;
            cr cr2 = this;
            int n6 = cr2._hashToIndex(cr2.calcHash(string));
            if (this._symbols[n6] == null) {
                this._symbols[n6] = string;
                continue;
            }
            int n7 = n6 >> 1;
            this._buckets[n7] = cs2 = new cs(string, this._buckets[n7]);
            n5 = Math.max(n5, cs2.length);
        }
        n2 = n3 >> 1;
        for (int i2 = 0; i2 < n2; ++i2) {
            cs cs3 = csArray[i2];
            while (cs3 != null) {
                ++n4;
                String string = cs3.symbol;
                cr cr3 = this;
                int n8 = cr3._hashToIndex(cr3.calcHash(string));
                if (this._symbols[n8] == null) {
                    this._symbols[n8] = string;
                } else {
                    n3 = n8 >> 1;
                    this._buckets[n3] = object = new cs(string, this._buckets[n3]);
                    n5 = Math.max(n5, object.length);
                }
                cs3 = cs3.next;
            }
        }
        this._longestCollisionList = n5;
        this._overflows = null;
        if (n4 != this._size) {
            throw new IllegalStateException(String.format("Internal error on SymbolTable.rehash(): had %d entries; now have %d", this._size, n4));
        }
    }

    protected final void _reportTooManyCollisions(int n2) {
        throw new IllegalStateException("Longest collision chain in symbol table (of size " + this._size + ") now exceeds maximum, " + n2 + " -- suspect a DoS attack based on hash collisions");
    }

    protected final void verifyInternalConsistency() {
        int n2;
        int n3 = 0;
        int n4 = this._symbols.length;
        for (n2 = 0; n2 < n4; ++n2) {
            if (this._symbols[n2] == null) continue;
            ++n3;
        }
        n2 = n4 >> 1;
        for (int i2 = 0; i2 < n2; ++i2) {
            cs cs2 = this._buckets[i2];
            while (cs2 != null) {
                ++n3;
                cs2 = cs2.next;
            }
        }
        if (n3 != this._size) {
            throw new IllegalStateException(String.format("Internal error: expected internal size %d vs calculated count %d", this._size, n3));
        }
    }
}

