/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.command;

import com.datical.liquibase.ext.changelog.filter.SingleRanChangeSetFilter;
import com.datical.liquibase.ext.command.InternalRollbackOneChangesetCommandStep$1;
import com.datical.liquibase.ext.command.RollbackOneChangesetCommandStep;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Level;
import liquibase.Contexts;
import liquibase.LabelExpression;
import liquibase.Liquibase;
import liquibase.RuntimeEnvironment;
import liquibase.Scope;
import liquibase.change.Change;
import liquibase.change.core.RawSQLChange;
import liquibase.changelog.ChangeLogHistoryServiceFactory;
import liquibase.changelog.ChangeLogIterator;
import liquibase.changelog.ChangeLogParameters;
import liquibase.changelog.ChangeSet;
import liquibase.changelog.DatabaseChangeLog;
import liquibase.changelog.RanChangeSet;
import liquibase.changelog.filter.AlreadyRanChangeSetFilter;
import liquibase.changelog.filter.ChangeSetFilter;
import liquibase.changelog.filter.ContextChangeSetFilter;
import liquibase.changelog.filter.DbmsChangeSetFilter;
import liquibase.changelog.filter.IgnoreChangeSetFilter;
import liquibase.changelog.filter.LabelChangeSetFilter;
import liquibase.changelog.visitor.ChangeExecListener;
import liquibase.changelog.visitor.ChangeSetVisitor;
import liquibase.changelog.visitor.RollbackVisitor;
import liquibase.command.AbstractCommandStep;
import liquibase.command.CommandArgumentDefinition;
import liquibase.command.CommandBuilder;
import liquibase.command.CommandDefinition;
import liquibase.command.CommandResultsBuilder;
import liquibase.command.CommandScope;
import liquibase.command.CommonArgumentNames;
import liquibase.database.Database;
import liquibase.exception.DatabaseException;
import liquibase.exception.LiquibaseException;
import liquibase.exception.LockException;
import liquibase.exception.RollbackImpossibleException;
import liquibase.executor.Executor;
import liquibase.executor.ExecutorService;
import liquibase.executor.LoggingExecutor;
import liquibase.hub.HubUpdater;
import liquibase.hub.listener.HubChangeExecListener;
import liquibase.hub.model.Connection;
import liquibase.hub.model.Operation;
import liquibase.license.LicenseServiceUtils;
import liquibase.lockservice.LockService;
import liquibase.lockservice.LockServiceFactory;
import liquibase.logging.LogService;
import liquibase.logging.Logger;
import liquibase.logging.core.BufferedLogService;
import liquibase.logging.core.CompositeLogService;
import liquibase.logging.mdc.CustomMdcObject;
import liquibase.logging.mdc.customobjects.ChangesetsRolledback;
import liquibase.parser.ChangeLogParserFactory;
import liquibase.resource.Resource;
import liquibase.resource.ResourceAccessor;
import liquibase.util.StreamUtil;

public class InternalRollbackOneChangesetCommandStep
extends AbstractCommandStep {
    private static final ResourceBundle coreBundle = ResourceBundle.getBundle("liquibase/i18n/liquibase-core");
    protected static final String MSG_COULD_NOT_RELEASE_LOCK = coreBundle.getString("could.not.release.lock");
    public static final String[] COMMAND_NAME = new String[]{"internalRollbackOneChangeset"};
    public static final CommandArgumentDefinition<String> CHANGE_LOG_FILE_ARG;
    public static final CommandArgumentDefinition<String> CHANGE_SET_ID_ARG;
    public static final CommandArgumentDefinition<String> CHANGE_SET_AUTHOR_ARG;
    public static final CommandArgumentDefinition<String> CHANGE_SET_PATH_ARG;
    public static final CommandArgumentDefinition<Boolean> FORCE_ARG;
    public static final CommandArgumentDefinition<Writer> OUTPUT_WRITER_ARG;
    public static final CommandArgumentDefinition<String> ROLLBACK_SCRIPT_ARG;
    public static final CommandArgumentDefinition<Database> DATABASE_ARG;
    public static final CommandArgumentDefinition<Liquibase> LIQUIBASE_ARG;
    public static final CommandArgumentDefinition<ChangeLogParameters> CHANGE_LOG_PARAMETERS_ARG;
    public static final CommandArgumentDefinition<Boolean> SHOULD_LOG_MDC_CHANGESETS_ROLLED_BACK;
    private Database database;
    private Writer outputWriter;
    private Contexts contexts;
    private LabelExpression labelExpression;
    private ChangeLogParameters changeLogParameters;
    private ChangeExecListener changeExecListener;
    private DatabaseChangeLog changeLog;

    public String[][] defineCommandNames() {
        return new String[][]{COMMAND_NAME};
    }

    public void adjustCommandDefinition(CommandDefinition commandDefinition) {
        super.adjustCommandDefinition(commandDefinition);
        commandDefinition.setInternal(true);
    }

    protected RollbackVisitor createRollbackVisitor(List<ChangesetsRolledback.ChangeSet> list) {
        return new RollbackVisitor(this.database, this.changeExecListener, list);
    }

    protected void removeRunStatus(ChangeLogIterator changeLogIterator, Contexts contexts, LabelExpression labelExpression) {
        changeLogIterator.run((ChangeSetVisitor)new InternalRollbackOneChangesetCommandStep$1(this), new RuntimeEnvironment(this.database, contexts, labelExpression));
    }

    public void setOutputWriter(Writer writer) {
        this.outputWriter = writer;
    }

    public void run(CommandResultsBuilder object) {
        Object object2;
        LicenseServiceUtils.checkProLicenseAndThrowException((String[])RollbackOneChangesetCommandStep.COMMAND_NAME);
        Logger logger = Scope.getCurrentScope().getLog(((Object)((Object)this)).getClass());
        CommandScope commandScope = object.getCommandScope();
        String string = (String)commandScope.getArgumentValue(CHANGE_SET_ID_ARG);
        String string2 = (String)commandScope.getArgumentValue(CHANGE_SET_AUTHOR_ARG);
        String string3 = (String)commandScope.getArgumentValue(CHANGE_SET_PATH_ARG);
        if (string == null || string2 == null || string3 == null) {
            throw new LiquibaseException(coreBundle.getString("id.author.path.required"));
        }
        Boolean bl2 = (Boolean)commandScope.getArgumentValue(FORCE_ARG);
        if (bl2 == null || !bl2.booleanValue()) {
            String string4 = "\nWARNING: Targeted rollback of this changeset may result in unexpected outcomes.  To review the rollback\nSQL before executing it, please run 'rollback-one-changeset-sql'. This message can be suppressed by adding the --force flag.";
            throw new LiquibaseException(string4, Level.WARNING);
        }
        String string5 = (String)commandScope.getArgumentValue(ROLLBACK_SCRIPT_ARG);
        this.changeLogParameters = (ChangeLogParameters)commandScope.getArgumentValue(CHANGE_LOG_PARAMETERS_ARG);
        Object object3 = (String)commandScope.getArgumentValue(CHANGE_LOG_FILE_ARG);
        this.changeLog = this.parseChangeLogFile((String)object3, this.changeLogParameters);
        Object object4 = (Liquibase)commandScope.getArgumentValue(LIQUIBASE_ARG);
        this.database = (Database)commandScope.getArgumentValue(DATABASE_ARG);
        bl2 = (Boolean)commandScope.getArgumentValue(FORCE_ARG);
        Scope.getCurrentScope().addMdcValue("rollbackScript", string5);
        Scope.getCurrentScope().addMdcValue("liquibaseTargetUrl", this.database.getConnection().getURL());
        Scope.getCurrentScope().addMdcValue("rollbackOneChangesetForce", String.valueOf(bl2));
        bl2 = null;
        if (this.outputWriter != null) {
            bl2 = ((ExecutorService)Scope.getCurrentScope().getSingleton(ExecutorService.class)).getExecutor("jdbc", this.database);
            object2 = new LoggingExecutor((Executor)bl2, this.outputWriter, this.database);
            ((ExecutorService)Scope.getCurrentScope().getSingleton(ExecutorService.class)).setExecutor("jdbc", this.database, (Executor)object2);
            ((ExecutorService)Scope.getCurrentScope().getSingleton(ExecutorService.class)).setExecutor("logging", this.database, (Executor)object2);
        } else {
            object2 = new LoggingExecutor((Executor)bl2, null, this.database);
        }
        ((ExecutorService)Scope.getCurrentScope().getSingleton(ExecutorService.class)).setExecutor("logging", this.database, (Executor)object2);
        Operation operation = null;
        HubUpdater hubUpdater = new HubUpdater(new Date(), this.changeLog, this.database);
        BufferedLogService bufferedLogService = new BufferedLogService();
        SingleRanChangeSetFilter singleRanChangeSetFilter = null;
        LockService lockService = LockServiceFactory.getInstance().getLockService(this.database);
        lockService.waitForLock();
        try {
            this.checkLiquibaseTables();
            this.changeLog.validate(this.database, this.contexts, this.labelExpression);
            List list = this.database.getRanChangeSetList();
            singleRanChangeSetFilter = new SingleRanChangeSetFilter(string, string2, string3, list, this.changeLog);
            if (singleRanChangeSetFilter.isEmpty()) {
                String string6 = "rollback-one-changeset";
                if (this.outputWriter != null) {
                    string6 = "rollback-one-changeset-sql";
                }
                object2 = string3 + "::" + string + "::" + string2;
                object4 = "\n\nWARNING:  The command '" + string6 + "' failed because the targeted changeset\n'" + (String)object2 + "' cannot be located.\nAt least one supplied parameter cannot be found in combination with the other parameters.\nPlease check your details and try again.\n";
                if (singleRanChangeSetFilter.getMatchingIdChangeSet() != null) {
                    object4 = (String)object4 + "\nNOTE:  A changeset with this ID was located.\n";
                }
                object4 = (String)object4 + "No rollback was performed.";
                throw new LiquibaseException((String)object4);
            }
            object2 = this.getChangeSetString(singleRanChangeSetFilter.getMatchingChangeSet());
            object4.outputHeader("Rollback changeset '" + (String)object2 + "'");
            ChangeLogIterator changeLogIterator = this.createChangeLogIterator(list, singleRanChangeSetFilter);
            object4 = this.outputWriter == null ? object4.getConnection(this.changeLog) : null;
            if (object4 != null) {
                operation = hubUpdater.preUpdateHub("ROLLBACK", "rollback-one-changeset", (Connection)object4, (String)object3, this.contexts, this.labelExpression, changeLogIterator);
                this.changeExecListener = new HubChangeExecListener(operation, this.changeExecListener);
            }
            object3 = this.createChangeLogIterator(list, singleRanChangeSetFilter);
            CompositeLogService compositeLogService = new CompositeLogService(true, new LogService[]{bufferedLogService});
            boolean bl3 = (Boolean)commandScope.getArgumentValue(SHOULD_LOG_MDC_CHANGESETS_ROLLED_BACK);
            if (string5 == null) {
                object4 = new ArrayList();
                Scope.child((String)Scope.Attr.logService.name(), (Object)compositeLogService, () -> this.lambda$run$0((ChangeLogIterator)object3, (List)object4));
                if (bl3) {
                    Scope.getCurrentScope().addMdcValue("changesetsRolledback", (CustomMdcObject)new ChangesetsRolledback((List)object4), false);
                }
                object.addResult("processedChangesets", object4);
            } else {
                object4 = singleRanChangeSetFilter.getMatchingChangeSet();
                this.executeRollbackScript(string5, (ChangeSet)object4, this.contexts, this.labelExpression);
                this.removeRunStatus((ChangeLogIterator)object3, this.contexts, this.labelExpression);
                object3 = Collections.singletonList(ChangesetsRolledback.ChangeSet.fromChangeSet((ChangeSet)object4));
                if (bl3) {
                    Scope.getCurrentScope().addMdcValue("changesetsRolledback", (CustomMdcObject)new ChangesetsRolledback(object3));
                }
                object.addResult("processedChangesets", object3);
                logger.info("Executed rollback script ".concat(String.valueOf(string5)));
            }
            hubUpdater.postUpdateHub(operation, bufferedLogService);
            object4 = Scope.getCurrentScope().getMdcManager().put("deploymentOutcome", "success");
            object3 = null;
            try {
                Scope.getCurrentScope().getLog(((Object)((Object)this)).getClass()).info("Rollback command completed successfully.");
            }
            catch (Throwable throwable) {
                object = throwable;
                object3 = throwable;
                throw object;
            }
            finally {
                if (object4 != null) {
                    if (object3 != null) {
                        try {
                            object4.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object3).addSuppressed(throwable);
                        }
                    } else {
                        object4.close();
                    }
                }
            }
        }
        catch (LiquibaseException liquibaseException) {
            hubUpdater.postUpdateHubExceptionHandling(operation, bufferedLogService, liquibaseException.getMessage());
            object2 = singleRanChangeSetFilter != null && !singleRanChangeSetFilter.isEmpty() ? this.getChangeSetString(singleRanChangeSetFilter.getMatchingChangeSet()) : string3 + "::" + string + "::" + string2;
            Throwable throwable = liquibaseException.getCause();
            object4 = Scope.getCurrentScope().addMdcValue("deploymentOutcome", "fail");
            object3 = null;
            try {
                Scope.getCurrentScope().getLog(((Object)((Object)this)).getClass()).info("Rollback command encountered an exception.");
            }
            catch (Throwable throwable2) {
                Throwable throwable3 = throwable2;
                object3 = throwable2;
                throw throwable3;
            }
            finally {
                if (object4 != null) {
                    if (object3 != null) {
                        try {
                            object4.close();
                        }
                        catch (Throwable throwable4) {
                            ((Throwable)object3).addSuppressed(throwable4);
                        }
                    } else {
                        object4.close();
                    }
                }
            }
            if (throwable instanceof RollbackImpossibleException) {
                logger.severe("\nError executing rollback:\nThe targeted changeset '" + (String)object2 + "' does not have a rollback defined\nPlease add a rollback change or script in the appropriate changeset.  You can also specify a rollback script as an argument to this command.\n", (Throwable)liquibaseException);
                throw new LiquibaseException("\nError executing rollback:\nThe targeted changeset '" + (String)object2 + "' does not have a rollback defined.\nPlease add a rollback change or script in the appropriate changeset.  You can also specify a rollback script as an argument to this command.\n", (Throwable)liquibaseException);
            }
            logger.severe("\nError executing rollback for the targeted changeset '" + (String)object2 + "'.");
            throw new LiquibaseException("\nError executing rollback for the targeted changeset '" + (String)object2 + "':\n" + liquibaseException.getMessage(), (Throwable)liquibaseException);
        }
        finally {
            try {
                lockService.releaseLock();
            }
            catch (LockException lockException) {
                logger.severe(MSG_COULD_NOT_RELEASE_LOCK, (Throwable)lockException);
            }
            if (bl2 != null) {
                ((ExecutorService)Scope.getCurrentScope().getSingleton(ExecutorService.class)).setExecutor("jdbc", this.database, (Executor)bl2);
            }
        }
        this.resetServices();
        Scope.getCurrentScope().getUI().sendMessage("rollback-one-changeset executed for " + this.database.getConnection().getConnectionUserName() + "@" + this.database.getConnection().getURL());
    }

    private String getChangeSetString(ChangeSet changeSet) {
        if (changeSet == null) {
            return null;
        }
        return changeSet.toString(false);
    }

    protected ChangeLogIterator createChangeLogIterator(List<RanChangeSet> list, ChangeSetFilter changeSetFilter) {
        return new ChangeLogIterator(list, this.changeLog, new ChangeSetFilter[]{changeSetFilter, new AlreadyRanChangeSetFilter(list), new ContextChangeSetFilter(this.contexts), new LabelChangeSetFilter(this.labelExpression), new IgnoreChangeSetFilter(), new DbmsChangeSetFilter(this.database)});
    }

    protected void executeRollbackScript(String string, ChangeSet changeSet, Contexts object, LabelExpression labelExpression) {
        Resource resource;
        Executor executor = ((ExecutorService)Scope.getCurrentScope().getSingleton(ExecutorService.class)).getExecutor("jdbc", this.database);
        try {
            resource = Scope.getCurrentScope().getResourceAccessor().get(string);
            if (resource == null) {
                throw new LiquibaseException("WARNING: The rollback script '" + string + "' was not located. Please check your parameters. No rollback was performed.");
            }
            string = StreamUtil.readStreamAsString((InputStream)resource.openInputStream());
        }
        catch (IOException iOException) {
            throw new LiquibaseException("Error reading rollbackScript " + executor + ": " + iOException.getMessage());
        }
        this.changeLogParameters.setContexts(object);
        this.changeLogParameters.setLabels(labelExpression);
        string = this.changeLogParameters.expandExpressions(string, this.changeLog);
        resource = this.buildRawSQLChange(string);
        object = this.getChangeSetString(changeSet);
        try {
            if (this.changeExecListener != null) {
                ((HubChangeExecListener)this.changeExecListener).setRollbackScriptContents(string);
                this.changeExecListener.willRollback(changeSet, this.changeLog, this.database);
            }
            Scope.getCurrentScope().getUI().sendMessage("Rolling Back Changeset:".concat(String.valueOf(object)));
            executor.execute((Change)resource);
            if (this.changeExecListener != null) {
                this.changeExecListener.rolledBack(changeSet, this.changeLog, this.database);
            }
        }
        catch (DatabaseException databaseException) {
            Scope.getCurrentScope().getLog(((Object)((Object)this)).getClass()).severe("Error executing rollback script: " + databaseException.getMessage());
            if (this.changeExecListener != null) {
                this.changeExecListener.rollbackFailed(changeSet, this.changeLog, this.database, (Exception)((Object)databaseException));
            }
            throw new LiquibaseException("\nError executing rollback for the targeted changeset '" + (String)object + "':\n" + databaseException.getMessage(), (Throwable)databaseException);
        }
        this.database.commit();
        if (string.length() == 0) {
            Scope.getCurrentScope().getLog(((Object)((Object)this)).getClass()).info("No rollback logic defined in empty rollback script. Changesets have been removed from\nthe DATABASECHANGELOG table but no other logic was performed.");
        }
    }

    protected RawSQLChange buildRawSQLChange(String string) {
        string = new RawSQLChange(string);
        string.setSplitStatements(Boolean.TRUE);
        string.setStripComments(Boolean.TRUE);
        return string;
    }

    protected void checkLiquibaseTables() {
        ChangeLogHistoryServiceFactory.getInstance().getChangeLogService(this.database).init();
        LockServiceFactory.getInstance().getLockService(this.database).init();
    }

    protected void resetServices() {
        LockServiceFactory.getInstance().resetAll();
        ChangeLogHistoryServiceFactory.getInstance().resetAll();
        ((ExecutorService)Scope.getCurrentScope().getSingleton(ExecutorService.class)).reset();
    }

    private DatabaseChangeLog parseChangeLogFile(String string, ChangeLogParameters changeLogParameters) {
        ResourceAccessor resourceAccessor = Scope.getCurrentScope().getResourceAccessor();
        return ChangeLogParserFactory.getInstance().getParser(string, resourceAccessor).parse(string, changeLogParameters, resourceAccessor);
    }

    private /* synthetic */ void lambda$run$0(ChangeLogIterator changeLogIterator, List list) {
        changeLogIterator.run((ChangeSetVisitor)this.createRollbackVisitor(list), new RuntimeEnvironment(this.database, this.contexts, this.labelExpression));
    }

    static {
        CommandBuilder commandBuilder = new CommandBuilder((String[][])new String[][]{COMMAND_NAME});
        CHANGE_LOG_FILE_ARG = commandBuilder.argument(CommonArgumentNames.CHANGELOG_FILE, String.class).required().build();
        CHANGE_SET_ID_ARG = commandBuilder.argument("changeSetId", String.class).required().build();
        CHANGE_SET_AUTHOR_ARG = commandBuilder.argument("changeSetAuthor", String.class).required().build();
        CHANGE_SET_PATH_ARG = commandBuilder.argument("changeSetPath", String.class).required().build();
        FORCE_ARG = commandBuilder.argument("force", Boolean.class).build();
        ROLLBACK_SCRIPT_ARG = commandBuilder.argument("rollbackScript", String.class).build();
        DATABASE_ARG = commandBuilder.argument("database", Database.class).required().build();
        LIQUIBASE_ARG = commandBuilder.argument("liquibase", Liquibase.class).required().build();
        OUTPUT_WRITER_ARG = commandBuilder.argument("outputWriter", Writer.class).build();
        CHANGE_LOG_PARAMETERS_ARG = commandBuilder.argument("changeLogParameters", ChangeLogParameters.class).build();
        SHOULD_LOG_MDC_CHANGESETS_ROLLED_BACK = commandBuilder.argument("shouldLogMdcChangesetsRolledBack", Boolean.class).hidden().defaultValue((Object)Boolean.TRUE).build();
    }
}

