/*
 * Decompiled with CFR 0.152.
 */
package liquibase.repackaged.net.sf.jsqlparser.util.deparser;

import java.util.Collection;
import java.util.Iterator;
import liquibase.repackaged.net.sf.jsqlparser.Model;
import liquibase.repackaged.net.sf.jsqlparser.expression.Expression;
import liquibase.repackaged.net.sf.jsqlparser.expression.ExpressionVisitor;
import liquibase.repackaged.net.sf.jsqlparser.expression.operators.relational.ExpressionList;
import liquibase.repackaged.net.sf.jsqlparser.expression.operators.relational.ItemsListVisitor;
import liquibase.repackaged.net.sf.jsqlparser.expression.operators.relational.MultiExpressionList;
import liquibase.repackaged.net.sf.jsqlparser.expression.operators.relational.NamedExpressionList;
import liquibase.repackaged.net.sf.jsqlparser.schema.Column;
import liquibase.repackaged.net.sf.jsqlparser.statement.insert.Insert;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.PlainSelect;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.SelectVisitor;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.SubSelect;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.WithItem;
import liquibase.repackaged.net.sf.jsqlparser.util.deparser.AbstractDeParser;
import liquibase.repackaged.net.sf.jsqlparser.util.deparser.ExpressionListDeParser;

public class InsertDeParser
extends AbstractDeParser<Insert>
implements ItemsListVisitor {
    private ExpressionVisitor expressionVisitor;
    private SelectVisitor selectVisitor;

    public InsertDeParser() {
        super(new StringBuilder());
    }

    public InsertDeParser(ExpressionVisitor expressionVisitor, SelectVisitor selectVisitor, StringBuilder stringBuilder) {
        super(stringBuilder);
        this.expressionVisitor = expressionVisitor;
        this.selectVisitor = selectVisitor;
    }

    @Override
    public void deParse(Insert insert) {
        Column column;
        Iterator<Model> iterator;
        if (insert.getWithItemsList() != null && !insert.getWithItemsList().isEmpty()) {
            this.buffer.append("WITH ");
            iterator = insert.getWithItemsList().iterator();
            while (iterator.hasNext()) {
                iterator.next().accept(this.selectVisitor);
                if (iterator.hasNext()) {
                    this.buffer.append(",");
                }
                this.buffer.append(" ");
            }
        }
        this.buffer.append("INSERT ");
        if (insert.getModifierPriority() != null) {
            this.buffer.append((Object)insert.getModifierPriority()).append(" ");
        }
        if (insert.isModifierIgnore()) {
            this.buffer.append("IGNORE ");
        }
        this.buffer.append("INTO ");
        this.buffer.append(insert.getTable().toString());
        if (insert.getColumns() != null) {
            this.buffer.append(" (");
            iterator = insert.getColumns().iterator();
            while (iterator.hasNext()) {
                column = (Column)iterator.next();
                this.buffer.append(column.getColumnName());
                if (!iterator.hasNext()) continue;
                this.buffer.append(", ");
            }
            this.buffer.append(")");
        }
        if (insert.getOutputClause() != null) {
            this.buffer.append(insert.getOutputClause().toString());
        }
        if (insert.getSelect() != null) {
            this.buffer.append(" ");
            if (insert.getSelect().isUsingWithBrackets()) {
                this.buffer.append("(");
            }
            if (insert.getSelect().getWithItemsList() != null) {
                this.buffer.append("WITH ");
                iterator = insert.getSelect().getWithItemsList().iterator();
                while (iterator.hasNext()) {
                    ((WithItem)iterator.next()).accept(this.selectVisitor);
                }
                this.buffer.append(" ");
            }
            insert.getSelect().getSelectBody().accept(this.selectVisitor);
            if (insert.getSelect().isUsingWithBrackets()) {
                this.buffer.append(")");
            }
        }
        if (insert.isUseSet()) {
            this.buffer.append(" SET ");
            for (int i2 = 0; i2 < insert.getSetColumns().size(); ++i2) {
                insert.getSetColumns().get(i2).accept(this.expressionVisitor);
                this.buffer.append(" = ");
                insert.getSetExpressionList().get(i2).accept(this.expressionVisitor);
                if (i2 >= insert.getSetColumns().size() - 1) continue;
                this.buffer.append(", ");
            }
        }
        if (insert.isUseDuplicate()) {
            this.buffer.append(" ON DUPLICATE KEY UPDATE ");
            for (int i3 = 0; i3 < insert.getDuplicateUpdateColumns().size(); ++i3) {
                column = insert.getDuplicateUpdateColumns().get(i3);
                this.buffer.append(column.getFullyQualifiedName()).append(" = ");
                insert.getDuplicateUpdateExpressionList().get(i3).accept(this.expressionVisitor);
                if (i3 >= insert.getDuplicateUpdateColumns().size() - 1) continue;
                this.buffer.append(", ");
            }
        }
        if (insert.getConflictAction() != null) {
            this.buffer.append(" ON CONFLICT");
            if (insert.getConflictTarget() != null) {
                insert.getConflictTarget().appendTo(this.buffer);
            }
            insert.getConflictAction().appendTo(this.buffer);
        }
        if (insert.getReturningExpressionList() != null) {
            this.buffer.append(" RETURNING ").append(PlainSelect.getStringList(insert.getReturningExpressionList(), true, false));
        }
    }

    @Override
    public void visit(ExpressionList expressionList) {
        new ExpressionListDeParser(this.expressionVisitor, this.buffer, expressionList.isUsingBrackets(), true).deParse((Collection<Expression>)expressionList.getExpressions());
    }

    @Override
    public void visit(NamedExpressionList namedExpressionList) {
    }

    @Override
    public void visit(MultiExpressionList iterator) {
        iterator = ((MultiExpressionList)((Object)iterator)).getExpressionLists();
        int n2 = iterator.size() - 1;
        int n3 = 0;
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            ExpressionList expressionList = (ExpressionList)iterator.next();
            new ExpressionListDeParser(this.expressionVisitor, this.buffer, expressionList.isUsingBrackets(), true).deParse((Collection<Expression>)expressionList.getExpressions());
            if (n3 < n2) {
                this.buffer.append(", ");
            }
            ++n3;
        }
    }

    @Override
    public void visit(SubSelect subSelect) {
        subSelect.getSelectBody().accept(this.selectVisitor);
    }

    public ExpressionVisitor getExpressionVisitor() {
        return this.expressionVisitor;
    }

    public SelectVisitor getSelectVisitor() {
        return this.selectVisitor;
    }

    public void setExpressionVisitor(ExpressionVisitor expressionVisitor) {
        this.expressionVisitor = expressionVisitor;
    }

    public void setSelectVisitor(SelectVisitor selectVisitor) {
        this.selectVisitor = selectVisitor;
    }
}

