/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.checks.config;

import com.datical.liquibase.ext.checks.config.FileAccessor;
import com.datical.liquibase.ext.checks.config.FileAccessorDTO;
import com.datical.liquibase.ext.checks.config.FileEncoder;
import com.datical.liquibase.ext.util.ResourceUtil;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.FileAlreadyExistsException;
import liquibase.GlobalConfiguration;
import liquibase.Scope;
import liquibase.exception.CommandExecutionException;
import liquibase.resource.OpenOptions;
import liquibase.resource.PathHandlerFactory;
import liquibase.resource.Resource;
import liquibase.util.StreamUtil;
import liquibase.util.StringUtil;

public class ChecksFileAccessor
implements FileAccessor {
    @Override
    public FileAccessorDTO loadFileContents(String string) {
        Object object = ResourceUtil.getResource(string);
        if (!object.exists()) {
            Scope.getCurrentScope().getLog(this.getClass()).info("No configuration file named '" + string + "' found.");
            throw new FileNotFoundException("Check settings configuration file not found.");
        }
        Scope.getCurrentScope().getLog(this.getClass()).info("Check settings configuration file located at '" + object.getUri() + "'.");
        try {
            String string2 = StreamUtil.readStreamAsString((InputStream)object.openInputStream());
            Scope.getCurrentScope().getLog(this.getClass()).info("Check settings configuration file contents read from '" + object.getUri() + "'.");
            if (StringUtil.isEmpty((String)string2)) {
                throw new CommandExecutionException("The checks settings file '" + object.getPath() + "' is empty.");
            }
            object = FileEncoder.decode(string2, object);
            if (object.encoded) {
                String string3 = "\nThis backup file will work with Liquibase 4.5.0 users who specify it using the --checks-settings-file argument.";
                Resource resource = ResourceUtil.getResource(string);
                Resource resource2 = resource.resolveSibling(new File(string).getName() + ".v4.5");
                object.warningMessage = ChecksFileAccessor.makeBackup(resource, resource2, string2, string3);
            }
            return object;
        }
        catch (IOException iOException) {
            throw new CommandExecutionException(String.format("ERROR: The checks settings file specified at '%s' was not found. Please specify a path including the filename in the CLI, by Environment variable, or other standard method. Learn more at http://docs.liquibase.com/quality-checks", string));
        }
    }

    public static String makeBackup(Resource resource, Resource resource2, String string, String string2) {
        return ChecksFileAccessor.makeBackup(resource, resource2, string, string2, true);
    }

    public static String makeBackup(Resource resource, Resource resource2, String object, String string, boolean bl2) {
        try {
            Throwable throwable = null;
            try (Object object2 = resource2.openOutputStream(new OpenOptions());){
                ((OutputStream)object2).write(((String)object).getBytes());
            }
            catch (Throwable throwable2) {
                object = throwable2;
                throwable = throwable2;
                throw object;
            }
            object2 = "The file '" + resource.getUri().toString().replace("file://", "") + "' has been updated so it can be used by your current version of Liquibase, and to simplify resolving merge conflicts in Source Control. No action is required from you. Your original file was backed up as '" + resource2.getUri().toString().replace("file://", "") + "'." + (string != null ? string : "");
            if (bl2) {
                Scope.getCurrentScope().getLog(ChecksFileAccessor.class).warning((String)object2);
                Scope.getCurrentScope().getUI().sendMessage("WARNING: ".concat(String.valueOf(object2)));
            }
            return object2;
        }
        catch (IOException iOException) {
            String string2 = "Error creating backup file '" + resource.getUri() + "' " + iOException.getMessage();
            Scope.getCurrentScope().getLog(ChecksFileAccessor.class).warning(string2);
            Scope.getCurrentScope().getUI().sendMessage(string2);
            return null;
        }
    }

    @Override
    public void writeFileContents(Resource resource, String string, String object, boolean bl2) {
        block16: {
            try {
                Throwable throwable = null;
                try (OutputStream outputStream = this.createOrOpenResource(resource, string);){
                    outputStream.write((FileEncoder.generateFileHeader() + (String)object).getBytes((String)GlobalConfiguration.OUTPUT_FILE_ENCODING.getCurrentValue()));
                }
                catch (Throwable throwable2) {
                    object = throwable2;
                    throwable = throwable2;
                    throw object;
                }
            }
            catch (FileAlreadyExistsException fileAlreadyExistsException) {
                if (!bl2) break block16;
                throw new IOException("The file " + string + " already exists and thus cannot be created.", fileAlreadyExistsException);
            }
        }
        if (resource == null) {
            resource = ResourceUtil.getResource(string);
        }
        if (!resource.exists()) {
            Scope.getCurrentScope().getLog(this.getClass()).info("Check settings configuration file resource located at '" + resource.getUri().toString().replace("file://", "") + "'.");
            return;
        }
        Scope.getCurrentScope().getLog(this.getClass()).info("Check settings configuration file located at '" + new File(string).getAbsolutePath() + "'.");
    }

    private OutputStream createOrOpenResource(Resource resource, String string) {
        if (resource == null) {
            Scope.getCurrentScope().getLog(this.getClass()).info("No configuration file named '" + string + "' found.");
            Scope.getCurrentScope().getLog(this.getClass()).info("Creating new file: ".concat(String.valueOf(string)));
            return ((PathHandlerFactory)Scope.getCurrentScope().getSingleton(PathHandlerFactory.class)).createResource(string);
        }
        return resource.openOutputStream(new OpenOptions().setCreateIfNeeded(false));
    }
}

