/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.checks.config.cli;

import com.datical.liquibase.ext.checks.config.DynamicRuleParameterEnum;
import com.datical.liquibase.ext.checks.config.cli.AbstractCommandLineValueGetter;
import com.datical.liquibase.ext.checks.config.model.DynamicRuleParameter;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;

public class RuleParameter<T> {
    private final DynamicRuleParameterEnum parameter;
    private final BiFunction<T, List<DynamicRuleParameter>, Boolean> validationCallbackOverride;
    private final Function<List<DynamicRuleParameter>, Boolean> shouldPrompt;
    private final Object defaultValueOverride;
    private final boolean allowEmpty;

    public RuleParameter(DynamicRuleParameterEnum dynamicRuleParameterEnum) {
        this(dynamicRuleParameterEnum, null, null);
    }

    public RuleParameter(DynamicRuleParameterEnum dynamicRuleParameterEnum, BiFunction<T, List<DynamicRuleParameter>, Boolean> biFunction, Function<List<DynamicRuleParameter>, Boolean> function) {
        this(dynamicRuleParameterEnum, biFunction, function, null, false);
    }

    public RuleParameter(DynamicRuleParameterEnum dynamicRuleParameterEnum, BiFunction<T, List<DynamicRuleParameter>, Boolean> biFunction, Function<List<DynamicRuleParameter>, Boolean> function, Object object, boolean bl2) {
        this.parameter = dynamicRuleParameterEnum;
        this.validationCallbackOverride = biFunction;
        this.shouldPrompt = function;
        this.defaultValueOverride = object;
        this.allowEmpty = bl2;
    }

    public Object getDefaultValue() {
        if (this.defaultValueOverride == null) {
            return this.parameter.defaultValue;
        }
        return this.defaultValueOverride;
    }

    public DynamicRuleParameterEnum getParameter() {
        return this.parameter;
    }

    public AbstractCommandLineValueGetter<?> getInteractiveCommandLineValueGetter() {
        return this.parameter.interactiveCommandLineValueGetter;
    }

    public BiFunction<T, List<DynamicRuleParameter>, Boolean> getValidationCallbackOverride() {
        return this.validationCallbackOverride;
    }

    public Function<List<DynamicRuleParameter>, Boolean> getShouldPrompt() {
        return this.shouldPrompt;
    }

    public String toString() {
        return this.getParameter().toString();
    }

    public boolean shouldPrompt(List<DynamicRuleParameter> list) {
        boolean bl2 = true;
        if (this.shouldPrompt != null) {
            bl2 = this.shouldPrompt.apply(list);
        }
        return bl2;
    }

    public boolean allowEmpty() {
        return this.allowEmpty;
    }
}

