/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.command;

import com.datical.liquibase.ext.changelog.filter.DeploymentIdFilter;
import com.datical.liquibase.ext.command.RollbackOneUpdateCommandStep;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.logging.Level;
import liquibase.Contexts;
import liquibase.LabelExpression;
import liquibase.Liquibase;
import liquibase.RuntimeEnvironment;
import liquibase.Scope;
import liquibase.changelog.AbstractChangeLogHistoryService;
import liquibase.changelog.ChangeLogHistoryServiceFactory;
import liquibase.changelog.ChangeLogIterator;
import liquibase.changelog.ChangeLogParameters;
import liquibase.changelog.ChangeSet;
import liquibase.changelog.DatabaseChangeLog;
import liquibase.changelog.RanChangeSet;
import liquibase.changelog.filter.AlreadyRanChangeSetFilter;
import liquibase.changelog.filter.ChangeSetFilter;
import liquibase.changelog.filter.ContextChangeSetFilter;
import liquibase.changelog.filter.DbmsChangeSetFilter;
import liquibase.changelog.filter.IgnoreChangeSetFilter;
import liquibase.changelog.filter.LabelChangeSetFilter;
import liquibase.changelog.visitor.ChangeExecListener;
import liquibase.changelog.visitor.ChangeSetVisitor;
import liquibase.changelog.visitor.RollbackVisitor;
import liquibase.command.AbstractCommandStep;
import liquibase.command.CommandArgumentDefinition;
import liquibase.command.CommandBuilder;
import liquibase.command.CommandDefinition;
import liquibase.command.CommandResultsBuilder;
import liquibase.command.CommonArgumentNames;
import liquibase.database.Database;
import liquibase.exception.LiquibaseException;
import liquibase.exception.LockException;
import liquibase.exception.RollbackImpossibleException;
import liquibase.executor.Executor;
import liquibase.executor.ExecutorService;
import liquibase.executor.LoggingExecutor;
import liquibase.hub.HubUpdater;
import liquibase.hub.listener.HubChangeExecListener;
import liquibase.hub.model.Connection;
import liquibase.hub.model.Operation;
import liquibase.license.LicenseServiceUtils;
import liquibase.lockservice.LockService;
import liquibase.lockservice.LockServiceFactory;
import liquibase.logging.LogService;
import liquibase.logging.Logger;
import liquibase.logging.core.BufferedLogService;
import liquibase.logging.core.CompositeLogService;
import liquibase.logging.mdc.CustomMdcObject;
import liquibase.logging.mdc.customobjects.ChangesetsRolledback;
import liquibase.parser.ChangeLogParserFactory;
import liquibase.resource.ResourceAccessor;

public class InternalRollbackOneUpdateCommandStep
extends AbstractCommandStep {
    private static final ResourceBundle coreBundle = ResourceBundle.getBundle("liquibase/i18n/liquibase-core");
    protected static final String MSG_COULD_NOT_RELEASE_LOCK = coreBundle.getString("could.not.release.lock");
    public static final String[] COMMAND_NAME = new String[]{"internalRollbackOneUpdate"};
    public static final CommandArgumentDefinition<String> CHANGE_LOG_FILE_ARG;
    public static final CommandArgumentDefinition<String> DEPLOYMENT_ID_ARG;
    public static final CommandArgumentDefinition<Boolean> FORCE_ARG;
    public static final CommandArgumentDefinition<String> ROLLBACK_SCRIPT_ARG;
    public static final CommandArgumentDefinition<Database> DATABASE_ARG;
    public static final CommandArgumentDefinition<Liquibase> LIQUIBASE_ARG;
    public static final CommandArgumentDefinition<ChangeLogParameters> CHANGE_LOG_PARAMETERS_ARG;
    private Database database;
    protected Writer outputWriter;
    private DatabaseChangeLog changeLog;
    private Contexts contexts;
    private LabelExpression labelExpression;
    private ChangeExecListener changeExecListener;

    public String[][] defineCommandNames() {
        return new String[][]{COMMAND_NAME};
    }

    public void adjustCommandDefinition(CommandDefinition commandDefinition) {
        super.adjustCommandDefinition(commandDefinition);
        commandDefinition.setInternal(true);
    }

    protected RollbackVisitor createRollbackVisitor() {
        return new RollbackVisitor(this.database, this.changeExecListener);
    }

    protected RollbackVisitor createRollbackVisitor(List<ChangesetsRolledback.ChangeSet> list) {
        return new RollbackVisitor(this.database, this.changeExecListener, list);
    }

    public void setOutputWriter(Writer writer) {
        this.outputWriter = writer;
    }

    public void run(CommandResultsBuilder object) {
        Object object2;
        Object object32;
        LicenseServiceUtils.checkProLicenseAndThrowException((String[])RollbackOneUpdateCommandStep.COMMAND_NAME);
        Logger logger = Scope.getCurrentScope().getLog(((Object)((Object)this)).getClass());
        object = object.getCommandScope();
        String string = (String)object.getArgumentValue(DEPLOYMENT_ID_ARG);
        Boolean bl2 = (Boolean)object.getArgumentValue(FORCE_ARG);
        if (bl2 == null || !bl2.booleanValue()) {
            String string2 = "\nWARNING: Targeted rollback of this update may result in unexpected outcomes.  To review the rollback\nSQL before executing it, please run 'rollback-one-update-sql'. This message can be suppressed by adding the --force flag.";
            throw new LiquibaseException(String.format(string2, new Object[0]), Level.WARNING);
        }
        String string3 = (String)object.getArgumentValue(ROLLBACK_SCRIPT_ARG);
        bl2 = (ChangeLogParameters)object.getArgumentValue(CHANGE_LOG_PARAMETERS_ARG);
        Object object4 = (String)object.getArgumentValue(CHANGE_LOG_FILE_ARG);
        this.changeLog = this.parseChangeLogFile((String)object4, (ChangeLogParameters)bl2);
        Liquibase object52 = (Liquibase)object.getArgumentValue(LIQUIBASE_ARG);
        this.database = (Database)object.getArgumentValue(DATABASE_ARG);
        bl2 = (Boolean)object.getArgumentValue(FORCE_ARG);
        Scope.getCurrentScope().addMdcValue("rollbackScript", string3);
        Scope.getCurrentScope().addMdcValue("liquibaseTargetUrl", this.database.getConnection().getURL());
        Scope.getCurrentScope().addMdcValue("rollbackOneUpdateForce", String.valueOf(bl2));
        object = "rollbackOneUpdate";
        bl2 = null;
        if (this.outputWriter != null) {
            object = "rollback-one-update-sql";
            bl2 = ((ExecutorService)Scope.getCurrentScope().getSingleton(ExecutorService.class)).getExecutor("jdbc", this.database);
            string3 = new LoggingExecutor((Executor)bl2, this.outputWriter, this.database);
            ((ExecutorService)Scope.getCurrentScope().getSingleton(ExecutorService.class)).setExecutor("jdbc", this.database, (Executor)string3);
            ((ExecutorService)Scope.getCurrentScope().getSingleton(ExecutorService.class)).setExecutor("logging", this.database, (Executor)string3);
        } else {
            string3 = new LoggingExecutor((Executor)bl2, null, this.database);
        }
        ((ExecutorService)Scope.getCurrentScope().getSingleton(ExecutorService.class)).setExecutor("logging", this.database, (Executor)string3);
        string3 = null;
        HubUpdater hubUpdater = new HubUpdater(new Date(), this.changeLog, this.database);
        BufferedLogService bufferedLogService = new BufferedLogService();
        List list = this.database.getRanChangeSetList();
        if (string == null) {
            string = ((AbstractChangeLogHistoryService)ChangeLogHistoryServiceFactory.getInstance().getChangeLogService(this.database)).getLastDeploymentId();
            if (string == null) {
                throw new LiquibaseException(String.format(coreBundle.getString("no.deployment.ids.found"), new Object[0]));
            }
            Scope.getCurrentScope().getUI().sendMessage("Defaulting to last deployment ID '" + string + "'");
        } else {
            boolean bl3 = false;
            for (Object object32 : list) {
                if (!string.equals(object32.getDeploymentId())) continue;
                bl3 = true;
                break;
            }
            if (!bl3) {
                object2 = String.format(coreBundle.getString("no.change.sets.found.for.deployment.id"), string);
                throw new LiquibaseException("\n".concat(String.valueOf(object2)));
            }
        }
        object52.outputHeader("Rollback deployment ID '" + string + "'");
        Scope.getCurrentScope().addMdcValue("deploymentId", string);
        LockService lockService = LockServiceFactory.getInstance().getLockService(this.database);
        lockService.waitForLock();
        try {
            this.checkLiquibaseTables();
            this.changeLog.validate(this.database, this.contexts, this.labelExpression);
            object2 = new DeploymentIdFilter(string, this.database, list, this.changeLog, (String)object);
            if (!((DeploymentIdFilter)object2).getNoInverseChangeSets().isEmpty()) {
                object32 = "\n\nThere are changesets associated with the deployment ID '" + string + "' which cannot be rolled back.\nNo rollback was performed.\n";
                object32 = (String)object32 + "\nChangesets which cannot be rolled back:\n";
                for (Map.Entry<String, ChangeSet> entry : ((DeploymentIdFilter)object2).getNoInverseChangeSets().entrySet()) {
                    object32 = (String)object32 + entry.getKey();
                    object32 = (String)object32 + "\n";
                }
                throw new LiquibaseException("\n".concat(String.valueOf(object32)));
            }
            if (((DeploymentIdFilter)object2).isEmpty()) {
                object32 = "\n\nThere are no changesets associated with the deployment ID '" + string + "'.\nPlease check your parameters.  No rollback was performed.\n";
                throw new LiquibaseException("\n".concat(String.valueOf(object32)));
            }
            object32 = this.createChangeLogIterator(list, (ChangeSetFilter)object2);
            object = this.outputWriter == null ? object52.getConnection(this.changeLog) : null;
            if (object != null) {
                string3 = hubUpdater.preUpdateHub("ROLLBACK", "rollback-one-update", (Connection)object, object4, this.contexts, this.labelExpression, (ChangeLogIterator)object32);
                this.changeExecListener = new HubChangeExecListener((Operation)string3, this.changeExecListener);
            }
            object4 = this.createChangeLogIterator(list, (ChangeSetFilter)object2);
            CompositeLogService throwable = new CompositeLogService(true, new LogService[]{bufferedLogService});
            object = new ArrayList();
            Scope.child((String)Scope.Attr.logService.name(), (Object)throwable, () -> this.lambda$run$0(object4, (List)object));
            Scope.getCurrentScope().addMdcValue("changesetsRolledback", (CustomMdcObject)new ChangesetsRolledback((List)object), false);
            hubUpdater.postUpdateHub((Operation)string3, bufferedLogService);
            object = Scope.getCurrentScope().getMdcManager().put("deploymentOutcome", "success");
            object4 = null;
            try {
                Scope.getCurrentScope().getLog(((Object)((Object)this)).getClass()).info("Rollback command completed successfully.");
            }
            catch (Throwable throwable2) {
                Throwable throwable3 = throwable2;
                object4 = throwable2;
                throw throwable3;
            }
            finally {
                if (object != null) {
                    if (object4 != null) {
                        try {
                            object.close();
                        }
                        catch (Throwable throwable4) {
                            ((Throwable)object4).addSuppressed(throwable4);
                        }
                    } else {
                        object.close();
                    }
                }
            }
        }
        catch (LiquibaseException liquibaseException) {
            hubUpdater.postUpdateHubExceptionHandling((Operation)string3, bufferedLogService, liquibaseException.getMessage());
            object32 = liquibaseException.getCause();
            object = Scope.getCurrentScope().addMdcValue("deploymentOutcome", "fail");
            object4 = null;
            try {
                Scope.getCurrentScope().getLog(((Object)((Object)this)).getClass()).info("Rollback command encountered an exception.");
            }
            catch (Throwable throwable) {
                Throwable throwable5 = throwable;
                object4 = throwable;
                throw throwable5;
            }
            finally {
                if (object != null) {
                    if (object4 != null) {
                        try {
                            object.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object4).addSuppressed(throwable);
                        }
                    } else {
                        object.close();
                    }
                }
            }
            if (object32 instanceof RollbackImpossibleException) {
                object = "\nError executing rollback:\nThe rollback for deployment ID '" + string + "' has at least one changeset without a rollback defined\nPlease add a rollback change in the appropriate changeset.\n";
                logger.severe((String)object, (Throwable)liquibaseException);
                if (this.changeExecListener != null) {
                    this.changeExecListener.runFailed(null, this.changeLog, this.database, (Exception)((Object)liquibaseException));
                }
                throw new LiquibaseException((String)object, (Throwable)liquibaseException);
            }
            logger.severe("\nError executing rollback for the deployment ID '" + string + "'.");
            throw new LiquibaseException("\nError executing rollback for the deployment ID '" + string + "':\n" + liquibaseException.getMessage(), (Throwable)liquibaseException);
        }
        finally {
            try {
                lockService.releaseLock();
            }
            catch (LockException lockException) {
                logger.severe(MSG_COULD_NOT_RELEASE_LOCK, (Throwable)lockException);
            }
            if (bl2 != null) {
                ((ExecutorService)Scope.getCurrentScope().getSingleton(ExecutorService.class)).setExecutor("jdbc", this.database, (Executor)bl2);
            }
        }
        this.resetServices();
        Scope.getCurrentScope().getUI().sendMessage("rollback-one-update executed for " + this.database.getConnection().getConnectionUserName() + "@" + this.database.getConnection().getURL());
    }

    protected ChangeLogIterator createChangeLogIterator(List<RanChangeSet> list, ChangeSetFilter changeSetFilter) {
        return new ChangeLogIterator(list, this.changeLog, new ChangeSetFilter[]{changeSetFilter, new AlreadyRanChangeSetFilter(list), new ContextChangeSetFilter(this.contexts), new LabelChangeSetFilter(this.labelExpression), new IgnoreChangeSetFilter(), new DbmsChangeSetFilter(this.database)});
    }

    protected void checkLiquibaseTables() {
        ChangeLogHistoryServiceFactory.getInstance().getChangeLogService(this.database).init();
        LockServiceFactory.getInstance().getLockService(this.database).init();
    }

    protected void resetServices() {
        LockServiceFactory.getInstance().resetAll();
        ChangeLogHistoryServiceFactory.getInstance().resetAll();
        ((ExecutorService)Scope.getCurrentScope().getSingleton(ExecutorService.class)).reset();
    }

    private DatabaseChangeLog parseChangeLogFile(String string, ChangeLogParameters changeLogParameters) {
        ResourceAccessor resourceAccessor = Scope.getCurrentScope().getResourceAccessor();
        return ChangeLogParserFactory.getInstance().getParser(string, resourceAccessor).parse(string, changeLogParameters, resourceAccessor);
    }

    private /* synthetic */ void lambda$run$0(ChangeLogIterator changeLogIterator, List list) {
        changeLogIterator.run((ChangeSetVisitor)this.createRollbackVisitor(list), new RuntimeEnvironment(this.database, this.contexts, this.labelExpression));
    }

    static {
        CommandBuilder commandBuilder = new CommandBuilder((String[][])new String[][]{COMMAND_NAME});
        CHANGE_LOG_FILE_ARG = commandBuilder.argument(CommonArgumentNames.CHANGELOG_FILE, String.class).required().build();
        DEPLOYMENT_ID_ARG = commandBuilder.argument("deploymentId", String.class).build();
        FORCE_ARG = commandBuilder.argument("force", Boolean.class).build();
        ROLLBACK_SCRIPT_ARG = commandBuilder.argument("rollbackScript", String.class).build();
        DATABASE_ARG = commandBuilder.argument("database", Database.class).required().build();
        LIQUIBASE_ARG = commandBuilder.argument("liquibase", Liquibase.class).required().build();
        CHANGE_LOG_PARAMETERS_ARG = commandBuilder.argument("changeLogParameters", ChangeLogParameters.class).build();
    }
}

