/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.command;

import com.datical.liquibase.ext.changelog.filter.SinglePendingChangeSetFilter;
import com.datical.liquibase.ext.util.ProStringUtil;
import java.io.Writer;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Level;
import liquibase.Liquibase;
import liquibase.RuntimeEnvironment;
import liquibase.Scope;
import liquibase.changelog.ChangeLogHistoryServiceFactory;
import liquibase.changelog.ChangeLogIterator;
import liquibase.changelog.ChangeLogParameters;
import liquibase.changelog.DatabaseChangeLog;
import liquibase.changelog.filter.ChangeSetFilter;
import liquibase.changelog.filter.ShouldRunChangeSetFilter;
import liquibase.changelog.visitor.ChangeExecListener;
import liquibase.changelog.visitor.ChangeSetVisitor;
import liquibase.changelog.visitor.DefaultChangeExecListener;
import liquibase.changelog.visitor.UpdateVisitor;
import liquibase.command.AbstractCommandStep;
import liquibase.command.CleanUpCommandStep;
import liquibase.command.CommandArgumentDefinition;
import liquibase.command.CommandBuilder;
import liquibase.command.CommandDefinition;
import liquibase.command.CommandResultsBuilder;
import liquibase.command.CommandScope;
import liquibase.database.Database;
import liquibase.exception.LiquibaseException;
import liquibase.exception.LockException;
import liquibase.executor.ExecutorService;
import liquibase.hub.HubUpdater;
import liquibase.hub.listener.HubChangeExecListener;
import liquibase.hub.model.Connection;
import liquibase.hub.model.Operation;
import liquibase.license.LicenseServiceUtils;
import liquibase.lockservice.LockService;
import liquibase.lockservice.LockServiceFactory;
import liquibase.logging.LogService;
import liquibase.logging.Logger;
import liquibase.logging.core.BufferedLogService;
import liquibase.logging.core.CompositeLogService;
import liquibase.logging.mdc.CustomMdcObject;
import liquibase.logging.mdc.MdcObject;
import liquibase.logging.mdc.customobjects.ChangesetsUpdated;
import liquibase.parser.ChangeLogParserFactory;
import liquibase.resource.ResourceAccessor;

public class UpdateOneChangeSetCommandStep
extends AbstractCommandStep
implements CleanUpCommandStep {
    public static final String[] COMMAND_NAME = new String[]{"updateOneChangeset"};
    public static final CommandArgumentDefinition<String> CHANGESET_ID;
    public static final CommandArgumentDefinition<String> CHANGESET_AUTHOR;
    public static final CommandArgumentDefinition<String> CHANGESET_PATH;
    public static final CommandArgumentDefinition<Boolean> FORCE;
    private Database database;
    private String changeSetId;
    private String changeSetAuthor;
    private String changeSetPath;
    private Boolean force;
    private ChangeExecListener changeExecListener = new DefaultChangeExecListener(new ChangeExecListener[0]);
    private static final ResourceBundle coreBundle;

    public String[][] defineCommandNames() {
        return new String[][]{COMMAND_NAME};
    }

    public void adjustCommandDefinition(CommandDefinition commandDefinition) {
        commandDefinition.setShortDescription(ProStringUtil.markWithPro("Runs single changeset"));
    }

    public List<Class<?>> requiredDependencies() {
        return Arrays.asList(Database.class, LockService.class);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run(CommandResultsBuilder commandResultsBuilder) {
        LicenseServiceUtils.checkProLicenseAndThrowException((String[])COMMAND_NAME);
        Logger logger = Scope.getCurrentScope().getLog(((Object)((Object)this)).getClass());
        CommandScope commandScope = commandResultsBuilder.getCommandScope();
        Writer writer = (Writer)commandScope.getDependency(Writer.class);
        this.setup(commandScope, writer);
        commandScope = new ChangeLogParameters(this.database);
        DatabaseChangeLog databaseChangeLog = UpdateOneChangeSetCommandStep.parseChangeLogFile(this.changeSetPath, (ChangeLogParameters)commandScope);
        Scope.getCurrentScope().addMdcValue("commandLabelFilter", "");
        Scope.getCurrentScope().addMdcValue("commandContextFilter", "");
        this.checkLiquibaseTables();
        databaseChangeLog.validate(this.database, commandScope.getContexts(), commandScope.getLabels());
        SinglePendingChangeSetFilter singlePendingChangeSetFilter = new SinglePendingChangeSetFilter(this.changeSetId, this.changeSetAuthor, this.changeSetPath, databaseChangeLog);
        ShouldRunChangeSetFilter shouldRunChangeSetFilter = new ShouldRunChangeSetFilter(this.database, true);
        ChangeLogIterator changeLogIterator = new ChangeLogIterator(databaseChangeLog, new ChangeSetFilter[]{singlePendingChangeSetFilter, shouldRunChangeSetFilter});
        singlePendingChangeSetFilter = new ChangeLogIterator(databaseChangeLog, new ChangeSetFilter[]{singlePendingChangeSetFilter, shouldRunChangeSetFilter});
        shouldRunChangeSetFilter = new Liquibase(databaseChangeLog, Scope.getCurrentScope().getResourceAccessor(), this.database).getConnection(databaseChangeLog);
        boolean bl2 = shouldRunChangeSetFilter != null && writer == null;
        databaseChangeLog = new HubUpdater(new Date(), databaseChangeLog, this.database);
        Operation operation = null;
        BufferedLogService bufferedLogService = new BufferedLogService();
        CompositeLogService compositeLogService = new CompositeLogService(true, new LogService[]{bufferedLogService});
        try {
            UpdateOneChangeSetCommandStep updateOneChangeSetCommandStep = this;
            updateOneChangeSetCommandStep.setupExecutionServices(updateOneChangeSetCommandStep.database);
            if (bl2) {
                operation = databaseChangeLog.preUpdateHub("UPDATE", COMMAND_NAME[0], (Connection)shouldRunChangeSetFilter, this.changeSetPath, commandScope.getContexts(), commandScope.getLabels(), (ChangeLogIterator)singlePendingChangeSetFilter);
                this.changeExecListener = new HubChangeExecListener(operation, this.changeExecListener);
            }
            commandResultsBuilder.addResult("defaultChangeExecListener", (Object)this.getDefaultChangeExecListener());
            singlePendingChangeSetFilter = new UpdateVisitor(this.database, this.changeExecListener);
            Scope.child((String)Scope.Attr.logService.name(), (Object)compositeLogService, () -> this.lambda$run$0(changeLogIterator, (UpdateVisitor)singlePendingChangeSetFilter, (ChangeLogParameters)commandScope));
            this.logDeploymentOutcomeMdc(true);
            if (bl2) {
                databaseChangeLog.postUpdateHub(operation, bufferedLogService);
            }
            commandResultsBuilder.addResult("statusCode", (Object)0);
        }
        catch (SQLException | LiquibaseException throwable) {
            try {
                this.logDeploymentOutcomeMdc(false);
                if (!bl2) throw new RuntimeException(throwable);
                databaseChangeLog.postUpdateHubExceptionHandling(operation, bufferedLogService, throwable.getMessage());
                throw new RuntimeException(throwable);
            }
            catch (Throwable throwable2) {
                try {
                    LockServiceFactory.getInstance().getLockService(this.database).releaseLock();
                    throw throwable2;
                }
                catch (LockException lockException) {
                    logger.severe(coreBundle.getString("could.not.release.lock"), (Throwable)lockException);
                }
                throw throwable2;
            }
        }
        try {
            LockServiceFactory.getInstance().getLockService(this.database).releaseLock();
            return;
        }
        catch (LockException lockException) {
            logger.severe(coreBundle.getString("could.not.release.lock"), (Throwable)lockException);
            return;
        }
    }

    private DefaultChangeExecListener getDefaultChangeExecListener() {
        if (this.changeExecListener instanceof DefaultChangeExecListener) {
            return (DefaultChangeExecListener)this.changeExecListener;
        }
        if (this.changeExecListener instanceof HubChangeExecListener && ((HubChangeExecListener)this.changeExecListener).getChangeExecListener() instanceof DefaultChangeExecListener) {
            return (DefaultChangeExecListener)((HubChangeExecListener)this.changeExecListener).getChangeExecListener();
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void logDeploymentOutcomeMdc(boolean bl2) {
        List list;
        block37: {
            Object object;
            list = Collections.emptyList();
            try {
                object = this.getDefaultChangeExecListener();
                if (object != null) {
                    list = object.getDeployedChangeSets();
                }
            }
            catch (Exception exception) {
                Scope.getCurrentScope().getLog(((Object)((Object)this)).getClass()).warning("Failed to calculate deployed changeset count for MDC", (Throwable)exception);
            }
            object = new ChangesetsUpdated(list);
            list = Scope.getCurrentScope().addMdcValue("deploymentOutcomeCount", String.valueOf(list.size()));
            Throwable throwable = null;
            try {
                Throwable throwable2 = null;
                try (MdcObject mdcObject = Scope.getCurrentScope().addMdcValue("deploymentOutcome", bl2 ? "success" : "fail");){
                    object = Scope.getCurrentScope().addMdcValue("changesetsUpdated", (CustomMdcObject)object);
                    Throwable throwable3 = null;
                    try {
                        String string = "Update command completed successfully.";
                        String string2 = "Update command encountered an exception.";
                        Scope.getCurrentScope().getLog(((Object)((Object)this)).getClass()).info(bl2 ? string : string2);
                    }
                    catch (Throwable throwable4) {
                        Throwable throwable5 = throwable4;
                        throwable3 = throwable4;
                        throw throwable5;
                    }
                    finally {
                        if (object != null) {
                            if (throwable3 != null) {
                                try {
                                    object.close();
                                }
                                catch (Throwable throwable6) {
                                    throwable3.addSuppressed(throwable6);
                                }
                            } else {
                                object.close();
                            }
                        }
                    }
                }
                catch (Throwable throwable5) {
                    object = throwable5;
                    throwable2 = throwable5;
                    throw object;
                }
                if (list == null) return;
                if (throwable == null) break block37;
            }
            catch (Throwable throwable6) {
                try {
                    Throwable throwable10 = throwable6;
                    throwable = throwable6;
                    throw throwable10;
                }
                catch (Throwable throwable11) {
                    if (list == null) throw throwable11;
                    if (throwable == null) {
                        list.close();
                        throw throwable11;
                    }
                    try {
                        list.close();
                        throw throwable11;
                    }
                    catch (Throwable throwable12) {
                        throwable.addSuppressed(throwable12);
                        throw throwable11;
                    }
                }
            }
            try {
                list.close();
                return;
            }
            catch (Throwable throwable8) {
                throwable.addSuppressed(throwable8);
                return;
            }
        }
        list.close();
    }

    private void setup(CommandScope commandScope, Writer writer) {
        this.database = (Database)commandScope.getDependency(Database.class);
        this.changeSetId = (String)commandScope.getArgumentValue(CHANGESET_ID);
        this.changeSetAuthor = (String)commandScope.getArgumentValue(CHANGESET_AUTHOR);
        this.changeSetPath = (String)commandScope.getArgumentValue(CHANGESET_PATH);
        this.force = (Boolean)commandScope.getArgumentValue(FORCE);
        Scope.getCurrentScope().addMdcValue("updateOneChangesetForce", String.valueOf(this.force));
        this.checkArgs(writer);
    }

    private void checkArgs(Writer object) {
        if (this.changeSetId == null || this.changeSetAuthor == null || this.changeSetPath == null) {
            throw new LiquibaseException(coreBundle.getString("id.author.path.required"));
        }
        if (!(object != null || this.force != null && this.force.booleanValue())) {
            object = "\nWARNING: Targeted update of this changeset may result in unexpected outcomes.  To review the update\nSQL before executing it, please run 'update-one-changeset-sql'. This message can be suppressed by adding the --force flag.";
            throw new LiquibaseException((String)object, Level.WARNING);
        }
    }

    private static DatabaseChangeLog parseChangeLogFile(String string, ChangeLogParameters changeLogParameters) {
        ResourceAccessor resourceAccessor = Scope.getCurrentScope().getResourceAccessor();
        return ChangeLogParserFactory.getInstance().getParser(string, resourceAccessor).parse(string, changeLogParameters, resourceAccessor);
    }

    public void cleanUp(CommandResultsBuilder commandResultsBuilder) {
        LockServiceFactory.getInstance().resetAll();
        ((ExecutorService)Scope.getCurrentScope().getSingleton(ExecutorService.class)).reset();
        ChangeLogHistoryServiceFactory.getInstance().resetAll();
    }

    private void setupExecutionServices(Database database) {
        LockServiceFactory.getInstance().getLockService(database).waitForLock();
        database = ChangeLogHistoryServiceFactory.getInstance().getChangeLogService(database);
        database.init();
        database.generateDeploymentId();
        Scope.getCurrentScope().addMdcValue("deploymentId", database.getDeploymentId());
    }

    protected void checkLiquibaseTables() {
        ChangeLogHistoryServiceFactory.getInstance().getChangeLogService(this.database).init();
    }

    private /* synthetic */ void lambda$run$0(ChangeLogIterator changeLogIterator, UpdateVisitor updateVisitor, ChangeLogParameters changeLogParameters) {
        changeLogIterator.run((ChangeSetVisitor)updateVisitor, new RuntimeEnvironment(this.database, changeLogParameters.getContexts(), changeLogParameters.getLabels()));
    }

    static {
        coreBundle = ResourceBundle.getBundle("liquibase/i18n/liquibase-core");
        CommandBuilder commandBuilder = new CommandBuilder((String[][])new String[][]{COMMAND_NAME});
        CHANGESET_ID = commandBuilder.argument("changesetId", String.class).description("Id of the changeset to execute").required().build();
        CHANGESET_AUTHOR = commandBuilder.argument("changesetAuthor", String.class).description("Author of the changeset to execute").required().build();
        CHANGESET_PATH = commandBuilder.argument("changesetPath", String.class).description("Path to the changeset to execute").required().build();
        FORCE = commandBuilder.argument("force", Boolean.class).description("A required safety flag to indicate you intend to use this feature").defaultValue((Object)Boolean.FALSE).build();
    }
}

