/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.command;

import com.datical.liquibase.ext.command.UpdateOneChangeSetCommandStep;
import com.datical.liquibase.ext.util.ProStringUtil;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import liquibase.command.CommandArgumentDefinition;
import liquibase.command.CommandBuilder;
import liquibase.command.CommandDefinition;
import liquibase.command.CommandResultsBuilder;
import liquibase.database.Database;
import liquibase.license.LicenseServiceUtils;

public class UpdateOneChangeSetSqlCommandStep
extends UpdateOneChangeSetCommandStep {
    public static final String[] COMMAND_NAME = new String[]{"updateOneChangesetSql"};
    public static final CommandArgumentDefinition<String> CHANGESET_ID;
    public static final CommandArgumentDefinition<String> CHANGESET_AUTHOR;
    public static final CommandArgumentDefinition<String> CHANGESET_PATH;

    @Override
    public String[][] defineCommandNames() {
        return new String[][]{COMMAND_NAME};
    }

    @Override
    public void adjustCommandDefinition(CommandDefinition commandDefinition) {
        commandDefinition.setShortDescription(ProStringUtil.markWithPro("Generates sql to run single changeset"));
    }

    @Override
    public List<Class<?>> requiredDependencies() {
        ArrayList arrayList = new ArrayList();
        arrayList.add(Writer.class);
        arrayList.add(Database.class);
        arrayList.addAll(super.requiredDependencies());
        return arrayList;
    }

    @Override
    public void run(CommandResultsBuilder commandResultsBuilder) {
        LicenseServiceUtils.checkProLicenseAndThrowException((String[])COMMAND_NAME);
        super.run(commandResultsBuilder);
    }

    static {
        CommandBuilder commandBuilder = new CommandBuilder((String[][])new String[][]{COMMAND_NAME});
        CHANGESET_ID = commandBuilder.argument("changesetId", String.class).description("Id of the changeset to execute").required().build();
        CHANGESET_AUTHOR = commandBuilder.argument("changesetAuthor", String.class).description("Author of the changeset to execute").required().build();
        CHANGESET_PATH = commandBuilder.argument("changesetPath", String.class).description("Path to the changeset to execute").required().build();
    }
}

