/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.command.init;

import com.datical.liquibase.ext.checks.config.DynamicRuleParameterEnum;
import com.datical.liquibase.ext.checks.config.cli.RuleParameter;
import com.datical.liquibase.ext.command.init.InitCopyCommandStep;
import com.datical.liquibase.ext.copy.ProjectCopier;
import com.datical.liquibase.ext.copy.ProjectCopierFactory;
import com.datical.liquibase.ext.init.InitProjectUtil;
import com.datical.liquibase.ext.init.InitProjectUtil$FileCreationResultEnum;
import com.datical.liquibase.ext.init.InteractivePromptingValueProvider;
import java.io.File;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Optional;
import liquibase.GlobalConfiguration;
import liquibase.Scope;
import liquibase.command.AbstractCommandStep;
import liquibase.command.CommandArgumentDefinition;
import liquibase.command.CommandBuilder;
import liquibase.command.CommandDefinition;
import liquibase.command.CommandResultsBuilder;
import liquibase.command.CommandScope;
import liquibase.command.CommonArgumentNames;
import liquibase.configuration.ConfigurationValueObfuscator;
import liquibase.configuration.ConfigurationValueProvider;
import liquibase.configuration.ConfiguredValue;
import liquibase.configuration.LiquibaseConfiguration;
import liquibase.configuration.core.DefaultsFileValueProvider;
import liquibase.exception.CommandExecutionException;
import liquibase.exception.UnexpectedLiquibaseException;
import liquibase.integration.commandline.LiquibaseCommandLineConfiguration;

public class InitProjectCommandStep
extends AbstractCommandStep {
    public static final String[] COMMAND_NAME = new String[]{"init", "project"};
    public static final CommandArgumentDefinition<String> INIT_PROJECT_DIR_ARG;
    public static final CommandArgumentDefinition<String> INIT_FORMAT_ARG;
    public static final CommandArgumentDefinition<String> INIT_CHANGELOG_FILE_ARG;
    public static final CommandArgumentDefinition<String> INIT_DEFAULTS_FILE_ARG;
    public static final CommandArgumentDefinition<String> INIT_PROJECT_GUIDE_ARG;
    public static final CommandArgumentDefinition<Boolean> INIT_PROJECT_RECURSIVE_ARG;
    public static final CommandArgumentDefinition<Boolean> INIT_PROJECT_KEEP_TEMP_FILES_ARG;
    public static final CommandArgumentDefinition<String> URL_ARG;
    public static final CommandArgumentDefinition<String> USERNAME_ARG;
    public static final CommandArgumentDefinition<String> PASSWORD_ARG;
    public static final String SHOULD_BACKUP_DEFAULTS_FILE_ARG = "shouldBackupDefaultsFile";
    public static final String USED_H2_KEY = "usedH2";

    private boolean isProjectGuideOn(String string) {
        return string.equalsIgnoreCase("on");
    }

    private void doPrompt(ConfiguredValue<String> configuredValue, CommandArgumentDefinition<String> commandArgumentDefinition, CommandScope commandScope, DynamicRuleParameterEnum dynamicRuleParameterEnum, InteractivePromptingValueProvider interactivePromptingValueProvider) {
        this.doPrompt(configuredValue, commandArgumentDefinition, commandScope, dynamicRuleParameterEnum, interactivePromptingValueProvider, null);
    }

    private void doPrompt(ConfiguredValue<String> configuredValue, CommandArgumentDefinition<String> commandArgumentDefinition, CommandScope commandScope, DynamicRuleParameterEnum dynamicRuleParameterEnum, InteractivePromptingValueProvider interactivePromptingValueProvider, Object object) {
        if (configuredValue.wasDefaultValueUsed()) {
            dynamicRuleParameterEnum = dynamicRuleParameterEnum.interactiveCommandLineValueGetter.prompt(new RuleParameter(dynamicRuleParameterEnum), null, object);
            if (!((String)configuredValue.getValue()).equals((Object)dynamicRuleParameterEnum)) {
                interactivePromptingValueProvider.addValue(commandScope.getCompleteConfigPrefix() + "." + commandArgumentDefinition.getName(), (Object)dynamicRuleParameterEnum);
            }
        }
    }

    public final void run(CommandResultsBuilder commandResultsBuilder) {
        Object object = commandResultsBuilder.getCommandScope().getConfiguredValue(INIT_PROJECT_GUIDE_ARG);
        HashMap<String, Boolean> hashMap = new HashMap<String, Boolean>();
        if (!object.wasDefaultValueUsed() && this.isProjectGuideOn((String)(object = (String)object.getValue()))) {
            hashMap.put(GlobalConfiguration.HEADLESS.getKey(), Boolean.FALSE);
        }
        try {
            object = (LiquibaseConfiguration)Scope.getCurrentScope().getSingleton(LiquibaseConfiguration.class);
            Optional<ConfigurationValueProvider> optional = object.getProviders().stream().filter(configurationValueProvider -> configurationValueProvider instanceof DefaultsFileValueProvider).findFirst();
            optional.ifPresent(arg_0 -> ((LiquibaseConfiguration)object).unregisterProvider(arg_0));
            Scope.child(hashMap, () -> this.internalRun(commandResultsBuilder));
            optional.ifPresent(arg_0 -> ((LiquibaseConfiguration)object).registerProvider(arg_0));
            return;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    private void internalRun(CommandResultsBuilder commandResultsBuilder) {
        String string2;
        String string3;
        Object object2;
        Object object3 = commandResultsBuilder.getCommandScope();
        ConfiguredValue configuredValue = object3.getConfiguredValue(INIT_DEFAULTS_FILE_ARG);
        Object object4 = object3.getConfiguredValue(INIT_FORMAT_ARG);
        ConfiguredValue configuredValue2 = object3.getConfiguredValue(INIT_CHANGELOG_FILE_ARG);
        ConfiguredValue configuredValue3 = object3.getConfiguredValue(INIT_PROJECT_DIR_ARG);
        ConfiguredValue configuredValue4 = object3.getConfiguredValue(URL_ARG);
        ConfiguredValue configuredValue5 = object3.getConfiguredValue(USERNAME_ARG);
        ConfiguredValue configuredValue6 = object3.getConfiguredValue(PASSWORD_ARG);
        Object object5 = (String)object3.getConfiguredValue(INIT_PROJECT_GUIDE_ARG).getValue();
        boolean bl2 = false;
        boolean bl3 = false;
        String string4 = (String)configuredValue3.getValue();
        String string5 = (String)configuredValue3.getValue();
        ProjectCopier projectCopier = ((ProjectCopierFactory)Scope.getCurrentScope().getSingleton(ProjectCopierFactory.class)).getProjectCopier(string5);
        if (projectCopier == null) {
            throw new UnexpectedLiquibaseException("The AWS S3 extension JAR is not available on the classpath");
        }
        if (this.isProjectGuideOn((String)object5) && (configuredValue3.wasDefaultValueUsed() || configuredValue2.wasDefaultValueUsed() || object4.wasDefaultValueUsed() || configuredValue.wasDefaultValueUsed() || configuredValue4.wasDefaultValueUsed() || configuredValue5.wasDefaultValueUsed() || configuredValue6.wasDefaultValueUsed())) {
            object5 = (String)Scope.getCurrentScope().getUI().prompt("Setup new liquibase.properties, flowfile, and sample changelog? Enter (Y)es with defaults, yes with (C)ustomization, or (N)o.", (Object)"Y", (string, object) -> {
                object = Arrays.asList("y", "yes", "n", "no", "c", "custom", "customize");
                if (string == null || object.stream().noneMatch(string2 -> string2.equalsIgnoreCase(string))) {
                    throw new IllegalArgumentException();
                }
                return string;
            }, String.class);
            if (((String)object5).toLowerCase().startsWith("c")) {
                object2 = new InteractivePromptingValueProvider();
                ((LiquibaseConfiguration)Scope.getCurrentScope().getSingleton(LiquibaseConfiguration.class)).registerProvider((ConfigurationValueProvider)object2);
                this.doPrompt((ConfiguredValue<String>)configuredValue3, INIT_PROJECT_DIR_ARG, (CommandScope)object3, DynamicRuleParameterEnum.PROJECT_DIR, (InteractivePromptingValueProvider)((Object)object2));
                configuredValue3 = object3.getConfiguredValue(INIT_PROJECT_DIR_ARG);
                string5 = (String)configuredValue3.getValue();
                projectCopier = ((ProjectCopierFactory)Scope.getCurrentScope().getSingleton(ProjectCopierFactory.class)).getProjectCopier(string5);
                string3 = this.findLatestChangelogFilename((ConfiguredValue<String>)configuredValue3);
                this.doPrompt((ConfiguredValue<String>)configuredValue2, INIT_CHANGELOG_FILE_ARG, (CommandScope)object3, DynamicRuleParameterEnum.SAMPLE_CHANGELOG_NAME, (InteractivePromptingValueProvider)((Object)object2), string3);
                configuredValue2 = object3.getConfiguredValue(INIT_CHANGELOG_FILE_ARG);
                bl2 = this.isSkipped((ConfiguredValue<String>)configuredValue2);
                if (bl2) {
                    string2 = "No changelog file will be created. Specify a valid changelog file on the CLI, via Environment variable, or in your defaults file. ";
                    Scope.getCurrentScope().getUI().sendMessage(InitProjectCommandStep.addGettingStarted(string2));
                } else if (InitProjectUtil.determineFormatType((String)configuredValue2.getValue(), null) == null) {
                    this.doPrompt((ConfiguredValue<String>)object4, INIT_FORMAT_ARG, (CommandScope)object3, DynamicRuleParameterEnum.FILETYPE, (InteractivePromptingValueProvider)((Object)object2));
                }
                this.doPrompt((ConfiguredValue<String>)configuredValue, INIT_DEFAULTS_FILE_ARG, (CommandScope)object3, DynamicRuleParameterEnum.DEFAULTS_FILENAME, (InteractivePromptingValueProvider)((Object)object2));
                configuredValue = object3.getConfiguredValue(INIT_DEFAULTS_FILE_ARG);
                bl3 = this.isSkipped((ConfiguredValue<String>)configuredValue);
                if (bl3) {
                    string2 = "No defaults file will be created. Specify a valid defaults file on the CLI, via Environment variable, or pass all required properties on the CLI, via Environment variables. ";
                    Scope.getCurrentScope().getUI().sendMessage(InitProjectCommandStep.addGettingStarted(string2));
                } else {
                    this.doPrompt((ConfiguredValue<String>)configuredValue4, URL_ARG, (CommandScope)object3, DynamicRuleParameterEnum.JDBC_URL, (InteractivePromptingValueProvider)((Object)object2));
                    this.doPrompt((ConfiguredValue<String>)configuredValue5, USERNAME_ARG, (CommandScope)object3, DynamicRuleParameterEnum.USERNAME, (InteractivePromptingValueProvider)((Object)object2));
                    this.doPrompt((ConfiguredValue<String>)configuredValue6, PASSWORD_ARG, (CommandScope)object3, DynamicRuleParameterEnum.PASSWORD, (InteractivePromptingValueProvider)((Object)object2));
                }
                object4 = object3.getConfiguredValue(INIT_FORMAT_ARG);
                configuredValue4 = object3.getConfiguredValue(URL_ARG);
                configuredValue5 = object3.getConfiguredValue(USERNAME_ARG);
                configuredValue6 = object3.getConfiguredValue(PASSWORD_ARG);
                if (!bl2 || !bl3) {
                    string2 = String.format("Setting up new Liquibase project in '%s'...", InitProjectCommandStep.fullPathToProjectDir(projectCopier, (ConfiguredValue<String>)configuredValue3));
                    Scope.getCurrentScope().getLog(((Object)((Object)this)).getClass()).info(string2);
                    Scope.getCurrentScope().getUI().sendMessage(string2);
                }
            } else if (((String)object5).toLowerCase().startsWith("y")) {
                object2 = String.format("Setting up new Liquibase project in '%s'...", InitProjectCommandStep.fullPathToProjectDir(projectCopier, (ConfiguredValue<String>)configuredValue3));
                Scope.getCurrentScope().getLog(((Object)((Object)this)).getClass()).info((String)object2);
                Scope.getCurrentScope().getUI().sendMessage((String)object2);
            } else if (((String)object5).toLowerCase().startsWith("n")) {
                String string6 = "No files created. Set 'liquibase.command.init.project.projectGuide=off' in your defaults file or set LIQUIBASE_COMMAND_INIT_PROJECT_PROJECT_GUIDE=off as an environment variable to not be asked again. Getting Started and project setup available anytime, run \"liquibase init project --help\" for information.";
                Scope.getCurrentScope().getLog(((Object)((Object)this)).getClass()).info(string6);
                Scope.getCurrentScope().getUI().sendMessage(string6);
                return;
            }
        }
        object5 = projectCopier.createWorkingStorage(string5, (Boolean)object3.getConfiguredValue(INIT_PROJECT_KEEP_TEMP_FILES_ARG).getValue());
        InitProjectUtil.validateProjectDirectory((File)object5);
        InitProjectUtil.createProjectDirectory((File)object5);
        if (!bl2 || !bl3) {
            object2 = InitProjectUtil$FileCreationResultEnum.skipped_changelog_step;
            string3 = null;
            if (!bl2) {
                string2 = (String)configuredValue2.getValue();
                InitProjectUtil.validateChangelogFilePath(string2);
                if (object4.wasDefaultValueUsed() && (string3 = InitProjectUtil.determineFormatType(string2, (String)object4.getValue())) == null) {
                    object3 = "Unable to determine format for the changelog file '" + string2 + "'";
                    throw new CommandExecutionException((String)object3);
                }
                if (string3 == null) {
                    string3 = (String)object3.getConfiguredValue(INIT_FORMAT_ARG).getValue();
                }
                if (!string2.contains(".".concat(String.valueOf(string3)))) {
                    string2 = string2 + "." + string3;
                }
                object2 = InitProjectUtil.copyExampleChangelog(string3, (File)object5, string2, (ConfiguredValue<String>)configuredValue2);
                if (string5.endsWith("/")) {
                    commandResultsBuilder.addResult(INIT_CHANGELOG_FILE_ARG.getName(), (Object)(string5 + string2));
                } else {
                    commandResultsBuilder.addResult(INIT_CHANGELOG_FILE_ARG.getName(), (Object)(string5 + "/" + string2));
                }
            }
            boolean bl4 = false;
            if (!bl3) {
                boolean bl5 = false;
                object4 = new File((File)object5, (String)configuredValue.getValue());
                if (!object4.exists()) {
                    if (object2 == InitProjectUtil$FileCreationResultEnum.skipped_changelog_step || object2 == InitProjectUtil$FileCreationResultEnum.already_existed) {
                        Scope.getCurrentScope().getUI().sendMessage(System.lineSeparator());
                    }
                    object4 = projectCopier.isRemote() ? InitProjectUtil.copyExampleProperties(string3, ((File)object5).getAbsolutePath(), (String)configuredValue.getValue()) : InitProjectUtil.copyExampleProperties(string3, string5, (String)configuredValue.getValue());
                    bl5 = true;
                }
                Boolean bl6 = (Boolean)Scope.getCurrentScope().get(SHOULD_BACKUP_DEFAULTS_FILE_ARG, Boolean.class);
                InitProjectUtil.updateDefaultsFile((File)object4, bl5, string3, (ConfiguredValue<String>)configuredValue2, (ConfiguredValue<String>)configuredValue4, (ConfiguredValue<String>)configuredValue5, (ConfiguredValue<String>)configuredValue6, object2, bl6, commandResultsBuilder);
                commandResultsBuilder.addResult(INIT_DEFAULTS_FILE_ARG.getName(), object4);
                bl4 = InitProjectUtil.wasH2Used((ConfiguredValue<String>)configuredValue4, (ConfiguredValue<String>)configuredValue5, (ConfiguredValue<String>)configuredValue6);
            }
            InitProjectUtil.copyExampleFlowFiles(string3, (File)object5);
            Scope.getCurrentScope().getUI().sendMessage("");
            commandResultsBuilder.addResult(USED_H2_KEY, (Object)bl4);
            InitProjectCommandStep.outputEndInstructions(configuredValue3.wasDefaultValueUsed(), (ConfiguredValue<String>)configuredValue, string5, bl4);
        } else {
            object2 = InitProjectCommandStep.addGettingStarted(" ");
            Scope.getCurrentScope().getLog(InitProjectCommandStep.class).info((String)object2);
            Scope.getCurrentScope().getUI().sendMessage((String)object2);
        }
        if (projectCopier.isRemote()) {
            object2 = new CommandScope(new String[]{"init", "copy"});
            object2.addArgumentValue(InitCopyCommandStep.INIT_COPY_SOURCE_DIR_ARG, ((File)object5).getAbsolutePath());
            if (!string5.equals(string4)) {
                object2.addArgumentValue(InitCopyCommandStep.INIT_COPY_TARGET_DIR_ARG, string5);
            } else {
                object2.addArgumentValue(InitCopyCommandStep.INIT_COPY_TARGET_DIR_ARG, string4);
            }
            object2.addArgumentValue(InitCopyCommandStep.INIT_COPY_PROJECT_COPIER_ARG, projectCopier);
            object2.execute();
        }
        commandResultsBuilder.addResult("statusCode", (Object)0);
    }

    public static void outputEndInstructions(boolean bl2, ConfiguredValue<String> configuredValue, String string, boolean bl3) {
        String string2 = "To use the new project files";
        if (!bl2) {
            string2 = string2 + String.format(", please cd into '%s',", string);
        }
        string2 = string2 + " make sure your database is active and accessible";
        String string3 = "liquibase update" + (configuredValue.wasDefaultValueUsed() || ((String)configuredValue.getValue()).equals(INIT_DEFAULTS_FILE_ARG.getDefaultValue()) ? "" : " --defaults-file=" + (String)configuredValue.getValue());
        string2 = bl3 ? string2 + " by opening a new terminal window to run \"liquibase init start-h2\", and then return to this terminal window to run \"" + string3 + "\" command." : string2 + " and run \"" + string3 + "\".";
        string2 = InitProjectCommandStep.addGettingStarted(string2);
        Scope.getCurrentScope().getLog(InitProjectCommandStep.class).info(string2);
        Scope.getCurrentScope().getUI().sendMessage(string2);
    }

    private static String fullPathToProjectDir(ProjectCopier projectCopier, ConfiguredValue<String> configuredValue) {
        if (projectCopier.isRemote()) {
            return (String)configuredValue.getValue();
        }
        return new File((String)configuredValue.getValue()).getAbsolutePath();
    }

    private static String addGettingStarted(String string) {
        return string + "\nFor more details, visit the Getting Started Guide at https://docs.liquibase.com/start/home.html";
    }

    private boolean isSkipped(ConfiguredValue<String> configuredValue) {
        return ((String)configuredValue.getValue()).equalsIgnoreCase("s");
    }

    private String findLatestChangelogFilename(ConfiguredValue<String> fileArray) {
        try {
            fileArray = InitProjectUtil.findChangeLogsInProjectDir(new File((String)fileArray.getValue()));
            if (fileArray != null && fileArray.length > 0) {
                Arrays.sort(fileArray, (file, file2) -> Long.compare(file2.lastModified(), file.lastModified()));
                return fileArray[0].getName();
            }
        }
        catch (Exception exception) {
            Scope.getCurrentScope().getLog(((Object)((Object)this)).getClass()).fine("Failed to find an existing changelog file in the specified project directory, using default instead", (Throwable)exception);
        }
        return null;
    }

    public String[][] defineCommandNames() {
        return new String[][]{COMMAND_NAME};
    }

    public void adjustCommandDefinition(CommandDefinition commandDefinition) {
        super.adjustCommandDefinition(commandDefinition);
        commandDefinition.setShortDescription("Creates the directory and files needed to run Liquibase commands. Run without any flags on the CLI, or set via Environment variable, etc. will launch an interactive guide to walk users through setting up the necessary project's default and changelog files. This guide can be turned off by setting the 'liquibase.command.init.project.projectGuide=off'");
        commandDefinition.setGroupShortDescription(new String[]{"init"}, "Init commands");
    }

    static {
        CommandBuilder commandBuilder = new CommandBuilder((String[][])new String[][]{COMMAND_NAME});
        INIT_PROJECT_DIR_ARG = commandBuilder.argument("projectDir", String.class).description("Relative or fully qualified path to the directory where the project files will be created").defaultValue((Object)((String)DynamicRuleParameterEnum.PROJECT_DIR.defaultValue)).build();
        INIT_FORMAT_ARG = commandBuilder.argument("format", String.class).description("Format of the project changelog sql|xml|json|yaml|yml").defaultValue((Object)DynamicRuleParameterEnum.FILETYPE.defaultValue.toString()).build();
        INIT_DEFAULTS_FILE_ARG = commandBuilder.argument("projectDefaultsFile", String.class).description(LiquibaseCommandLineConfiguration.DEFAULTS_FILE.getDescription()).defaultValue(LiquibaseCommandLineConfiguration.DEFAULTS_FILE.getDefaultValue()).build();
        INIT_PROJECT_GUIDE_ARG = commandBuilder.argument("projectGuide", String.class).description("Allow interactive prompts for init project").defaultValue((Object)"on").setValueHandler(object -> {
            if (object == null) {
                return null;
            }
            if (!((String)(object = String.valueOf(object))).equalsIgnoreCase("on") && !((String)object).equalsIgnoreCase("off")) {
                object = "\nWARNING: The projectGuide parameter must be set to either 'on' or 'off'.  (Blank defaults to 'on')";
                throw new IllegalArgumentException((String)object);
            }
            return object;
        }).build();
        INIT_PROJECT_RECURSIVE_ARG = commandBuilder.argument("recursive", Boolean.class).description("For remote project locations, recursive copy all project files to the remote location").defaultValue((Object)Boolean.FALSE).hidden().build();
        INIT_PROJECT_KEEP_TEMP_FILES_ARG = commandBuilder.argument("keepTempFiles", Boolean.class).description("For remote project locations, do not delete temporary project files").defaultValue((Object)Boolean.FALSE).build();
        INIT_CHANGELOG_FILE_ARG = commandBuilder.argument(CommonArgumentNames.CHANGELOG_FILE, String.class).description("Relative or fully qualified path to the changelog file").defaultValue((Object)((String)DynamicRuleParameterEnum.SAMPLE_CHANGELOG_NAME.defaultValue)).build();
        URL_ARG = commandBuilder.argument(CommonArgumentNames.URL, String.class).description("The JDBC database connection URL").defaultValue((Object)((String)DynamicRuleParameterEnum.JDBC_URL.defaultValue)).build();
        USERNAME_ARG = commandBuilder.argument(CommonArgumentNames.USERNAME, String.class).description("Username to use to connect to the database").defaultValue((Object)((String)DynamicRuleParameterEnum.USERNAME.defaultValue)).build();
        PASSWORD_ARG = commandBuilder.argument(CommonArgumentNames.PASSWORD, String.class).description("Password to use to connect to the database").defaultValue((Object)((String)DynamicRuleParameterEnum.PASSWORD.defaultValue)).setValueObfuscator(ConfigurationValueObfuscator.STANDARD).build();
    }
}

