/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.rules.core;

import com.datical.liquibase.ext.rules.api.Fact;
import com.datical.liquibase.ext.rules.api.Facts;
import com.datical.liquibase.ext.rules.api.Rule;
import com.datical.liquibase.ext.rules.api.Rules;
import com.datical.liquibase.ext.rules.api.RulesEngineParameters;
import com.datical.liquibase.ext.rules.core.AbstractRulesEngine;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import liquibase.Scope;
import liquibase.logging.Logger;

public final class DefaultRulesEngine
extends AbstractRulesEngine {
    public DefaultRulesEngine() {
    }

    public DefaultRulesEngine(RulesEngineParameters rulesEngineParameters) {
        super(rulesEngineParameters);
    }

    @Override
    public final void fire(Rules rules, Facts facts) {
        Objects.requireNonNull(rules, "Rules must not be null");
        Objects.requireNonNull(facts, "Facts must not be null");
        this.triggerListenersBeforeRules(rules, facts);
        this.doFire(rules, facts);
        this.triggerListenersAfterRules(rules, facts);
    }

    final void doFire(Rules object, Facts facts) {
        Logger logger = Scope.getCurrentScope().getLog(this.getClass());
        if (((Rules)object).isEmpty()) {
            logger.warning("No rules registered! Nothing to apply");
            return;
        }
        this.logEngineParameters();
        this.log((Rules)object);
        this.log(facts);
        logger.fine("Rules evaluation started");
        object = ((Rules)object).iterator();
        while (object.hasNext()) {
            int n2;
            String string;
            Rule rule;
            block9: {
                rule = (Rule)object.next();
                string = rule.getName();
                n2 = rule.getPriority();
                if (n2 > this.parameters.getPriorityThreshold()) {
                    logger.fine("Rule priority threshold (" + this.parameters.getPriorityThreshold() + ") exceeded at rule '" + string + "' with priority=" + n2 + ", next rule will be skipped");
                    return;
                }
                if (!this.shouldBeEvaluated(rule, facts)) {
                    logger.fine("Rule '" + string + "' has been skipped before being evaluated");
                    continue;
                }
                n2 = 0;
                try {
                    n2 = rule.evaluate(facts) ? 1 : 0;
                }
                catch (RuntimeException runtimeException) {
                    logger.severe("Rule '" + string + "' evaluated with error", (Throwable)runtimeException);
                    this.triggerListenersOnEvaluationError(rule, facts, runtimeException);
                    if (!this.parameters.isSkipOnFirstNonTriggeredRule()) break block9;
                    logger.fine("Next rule will be skipped since parameter skipOnFirstNonTriggeredRule is set");
                    return;
                }
            }
            if (n2 != 0) {
                logger.fine("Rule '" + string + "' triggered");
                this.triggerListenersAfterEvaluate(rule, facts, true);
                try {
                    this.triggerListenersBeforeExecute(rule, facts);
                    rule.execute(facts);
                    logger.fine("Rule '" + string + "' performed successfully");
                    this.triggerListenersOnSuccess(rule, facts);
                    if (!this.parameters.isSkipOnFirstAppliedRule()) continue;
                    logger.fine("Next rule will be skipped since parameter skipOnFirstAppliedRule is set");
                    return;
                }
                catch (Exception exception) {
                    logger.severe("Rule '" + string + "' performed with error", (Throwable)exception);
                    this.triggerListenersOnFailure(rule, exception, facts);
                    if (!this.parameters.isSkipOnFirstFailedRule()) continue;
                    logger.fine("Next rule will be skipped since parameter skipOnFirstFailedRule is set");
                    return;
                }
            }
            logger.fine("Rule '" + string + "' has been evaluated to false, it has not been executed");
            this.triggerListenersAfterEvaluate(rule, facts, false);
            if (!this.parameters.isSkipOnFirstNonTriggeredRule()) continue;
            logger.fine("Next rule will be skipped since parameter skipOnFirstNonTriggeredRule is set");
            return;
        }
    }

    private void logEngineParameters() {
        Scope.getCurrentScope().getLog(this.getClass()).fine(this.parameters.toString());
    }

    private void log(Rules object) {
        Logger logger = Scope.getCurrentScope().getLog(this.getClass());
        logger.fine("Registered rules:");
        object = ((Rules)object).iterator();
        while (object.hasNext()) {
            Rule rule = (Rule)object.next();
            logger.fine("Rule { name = '" + rule.getName() + "', description = '" + rule.getDescription() + "', priority = '" + rule.getPriority() + "'}");
        }
    }

    private void log(Facts object) {
        Logger logger = Scope.getCurrentScope().getLog(this.getClass());
        logger.fine("Known facts:");
        object = ((Facts)object).iterator();
        while (object.hasNext()) {
            Fact fact = (Fact)object.next();
            logger.fine(fact.toString());
        }
    }

    @Override
    public final Map<Rule, Boolean> check(Rules rules, Facts facts) {
        Objects.requireNonNull(rules, "Rules must not be null");
        Objects.requireNonNull(facts, "Facts must not be null");
        this.triggerListenersBeforeRules(rules, facts);
        Map<Rule, Boolean> map = this.doCheck(rules, facts);
        this.triggerListenersAfterRules(rules, facts);
        return map;
    }

    private Map<Rule, Boolean> doCheck(Rules object, Facts facts) {
        Scope.getCurrentScope().getLog(this.getClass()).fine("Checking rules");
        HashMap<Rule, Boolean> hashMap = new HashMap<Rule, Boolean>();
        object = ((Rules)object).iterator();
        while (object.hasNext()) {
            Rule rule = (Rule)object.next();
            if (!this.shouldBeEvaluated(rule, facts)) continue;
            Rule rule2 = rule;
            hashMap.put(rule2, rule2.evaluate(facts));
        }
        return hashMap;
    }

    private void triggerListenersOnFailure(Rule rule, Exception exception, Facts facts) {
        this.ruleListeners.forEach(ruleListener -> ruleListener.onFailure(rule, facts, exception));
    }

    private void triggerListenersOnSuccess(Rule rule, Facts facts) {
        this.ruleListeners.forEach(ruleListener -> ruleListener.onSuccess(rule, facts));
    }

    private void triggerListenersBeforeExecute(Rule rule, Facts facts) {
        this.ruleListeners.forEach(ruleListener -> ruleListener.beforeExecute(rule, facts));
    }

    private boolean triggerListenersBeforeEvaluate(Rule rule, Facts facts) {
        return this.ruleListeners.stream().allMatch(ruleListener -> ruleListener.beforeEvaluate(rule, facts));
    }

    private void triggerListenersAfterEvaluate(Rule rule, Facts facts, boolean bl2) {
        this.ruleListeners.forEach(ruleListener -> ruleListener.afterEvaluate(rule, facts, bl2));
    }

    private void triggerListenersOnEvaluationError(Rule rule, Facts facts, Exception exception) {
        this.ruleListeners.forEach(ruleListener -> ruleListener.onEvaluationError(rule, facts, exception));
    }

    private void triggerListenersBeforeRules(Rules rules, Facts facts) {
        this.rulesEngineListeners.forEach(rulesEngineListener -> rulesEngineListener.beforeEvaluate(rules, facts));
    }

    private void triggerListenersAfterRules(Rules rules, Facts facts) {
        this.rulesEngineListeners.forEach(rulesEngineListener -> rulesEngineListener.afterExecute(rules, facts));
    }

    private boolean shouldBeEvaluated(Rule rule, Facts facts) {
        return this.triggerListenersBeforeEvaluate(rule, facts);
    }
}

