/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.storedlogic.trigger.change;

import com.datical.liquibase.ext.license.LicenseValidationChange;
import com.datical.liquibase.ext.storedlogic.trigger.change.CreateTriggerStatement;
import com.datical.liquibase.ext.util.RefactoringUtils;
import liquibase.change.Change;
import liquibase.change.CheckSum;
import liquibase.change.DatabaseChange;
import liquibase.change.DatabaseChangeProperty;
import liquibase.change.core.CreateProcedureChange;
import liquibase.database.Database;
import liquibase.database.core.AbstractDb2Database;
import liquibase.database.core.CockroachDatabase;
import liquibase.database.core.MSSQLDatabase;
import liquibase.database.core.MySQLDatabase;
import liquibase.database.core.OracleDatabase;
import liquibase.database.core.PostgresDatabase;
import liquibase.exception.ValidationErrors;
import liquibase.license.pro.LicenseTier;
import liquibase.serializer.LiquibaseSerializable;
import liquibase.statement.SqlStatement;

@DatabaseChange(name="createTrigger", description="Creates a database trigger", priority=101, appliesTo={"trigger"})
public class CreateTriggerChange
extends CreateProcedureChange {
    private String triggerName;
    private String triggerBody;
    private Boolean disabled;
    private String tableName;
    private String scope;

    public ValidationErrors validate(Database database) {
        ValidationErrors validationErrors;
        new ValidationErrors();
        if (database instanceof OracleDatabase || database instanceof MSSQLDatabase || database instanceof MySQLDatabase || database instanceof AbstractDb2Database || database instanceof PostgresDatabase && !(database instanceof CockroachDatabase)) {
            validationErrors = LicenseValidationChange.checkForValidLicense(LicenseTier.PRO, (Change)this);
            if (validationErrors.hasErrors()) {
                return validationErrors;
            }
        } else {
            return RefactoringUtils.createValidationErrors(database, (Change)this);
        }
        validationErrors = super.validate(database);
        if (database instanceof MSSQLDatabase && this.getDisabled() != null && this.getDisabled().booleanValue() && this.getScope() == null && this.getTableName() == null) {
            validationErrors.addError("tableName or scope is required when creating a disabled trigger");
        }
        return validationErrors;
    }

    @DatabaseChangeProperty(isChangeProperty=false)
    public String getProcedureName() {
        return this.getTriggerName();
    }

    public void setProcedureName(String string) {
        this.setTriggerName(string);
    }

    @DatabaseChangeProperty(isChangeProperty=false)
    public String getProcedureText() {
        return this.getTriggerBody();
    }

    public void setProcedureText(String string) {
        this.setTriggerBody(string);
    }

    @DatabaseChangeProperty(mustEqualExisting="trigger", description="Name of the trigger to drop")
    public String getTriggerName() {
        return this.triggerName;
    }

    public void setTriggerName(String string) {
        this.triggerName = string;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String string) {
        this.tableName = string;
    }

    public String getScope() {
        return this.scope;
    }

    public void setScope(String string) {
        this.scope = string;
    }

    public Boolean getDisabled() {
        return this.disabled;
    }

    public void setDisabled(Boolean bl2) {
        this.disabled = bl2;
    }

    @DatabaseChangeProperty(serializationType=LiquibaseSerializable.SerializationType.DIRECT_VALUE)
    public String getTriggerBody() {
        return this.triggerBody;
    }

    public void setTriggerBody(String string) {
        this.triggerBody = string;
    }

    public String getConfirmationMessage() {
        return "Trigger " + this.getTriggerName() + " created";
    }

    protected SqlStatement[] generateStatements(String object, String string, Database database) {
        boolean bl2 = false;
        if (this.getDisabled() != null) {
            bl2 = this.getDisabled();
        }
        object = new CreateTriggerStatement(this.getCatalogName(), this.getSchemaName(), this.getTriggerName(), (String)object, string);
        ((CreateTriggerStatement)((Object)object)).setDisabled(bl2);
        ((CreateTriggerStatement)((Object)object)).setScope(this.getScope());
        ((CreateTriggerStatement)((Object)object)).setTableName(this.getTableName());
        object.setReplaceIfExists(this.getReplaceIfExists());
        return new SqlStatement[]{object};
    }

    public String getSerializedObjectNamespace() {
        return "http://www.liquibase.org/xml/ns/pro";
    }

    public CheckSum generateCheckSum() {
        CreateTriggerChange createTriggerChange = this;
        return super.generateCheckSum(createTriggerChange.triggerBody);
    }
}

