/*
 * Decompiled with CFR 0.152.
 */
package liquibase.pro.packaged;

import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;
import liquibase.pro.packaged.aA;
import liquibase.pro.packaged.aC;
import liquibase.pro.packaged.aD;
import liquibase.pro.packaged.aE;
import liquibase.pro.packaged.aL;
import liquibase.pro.packaged.aP;
import liquibase.pro.packaged.aQ;
import liquibase.pro.packaged.aS;
import liquibase.pro.packaged.aZ;
import liquibase.pro.packaged.an;
import liquibase.pro.packaged.bA;
import liquibase.pro.packaged.bF;
import liquibase.pro.packaged.bg;
import liquibase.pro.packaged.by;
import liquibase.pro.packaged.cC;
import liquibase.pro.packaged.cX;
import liquibase.pro.packaged.cw;
import liquibase.pro.packaged.cy;
import liquibase.pro.packaged.dg;
import liquibase.pro.packaged.dn;

public abstract class bf
extends bg {
    protected static final dg<aP> JSON_READ_CAPABILITIES = DEFAULT_READ_CAPABILITIES;
    protected final bA _ioContext;
    protected final aQ _streamReadConstraints;
    protected boolean _closed;
    protected int _inputPtr;
    protected int _inputEnd;
    protected long _currInputProcessed;
    protected int _currInputRow = 1;
    protected int _currInputRowStart;
    protected long _tokenInputTotal;
    protected int _tokenInputRow = 1;
    protected int _tokenInputCol;
    protected cy _parsingContext;
    protected aL _nextToken;
    protected final dn _textBuffer;
    protected char[] _nameCopyBuffer;
    protected boolean _nameCopied;
    protected cX _byteArrayBuilder;
    protected byte[] _binaryValue;
    protected int _numTypesValid = 0;
    protected int _numberInt;
    protected long _numberLong;
    protected float _numberFloat;
    protected double _numberDouble;
    protected BigInteger _numberBigInt;
    protected BigDecimal _numberBigDecimal;
    protected String _numberString;
    protected boolean _numberNegative;
    protected int _intLength;
    protected int _fractLength;
    protected int _expLength;

    protected bf(bA object, int n2) {
        super(n2);
        this._ioContext = object;
        aQ aQ2 = ((bA)object).streamReadConstraints();
        this._streamReadConstraints = aQ2 == null ? aQ.defaults() : aQ2;
        this._textBuffer = ((bA)object).constructReadConstrainedTextBuffer();
        object = aD.STRICT_DUPLICATE_DETECTION.enabledIn(n2) ? cw.rootDetector(this) : null;
        this._parsingContext = cy.createRootContext((cw)object);
    }

    @Override
    public aZ version() {
        return cC.VERSION;
    }

    @Override
    public Object getCurrentValue() {
        return this._parsingContext.getCurrentValue();
    }

    @Override
    public void setCurrentValue(Object object) {
        this._parsingContext.setCurrentValue(object);
    }

    @Override
    public aC enable(aD aD2) {
        this._features |= aD2.getMask();
        if (aD2 == aD.STRICT_DUPLICATE_DETECTION && this._parsingContext.getDupDetector() == null) {
            this._parsingContext = this._parsingContext.withDupDetector(cw.rootDetector(this));
        }
        return this;
    }

    @Override
    public aC disable(aD aD2) {
        this._features &= ~aD2.getMask();
        if (aD2 == aD.STRICT_DUPLICATE_DETECTION) {
            this._parsingContext = this._parsingContext.withDupDetector(null);
        }
        return this;
    }

    @Override
    @Deprecated
    public aC setFeatureMask(int n2) {
        int n3 = this._features ^ n2;
        if (n3 != 0) {
            this._features = n2;
            this._checkStdFeatureChanges(n2, n3);
        }
        return this;
    }

    @Override
    public aC overrideStdFeatures(int n2, int n3) {
        int n4 = this._features;
        if ((n3 = n4 ^ (n2 = n4 & ~n3 | n2 & n3)) != 0) {
            this._features = n2;
            this._checkStdFeatureChanges(n2, n3);
        }
        return this;
    }

    protected void _checkStdFeatureChanges(int n2, int n3) {
        int n4 = aD.STRICT_DUPLICATE_DETECTION.getMask();
        if ((n3 & n4) != 0 && (n2 & n4) != 0) {
            if (this._parsingContext.getDupDetector() == null) {
                this._parsingContext = this._parsingContext.withDupDetector(cw.rootDetector(this));
                return;
            }
            this._parsingContext = this._parsingContext.withDupDetector(null);
        }
    }

    @Override
    public String getCurrentName() {
        cy cy2;
        if ((this._currToken == aL.START_OBJECT || this._currToken == aL.START_ARRAY) && (cy2 = this._parsingContext.getParent()) != null) {
            return cy2.getCurrentName();
        }
        return this._parsingContext.getCurrentName();
    }

    @Override
    public void overrideCurrentName(String string) {
        cy cy2 = this._parsingContext;
        if (this._currToken == aL.START_OBJECT || this._currToken == aL.START_ARRAY) {
            cy2 = cy2.getParent();
        }
        try {
            cy2.setCurrentName(string);
            return;
        }
        catch (IOException iOException) {
            throw new IllegalStateException(iOException);
        }
    }

    @Override
    public void close() {
        if (!this._closed) {
            this._inputPtr = Math.max(this._inputPtr, this._inputEnd);
            this._closed = true;
            try {
                this._closeInput();
                return;
            }
            finally {
                this._releaseBuffers();
            }
        }
    }

    @Override
    public boolean isClosed() {
        return this._closed;
    }

    @Override
    public cy getParsingContext() {
        return this._parsingContext;
    }

    @Override
    public aA getTokenLocation() {
        return new aA(this._contentReference(), -1L, this.getTokenCharacterOffset(), this.getTokenLineNr(), this.getTokenColumnNr());
    }

    @Override
    public aA getCurrentLocation() {
        int n2 = this._inputPtr - this._currInputRowStart + 1;
        return new aA(this._contentReference(), -1L, this._currInputProcessed + (long)this._inputPtr, this._currInputRow, n2);
    }

    @Override
    public boolean hasTextCharacters() {
        if (this._currToken == aL.VALUE_STRING) {
            return true;
        }
        if (this._currToken == aL.FIELD_NAME) {
            return this._nameCopied;
        }
        return false;
    }

    @Override
    public byte[] getBinaryValue(an an2) {
        if (this._binaryValue == null) {
            if (this._currToken != aL.VALUE_STRING) {
                this._reportError("Current token (" + (Object)((Object)this._currToken) + ") not VALUE_STRING, can not access as binary");
            }
            cX cX2 = this._getByteArrayBuilder();
            bf bf2 = this;
            bf2._decodeBase64(bf2.getText(), cX2, an2);
            this._binaryValue = cX2.toByteArray();
        }
        return this._binaryValue;
    }

    public long getTokenCharacterOffset() {
        return this._tokenInputTotal;
    }

    public int getTokenLineNr() {
        return this._tokenInputRow;
    }

    public int getTokenColumnNr() {
        int n2 = this._tokenInputCol;
        if (n2 < 0) {
            return n2;
        }
        return n2 + 1;
    }

    protected abstract void _closeInput();

    protected void _releaseBuffers() {
        this._textBuffer.releaseBuffers();
        char[] cArray = this._nameCopyBuffer;
        if (this._nameCopyBuffer != null) {
            this._nameCopyBuffer = null;
            this._ioContext.releaseNameCopyBuffer(cArray);
        }
    }

    @Override
    protected void _handleEOF() {
        if (!this._parsingContext.inRoot()) {
            String string = this._parsingContext.inArray() ? "Array" : "Object";
            this._reportInvalidEOF(String.format(": expected close marker for %s (start marker at %s)", string, this._parsingContext.startLocation(this._contentReference())), null);
        }
    }

    protected final int _eofAsNextChar() {
        this._handleEOF();
        return -1;
    }

    public cX _getByteArrayBuilder() {
        if (this._byteArrayBuilder == null) {
            this._byteArrayBuilder = new cX();
        } else {
            this._byteArrayBuilder.reset();
        }
        return this._byteArrayBuilder;
    }

    protected final aL reset(boolean bl2, int n2, int n3, int n4) {
        if (n3 <= 0 && n4 <= 0) {
            return this.resetInt(bl2, n2);
        }
        return this.resetFloat(bl2, n2, n3, n4);
    }

    protected final aL resetInt(boolean bl2, int n2) {
        this._streamReadConstraints.validateIntegerLength(n2);
        this._numberNegative = bl2;
        this._intLength = n2;
        this._fractLength = 0;
        this._expLength = 0;
        this._numTypesValid = 0;
        return aL.VALUE_NUMBER_INT;
    }

    protected final aL resetFloat(boolean bl2, int n2, int n3, int n4) {
        this._streamReadConstraints.validateFPLength(n2 + n3 + n4);
        this._numberNegative = bl2;
        this._intLength = n2;
        this._fractLength = n3;
        this._expLength = n4;
        this._numTypesValid = 0;
        return aL.VALUE_NUMBER_FLOAT;
    }

    protected final aL resetAsNaN(String string, double d2) {
        this._textBuffer.resetWithString(string);
        this._numberDouble = d2;
        this._numTypesValid = 8;
        return aL.VALUE_NUMBER_FLOAT;
    }

    @Override
    public boolean isNaN() {
        if (this._currToken == aL.VALUE_NUMBER_FLOAT && (this._numTypesValid & 8) != 0) {
            return !Double.isFinite(this._getNumberDouble());
        }
        return false;
    }

    @Override
    public Number getNumberValue() {
        if (this._numTypesValid == 0) {
            this._parseNumericValue(0);
        }
        if (this._currToken == aL.VALUE_NUMBER_INT) {
            if ((this._numTypesValid & 1) != 0) {
                return this._numberInt;
            }
            if ((this._numTypesValid & 2) != 0) {
                return this._numberLong;
            }
            if ((this._numTypesValid & 4) != 0) {
                return this._getBigInteger();
            }
            this._throwInternal();
        }
        if ((this._numTypesValid & 0x10) != 0) {
            return this._getBigDecimal();
        }
        if ((this._numTypesValid & 0x20) != 0) {
            return Float.valueOf(this._getNumberFloat());
        }
        if ((this._numTypesValid & 8) == 0) {
            this._throwInternal();
        }
        return this._getNumberDouble();
    }

    @Override
    public Number getNumberValueExact() {
        if (this._currToken == aL.VALUE_NUMBER_INT) {
            if (this._numTypesValid == 0) {
                this._parseNumericValue(0);
            }
            if ((this._numTypesValid & 1) != 0) {
                return this._numberInt;
            }
            if ((this._numTypesValid & 2) != 0) {
                return this._numberLong;
            }
            if ((this._numTypesValid & 4) != 0) {
                return this._getBigInteger();
            }
            this._throwInternal();
        }
        if (this._numTypesValid == 0) {
            this._parseNumericValue(16);
        }
        if ((this._numTypesValid & 0x10) != 0) {
            return this._getBigDecimal();
        }
        if ((this._numTypesValid & 0x20) != 0) {
            return Float.valueOf(this._getNumberFloat());
        }
        if ((this._numTypesValid & 8) == 0) {
            this._throwInternal();
        }
        return this._getNumberDouble();
    }

    @Override
    public Object getNumberValueDeferred() {
        if (this._currToken == aL.VALUE_NUMBER_INT) {
            if (this._numTypesValid == 0) {
                this._parseNumericValue(0);
            }
            if ((this._numTypesValid & 1) != 0) {
                return this._numberInt;
            }
            if ((this._numTypesValid & 2) != 0) {
                return this._numberLong;
            }
            if ((this._numTypesValid & 4) != 0) {
                if (this._numberBigInt != null) {
                    return this._numberBigInt;
                }
                if (this._numberString != null) {
                    return this._numberString;
                }
                return this._getBigInteger();
            }
            this._throwInternal();
        }
        if (this._currToken == aL.VALUE_NUMBER_FLOAT) {
            if ((this._numTypesValid & 0x10) != 0) {
                return this._getBigDecimal();
            }
            if ((this._numTypesValid & 8) != 0) {
                return this._getNumberDouble();
            }
            if ((this._numTypesValid & 0x20) != 0) {
                return Float.valueOf(this._getNumberFloat());
            }
            return this._textBuffer.contentsAsString();
        }
        return this.getNumberValue();
    }

    @Override
    public aE getNumberType() {
        if (this._numTypesValid == 0) {
            this._parseNumericValue(0);
        }
        if (this._currToken == aL.VALUE_NUMBER_INT) {
            if ((this._numTypesValid & 1) != 0) {
                return aE.INT;
            }
            if ((this._numTypesValid & 2) != 0) {
                return aE.LONG;
            }
            return aE.BIG_INTEGER;
        }
        if ((this._numTypesValid & 0x10) != 0) {
            return aE.BIG_DECIMAL;
        }
        if ((this._numTypesValid & 0x20) != 0) {
            return aE.FLOAT;
        }
        return aE.DOUBLE;
    }

    @Override
    public int getIntValue() {
        if ((this._numTypesValid & 1) == 0) {
            if (this._numTypesValid == 0) {
                return this._parseIntValue();
            }
            if ((this._numTypesValid & 1) == 0) {
                this.convertNumberToInt();
            }
        }
        return this._numberInt;
    }

    @Override
    public long getLongValue() {
        if ((this._numTypesValid & 2) == 0) {
            if (this._numTypesValid == 0) {
                this._parseNumericValue(2);
            }
            if ((this._numTypesValid & 2) == 0) {
                this.convertNumberToLong();
            }
        }
        return this._numberLong;
    }

    @Override
    public BigInteger getBigIntegerValue() {
        if ((this._numTypesValid & 4) == 0) {
            if (this._numTypesValid == 0) {
                this._parseNumericValue(4);
            }
            if ((this._numTypesValid & 4) == 0) {
                this.convertNumberToBigInteger();
            }
        }
        return this._getBigInteger();
    }

    @Override
    public float getFloatValue() {
        if ((this._numTypesValid & 0x20) == 0) {
            if (this._numTypesValid == 0) {
                this._parseNumericValue(32);
            }
            if ((this._numTypesValid & 0x20) == 0) {
                this.convertNumberToFloat();
            }
        }
        return this._getNumberFloat();
    }

    @Override
    public double getDoubleValue() {
        if ((this._numTypesValid & 8) == 0) {
            if (this._numTypesValid == 0) {
                this._parseNumericValue(8);
            }
            if ((this._numTypesValid & 8) == 0) {
                this.convertNumberToDouble();
            }
        }
        return this._getNumberDouble();
    }

    @Override
    public BigDecimal getDecimalValue() {
        if ((this._numTypesValid & 0x10) == 0) {
            if (this._numTypesValid == 0) {
                this._parseNumericValue(16);
            }
            if ((this._numTypesValid & 0x10) == 0) {
                this.convertNumberToBigDecimal();
            }
        }
        return this._getBigDecimal();
    }

    @Override
    public aQ streamReadConstraints() {
        return this._streamReadConstraints;
    }

    protected void _parseNumericValue(int n2) {
        if (this._closed) {
            this._reportError("Internal error: _parseNumericValue called when parser instance closed");
        }
        if (this._currToken == aL.VALUE_NUMBER_INT) {
            int n3 = this._intLength;
            if (n3 <= 9) {
                this._numberInt = this._textBuffer.contentsAsInt(this._numberNegative);
                this._numTypesValid = 1;
                return;
            }
            if (n3 <= 18) {
                long l2 = this._textBuffer.contentsAsLong(this._numberNegative);
                if (n3 == 10) {
                    if (this._numberNegative) {
                        if (l2 >= Integer.MIN_VALUE) {
                            this._numberInt = (int)l2;
                            this._numTypesValid = 1;
                            return;
                        }
                    } else if (l2 <= Integer.MAX_VALUE) {
                        this._numberInt = (int)l2;
                        this._numTypesValid = 1;
                        return;
                    }
                }
                this._numberLong = l2;
                this._numTypesValid = 2;
                return;
            }
            if (n3 == 19) {
                char[] cArray = this._textBuffer.getTextBuffer();
                int n4 = this._textBuffer.getTextOffset();
                if (this._numberNegative) {
                    ++n4;
                }
                if (bF.inLongRange(cArray, n4, n3, this._numberNegative)) {
                    this._numberLong = bF.parseLong19(cArray, n4, this._numberNegative);
                    this._numTypesValid = 2;
                    return;
                }
            }
            this._parseSlowInt(n2);
            return;
        }
        if (this._currToken == aL.VALUE_NUMBER_FLOAT) {
            this._parseSlowFloat(n2);
            return;
        }
        this._reportError("Current token (%s) not numeric, can not use numeric value accessors", (Object)this._currToken);
    }

    protected int _parseIntValue() {
        if (this._closed) {
            this._reportError("Internal error: _parseNumericValue called when parser instance closed");
        }
        if (this._currToken == aL.VALUE_NUMBER_INT && this._intLength <= 9) {
            int n2;
            this._numberInt = n2 = this._textBuffer.contentsAsInt(this._numberNegative);
            this._numTypesValid = 1;
            return n2;
        }
        this._parseNumericValue(1);
        if ((this._numTypesValid & 1) == 0) {
            this.convertNumberToInt();
        }
        return this._numberInt;
    }

    private void _parseSlowFloat(int n2) {
        if (n2 == 16) {
            this._numberBigDecimal = null;
            this._numberString = this._textBuffer.contentsAsString();
            this._numTypesValid = 16;
            return;
        }
        if (n2 == 32) {
            this._numberFloat = 0.0f;
            this._numberString = this._textBuffer.contentsAsString();
            this._numTypesValid = 32;
            return;
        }
        this._numberDouble = 0.0;
        this._numberString = this._textBuffer.contentsAsString();
        this._numTypesValid = 8;
    }

    private void _parseSlowInt(int n2) {
        String string = this._textBuffer.contentsAsString();
        if (n2 == 1 || n2 == 2) {
            this._reportTooLongIntegral(n2, string);
        }
        if (n2 == 8 || n2 == 32) {
            this._numberString = string;
            this._numTypesValid = 8;
            return;
        }
        this._numberBigInt = null;
        this._numberString = string;
        this._numTypesValid = 4;
    }

    protected void _reportTooLongIntegral(int n2, String string) {
        if (n2 == 1) {
            this.reportOverflowInt(string);
            return;
        }
        this.reportOverflowLong(string);
    }

    protected void convertNumberToInt() {
        if ((this._numTypesValid & 2) != 0) {
            int n2 = (int)this._numberLong;
            if ((long)n2 != this._numberLong) {
                bf bf2 = this;
                bf2.reportOverflowInt(bf2.getText(), this.currentToken());
            }
            this._numberInt = n2;
        } else if ((this._numTypesValid & 4) != 0) {
            BigInteger bigInteger = this._getBigInteger();
            if (BI_MIN_INT.compareTo(bigInteger) > 0 || BI_MAX_INT.compareTo(bigInteger) < 0) {
                this.reportOverflowInt();
            }
            this._numberInt = bigInteger.intValue();
        } else if ((this._numTypesValid & 8) != 0) {
            double d2 = this._getNumberDouble();
            if (d2 < -2.147483648E9 || d2 > 2.147483647E9) {
                this.reportOverflowInt();
            }
            this._numberInt = (int)d2;
        } else if ((this._numTypesValid & 0x10) != 0) {
            BigDecimal bigDecimal = this._getBigDecimal();
            if (BD_MIN_INT.compareTo(bigDecimal) > 0 || BD_MAX_INT.compareTo(bigDecimal) < 0) {
                this.reportOverflowInt();
            }
            this._numberInt = bigDecimal.intValue();
        } else {
            this._throwInternal();
        }
        this._numTypesValid |= 1;
    }

    protected void convertNumberToLong() {
        if ((this._numTypesValid & 1) != 0) {
            this._numberLong = this._numberInt;
        } else if ((this._numTypesValid & 4) != 0) {
            BigInteger bigInteger = this._getBigInteger();
            if (BI_MIN_LONG.compareTo(bigInteger) > 0 || BI_MAX_LONG.compareTo(bigInteger) < 0) {
                this.reportOverflowLong();
            }
            this._numberLong = bigInteger.longValue();
        } else if ((this._numTypesValid & 8) != 0) {
            double d2 = this._getNumberDouble();
            if (d2 < -9.223372036854776E18 || d2 > 9.223372036854776E18) {
                this.reportOverflowLong();
            }
            this._numberLong = (long)d2;
        } else if ((this._numTypesValid & 0x10) != 0) {
            BigDecimal bigDecimal = this._getBigDecimal();
            if (BD_MIN_LONG.compareTo(bigDecimal) > 0 || BD_MAX_LONG.compareTo(bigDecimal) < 0) {
                this.reportOverflowLong();
            }
            this._numberLong = bigDecimal.longValue();
        } else {
            this._throwInternal();
        }
        this._numTypesValid |= 2;
    }

    protected void convertNumberToBigInteger() {
        if ((this._numTypesValid & 0x10) != 0) {
            this._numberBigInt = this._convertBigDecimalToBigInteger(this._getBigDecimal());
        } else if ((this._numTypesValid & 2) != 0) {
            this._numberBigInt = BigInteger.valueOf(this._numberLong);
        } else if ((this._numTypesValid & 1) != 0) {
            this._numberBigInt = BigInteger.valueOf(this._numberInt);
        } else if ((this._numTypesValid & 8) != 0) {
            this._numberBigInt = this._numberString != null ? this._convertBigDecimalToBigInteger(this._getBigDecimal()) : this._convertBigDecimalToBigInteger(BigDecimal.valueOf(this._getNumberDouble()));
        } else {
            this._throwInternal();
        }
        this._numTypesValid |= 4;
    }

    protected void convertNumberToDouble() {
        if ((this._numTypesValid & 0x10) != 0) {
            this._numberDouble = this._numberString != null ? this._getNumberDouble() : this._getBigDecimal().doubleValue();
        } else if ((this._numTypesValid & 4) != 0) {
            this._numberDouble = this._numberString != null ? this._getNumberDouble() : this._getBigInteger().doubleValue();
        } else if ((this._numTypesValid & 2) != 0) {
            this._numberDouble = this._numberLong;
        } else if ((this._numTypesValid & 1) != 0) {
            this._numberDouble = this._numberInt;
        } else if ((this._numTypesValid & 0x20) != 0) {
            this._numberDouble = this._numberString != null ? this._getNumberDouble() : (double)this._getNumberFloat();
        } else {
            this._throwInternal();
        }
        this._numTypesValid |= 8;
    }

    protected void convertNumberToFloat() {
        if ((this._numTypesValid & 0x10) != 0) {
            this._numberFloat = this._numberString != null ? this._getNumberFloat() : this._getBigDecimal().floatValue();
        } else if ((this._numTypesValid & 4) != 0) {
            this._numberFloat = this._numberString != null ? this._getNumberFloat() : this._getBigInteger().floatValue();
        } else if ((this._numTypesValid & 2) != 0) {
            this._numberFloat = this._numberLong;
        } else if ((this._numTypesValid & 1) != 0) {
            this._numberFloat = this._numberInt;
        } else if ((this._numTypesValid & 8) != 0) {
            this._numberFloat = this._numberString != null ? this._getNumberFloat() : (float)this._getNumberDouble();
        } else {
            this._throwInternal();
        }
        this._numTypesValid |= 0x20;
    }

    protected void convertNumberToBigDecimal() {
        if ((this._numTypesValid & 8) != 0) {
            String string = this._numberString == null ? this.getText() : this._numberString;
            this._numberBigDecimal = bF.parseBigDecimal(string, this.isEnabled(aS.USE_FAST_BIG_NUMBER_PARSER));
        } else if ((this._numTypesValid & 4) != 0) {
            this._numberBigDecimal = new BigDecimal(this._getBigInteger());
        } else if ((this._numTypesValid & 2) != 0) {
            this._numberBigDecimal = BigDecimal.valueOf(this._numberLong);
        } else if ((this._numTypesValid & 1) != 0) {
            this._numberBigDecimal = BigDecimal.valueOf(this._numberInt);
        } else {
            this._throwInternal();
        }
        this._numTypesValid |= 0x10;
    }

    protected BigInteger _convertBigDecimalToBigInteger(BigDecimal bigDecimal) {
        this._streamReadConstraints.validateBigIntegerScale(bigDecimal.scale());
        return bigDecimal.toBigInteger();
    }

    protected BigInteger _getBigInteger() {
        if (this._numberBigInt != null) {
            return this._numberBigInt;
        }
        if (this._numberString == null) {
            throw new IllegalStateException("cannot get BigInteger from current parser state");
        }
        try {
            this._numberBigInt = bF.parseBigInteger(this._numberString, this.isEnabled(aS.USE_FAST_BIG_NUMBER_PARSER));
        }
        catch (NumberFormatException numberFormatException) {
            bf bf2 = this;
            this._wrapError("Malformed numeric value (" + bf2._longNumberDesc(bf2._numberString) + ")", numberFormatException);
        }
        this._numberString = null;
        return this._numberBigInt;
    }

    protected BigDecimal _getBigDecimal() {
        if (this._numberBigDecimal != null) {
            return this._numberBigDecimal;
        }
        if (this._numberString == null) {
            throw new IllegalStateException("cannot get BigDecimal from current parser state");
        }
        try {
            this._numberBigDecimal = bF.parseBigDecimal(this._numberString, this.isEnabled(aS.USE_FAST_BIG_NUMBER_PARSER));
        }
        catch (NumberFormatException numberFormatException) {
            bf bf2 = this;
            this._wrapError("Malformed numeric value (" + bf2._longNumberDesc(bf2._numberString) + ")", numberFormatException);
        }
        this._numberString = null;
        return this._numberBigDecimal;
    }

    protected double _getNumberDouble() {
        if (this._numberString != null) {
            try {
                this._numberDouble = bF.parseDouble(this._numberString, this.isEnabled(aS.USE_FAST_DOUBLE_PARSER));
            }
            catch (NumberFormatException numberFormatException) {
                bf bf2 = this;
                this._wrapError("Malformed numeric value (" + bf2._longNumberDesc(bf2._numberString) + ")", numberFormatException);
            }
            this._numberString = null;
        }
        return this._numberDouble;
    }

    protected float _getNumberFloat() {
        if (this._numberString != null) {
            try {
                this._numberFloat = bF.parseFloat(this._numberString, this.isEnabled(aS.USE_FAST_DOUBLE_PARSER));
            }
            catch (NumberFormatException numberFormatException) {
                bf bf2 = this;
                this._wrapError("Malformed numeric value (" + bf2._longNumberDesc(bf2._numberString) + ")", numberFormatException);
            }
            this._numberString = null;
        }
        return this._numberFloat;
    }

    protected void createChildArrayContext(int n2, int n3) {
        this._parsingContext = this._parsingContext.createChildArrayContext(n2, n3);
        this._streamReadConstraints.validateNestingDepth(this._parsingContext.getNestingDepth());
    }

    protected void createChildObjectContext(int n2, int n3) {
        this._parsingContext = this._parsingContext.createChildObjectContext(n2, n3);
        this._streamReadConstraints.validateNestingDepth(this._parsingContext.getNestingDepth());
    }

    protected void _reportMismatchedEndMarker(int n2, char c2) {
        cy cy2 = this.getParsingContext();
        this._reportError(String.format("Unexpected close marker '%s': expected '%c' (for %s starting at %s)", Character.valueOf((char)n2), Character.valueOf(c2), cy2.typeDesc(), cy2.startLocation(this._contentReference())));
    }

    protected char _handleUnrecognizedCharacterEscape(char c2) {
        if (this.isEnabled(aD.ALLOW_BACKSLASH_ESCAPING_ANY_CHARACTER)) {
            return c2;
        }
        if (c2 == '\'' && this.isEnabled(aD.ALLOW_SINGLE_QUOTES)) {
            return c2;
        }
        this._reportError("Unrecognized character escape " + bf._getCharDesc(c2));
        return c2;
    }

    protected void _throwUnquotedSpace(int n2, String string) {
        if (!this.isEnabled(aD.ALLOW_UNQUOTED_CONTROL_CHARS) || n2 > 32) {
            n2 = (char)n2;
            String string2 = "Illegal unquoted character (" + bf._getCharDesc(n2) + "): has to be escaped using backslash to be included in " + string;
            this._reportError(string2);
        }
    }

    protected String _validJsonTokenList() {
        return this._validJsonValueList();
    }

    protected String _validJsonValueList() {
        if (this.isEnabled(aD.ALLOW_NON_NUMERIC_NUMBERS)) {
            return "(JSON String, Number (or 'NaN'/'INF'/'+INF'), Array, Object or token 'null', 'true' or 'false')";
        }
        return "(JSON String, Number, Array, Object or token 'null', 'true' or 'false')";
    }

    protected char _decodeEscaped() {
        throw new UnsupportedOperationException();
    }

    protected final int _decodeBase64Escape(an an2, int n2, int n3) {
        if (n2 != 92) {
            throw this.reportInvalidBase64Char(an2, n2, n3);
        }
        char c2 = this._decodeEscaped();
        n2 = c2;
        if (c2 <= ' ' && n3 == 0) {
            return -1;
        }
        int n4 = an2.decodeBase64Char(n2);
        if (n4 < 0 && n4 != -2) {
            throw this.reportInvalidBase64Char(an2, n2, n3);
        }
        return n4;
    }

    protected final int _decodeBase64Escape(an an2, char c2, int n2) {
        if (c2 != '\\') {
            throw this.reportInvalidBase64Char(an2, c2, n2);
        }
        c2 = this._decodeEscaped();
        if (c2 <= ' ' && n2 == 0) {
            return -1;
        }
        int n3 = an2.decodeBase64Char(c2);
        if (n3 < 0 && (n3 != -2 || n2 < 2)) {
            throw this.reportInvalidBase64Char(an2, c2, n2);
        }
        return n3;
    }

    protected IllegalArgumentException reportInvalidBase64Char(an an2, int n2, int n3) {
        return this.reportInvalidBase64Char(an2, n2, n3, null);
    }

    protected IllegalArgumentException reportInvalidBase64Char(an object, int n2, int n3, String string) {
        object = n2 <= 32 ? String.format("Illegal white space character (code 0x%s) as character #%d of 4-char base64 unit: can only used between units", Integer.toHexString(n2), n3 + 1) : (((an)object).usesPaddingChar(n2) ? "Unexpected padding character ('" + ((an)object).getPaddingChar() + "') as character #" + (n3 + 1) + " of 4-char base64 unit: padding only legal as 3rd or 4th character" : (!Character.isDefined(n2) || Character.isISOControl(n2) ? "Illegal character (code 0x" + Integer.toHexString(n2) + ") in base64 content" : "Illegal character '" + (char)n2 + "' (code 0x" + Integer.toHexString(n2) + ") in base64 content"));
        if (string != null) {
            object = (String)object + ": " + string;
        }
        return new IllegalArgumentException((String)object);
    }

    protected void _handleBase64MissingPadding(an an2) {
        this._reportError(an2.missingPaddingMessage());
    }

    @Deprecated
    protected Object _getSourceReference() {
        if (aD.INCLUDE_SOURCE_IN_LOCATION.enabledIn(this._features)) {
            return this._ioContext.contentReference().getRawContent();
        }
        return null;
    }

    protected by _contentReference() {
        if (aD.INCLUDE_SOURCE_IN_LOCATION.enabledIn(this._features)) {
            return this._ioContext.contentReference();
        }
        return by.unknown();
    }

    protected static int[] growArrayBy(int[] nArray, int n2) {
        if (nArray == null) {
            return new int[n2];
        }
        return Arrays.copyOf(nArray, nArray.length + n2);
    }

    @Deprecated
    protected void loadMoreGuaranteed() {
        if (!this.loadMore()) {
            this._reportInvalidEOF();
        }
    }

    @Deprecated
    protected boolean loadMore() {
        return false;
    }

    protected void _finishString() {
    }
}

