/*
 * Decompiled with CFR 0.152.
 */
package liquibase.pro.packaged;

import java.lang.annotation.Annotation;
import java.lang.annotation.Retention;
import java.lang.annotation.Target;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import liquibase.pro.packaged.dF;
import liquibase.pro.packaged.ds;
import liquibase.pro.packaged.fd;
import liquibase.pro.packaged.iL;
import liquibase.pro.packaged.jH;
import liquibase.pro.packaged.jd;
import liquibase.pro.packaged.jq;
import liquibase.pro.packaged.oC;
import liquibase.pro.packaged.oh;
import liquibase.pro.packaged.op;

public final class iN {
    private static final op NO_ANNOTATIONS = jd.emptyAnnotations();
    private static final Class<?> CLS_OBJECT = Object.class;
    private static final Class<?> CLS_ENUM = Enum.class;
    private static final Class<?> CLS_LIST = List.class;
    private static final Class<?> CLS_MAP = Map.class;
    private final fd<?> _config;
    private final ds _intr;
    private final jq _mixInResolver;
    private final oh _bindings;
    private final dF _type;
    private final Class<?> _class;
    private final Class<?> _primaryMixin;
    private final boolean _collectAnnotations;

    iN(fd<?> fd2, dF dF2, jq jq2) {
        this._config = fd2;
        this._type = dF2;
        this._class = dF2.getRawClass();
        this._mixInResolver = jq2;
        this._bindings = dF2.getBindings();
        this._intr = fd2.isAnnotationProcessingEnabled() ? fd2.getAnnotationIntrospector() : null;
        this._primaryMixin = jq2 == null ? null : jq2.findMixInClassFor(this._class);
        this._collectAnnotations = this._intr != null && (!oC.isJDKClass(this._class) || !this._type.isContainerType());
    }

    iN(fd<?> fd2, Class<?> clazz, jq jq2) {
        Class<?> clazz2;
        iN iN2;
        this._config = fd2;
        this._type = null;
        this._class = clazz;
        this._mixInResolver = jq2;
        this._bindings = oh.emptyBindings();
        if (fd2 == null) {
            this._intr = null;
            iN2 = this;
            clazz2 = null;
        } else {
            this._intr = fd2.isAnnotationProcessingEnabled() ? fd2.getAnnotationIntrospector() : null;
            iN2 = this;
            clazz2 = jq2 == null ? null : jq2.findMixInClassFor(this._class);
        }
        iN2._primaryMixin = clazz2;
        this._collectAnnotations = this._intr != null;
    }

    public static iL resolve(fd<?> fd2, dF dF2, jq jq2) {
        if (dF2.isArrayType() && iN.skippableArray(fd2, dF2.getRawClass())) {
            return iN.createArrayType(fd2, dF2.getRawClass());
        }
        return new iN(fd2, dF2, jq2).resolveFully();
    }

    public static iL resolveWithoutSuperTypes(fd<?> fd2, Class<?> clazz) {
        return iN.resolveWithoutSuperTypes(fd2, clazz, fd2);
    }

    public static iL resolveWithoutSuperTypes(fd<?> fd2, dF dF2, jq jq2) {
        if (dF2.isArrayType() && iN.skippableArray(fd2, dF2.getRawClass())) {
            return iN.createArrayType(fd2, dF2.getRawClass());
        }
        return new iN(fd2, dF2, jq2).resolveWithoutSuperTypes();
    }

    public static iL resolveWithoutSuperTypes(fd<?> fd2, Class<?> clazz, jq jq2) {
        if (clazz.isArray() && iN.skippableArray(fd2, clazz)) {
            return iN.createArrayType(fd2, clazz);
        }
        return new iN(fd2, clazz, jq2).resolveWithoutSuperTypes();
    }

    private static boolean skippableArray(fd<?> fd2, Class<?> clazz) {
        return fd2 == null || fd2.findMixInClassFor(clazz) == null;
    }

    static iL createPrimordial(Class<?> clazz) {
        return new iL(clazz);
    }

    static iL createArrayType(fd<?> fd2, Class<?> clazz) {
        return new iL(clazz);
    }

    final iL resolveFully() {
        ArrayList<dF> arrayList = new ArrayList<dF>(8);
        if (!this._type.hasRawClass(Object.class)) {
            if (this._type.isInterface()) {
                iN._addSuperInterfaces(this._type, arrayList, false);
            } else {
                iN._addSuperTypes(this._type, arrayList, false);
            }
        }
        return new iL(this._type, this._class, arrayList, this._primaryMixin, this.resolveClassAnnotations(arrayList), this._bindings, this._intr, this._mixInResolver, this._config.getTypeFactory(), this._collectAnnotations);
    }

    final iL resolveWithoutSuperTypes() {
        List<dF> list = Collections.emptyList();
        return new iL(null, this._class, list, this._primaryMixin, this.resolveClassAnnotations(list), this._bindings, this._intr, this._mixInResolver, this._config.getTypeFactory(), this._collectAnnotations);
    }

    private static void _addSuperTypes(dF object, List<dF> list, boolean bl2) {
        while (true) {
            Class<?> clazz;
            if ((clazz = ((dF)object).getRawClass()) == CLS_OBJECT || clazz == CLS_ENUM) {
                return;
            }
            if (bl2) {
                if (iN._contains(list, clazz)) {
                    return;
                }
                list.add((dF)object);
            }
            Object object2 = ((dF)object).getInterfaces().iterator();
            while (object2.hasNext()) {
                iN._addSuperInterfaces(object2.next(), list, true);
            }
            object2 = ((dF)object).getSuperClass();
            if (object2 == null) break;
            bl2 = true;
            object = object2;
        }
    }

    private static void _addSuperInterfaces(dF object, List<dF> list, boolean bl2) {
        Class<?> clazz = ((dF)object).getRawClass();
        if (bl2) {
            if (iN._contains(list, clazz)) {
                return;
            }
            list.add((dF)object);
            if (clazz == CLS_LIST || clazz == CLS_MAP) {
                return;
            }
        }
        object = ((dF)object).getInterfaces().iterator();
        while (object.hasNext()) {
            iN._addSuperInterfaces((dF)object.next(), list, true);
        }
    }

    private static boolean _contains(List<dF> list, Class<?> clazz) {
        int n2 = list.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            if (list.get(i2).getRawClass() != clazz) continue;
            return true;
        }
        return false;
    }

    private op resolveClassAnnotations(List<dF> object) {
        if (this._intr == null) {
            return NO_ANNOTATIONS;
        }
        boolean bl2 = this._mixInResolver != null && (!(this._mixInResolver instanceof jH) || ((jH)this._mixInResolver).hasMixIns());
        if (!bl2 && !this._collectAnnotations) {
            return NO_ANNOTATIONS;
        }
        jd jd2 = jd.emptyCollector();
        if (this._primaryMixin != null) {
            jd2 = this._addClassMixIns(jd2, this._class, this._primaryMixin);
        }
        if (this._collectAnnotations) {
            jd2 = this._addAnnotationsIfNotPresent(jd2, oC.findClassAnnotations(this._class));
        }
        object = object.iterator();
        while (object.hasNext()) {
            dF dF2 = (dF)object.next();
            if (bl2) {
                Class<?> clazz = dF2.getRawClass();
                jd2 = this._addClassMixIns(jd2, clazz, this._mixInResolver.findMixInClassFor(clazz));
            }
            if (!this._collectAnnotations) continue;
            jd2 = this._addAnnotationsIfNotPresent(jd2, oC.findClassAnnotations(dF2.getRawClass()));
        }
        if (bl2) {
            jd2 = this._addClassMixIns(jd2, Object.class, this._mixInResolver.findMixInClassFor(Object.class));
        }
        return jd2.asAnnotations();
    }

    private jd _addClassMixIns(jd jd2, Class<?> object, Class<?> clazz2) {
        if (clazz2 != null) {
            jd2 = this._addAnnotationsIfNotPresent(jd2, oC.findClassAnnotations(clazz2));
            for (Class<?> clazz : oC.findSuperClasses(clazz2, object, false)) {
                jd2 = this._addAnnotationsIfNotPresent(jd2, oC.findClassAnnotations(clazz));
            }
        }
        return jd2;
    }

    private jd _addAnnotationsIfNotPresent(jd jd2, Annotation[] annotationArray) {
        if (annotationArray != null) {
            for (Annotation annotation : annotationArray) {
                if (jd2.isPresent(annotation)) continue;
                jd2 = jd2.addOrOverride(annotation);
                if (!this._intr.isAnnotationBundle(annotation)) continue;
                jd2 = this._addFromBundleIfNotPresent(jd2, annotation);
            }
        }
        return jd2;
    }

    private jd _addFromBundleIfNotPresent(jd jd2, Annotation annotationArray) {
        for (Annotation annotation : oC.findClassAnnotations(annotationArray.annotationType())) {
            if (annotation instanceof Target || annotation instanceof Retention || jd2.isPresent(annotation)) continue;
            jd2 = jd2.addOrOverride(annotation);
            if (!this._intr.isAnnotationBundle(annotation)) continue;
            jd2 = this._addFromBundleIfNotPresent(jd2, annotation);
        }
        return jd2;
    }
}

