/*
 * Decompiled with CFR 0.152.
 */
package liquibase.pro.packaged;

import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicLongArray;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.atomic.AtomicReferenceArray;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import liquibase.pro.packaged.pA;
import liquibase.pro.packaged.pB;
import liquibase.pro.packaged.pl;
import liquibase.pro.packaged.pn$1;
import liquibase.pro.packaged.po;
import liquibase.pro.packaged.pp;
import liquibase.pro.packaged.pq;
import liquibase.pro.packaged.ps;
import liquibase.pro.packaged.pu;
import liquibase.pro.packaged.pv;
import liquibase.pro.packaged.pw;
import liquibase.pro.packaged.px;
import liquibase.pro.packaged.py;

public final class pn<K, V>
extends AbstractMap<K, V>
implements Serializable,
ConcurrentMap<K, V> {
    static final int NCPU = Runtime.getRuntime().availableProcessors();
    static final long MAXIMUM_CAPACITY = 9223372034707292160L;
    static final int NUMBER_OF_READ_BUFFERS = Math.min(4, pn.ceilingNextPowerOfTwo(NCPU));
    static final int READ_BUFFERS_MASK = NUMBER_OF_READ_BUFFERS - 1;
    static final int READ_BUFFER_THRESHOLD = 4;
    static final int READ_BUFFER_DRAIN_THRESHOLD = 8;
    static final int READ_BUFFER_SIZE = 16;
    static final int READ_BUFFER_INDEX_MASK = 15;
    static final int WRITE_BUFFER_DRAIN_THRESHOLD = 16;
    final ConcurrentMap<K, pv<K, V>> data;
    final int concurrencyLevel;
    final long[] readBufferReadCount;
    final pl<pv<K, V>> evictionDeque;
    final AtomicLong weightedSize;
    final AtomicLong capacity;
    final Lock evictionLock;
    final Queue<Runnable> writeBuffer;
    final AtomicLongArray readBufferWriteCount;
    final AtomicLongArray readBufferDrainAtWriteCount;
    final AtomicReferenceArray<pv<K, V>> readBuffers;
    final AtomicReference<pq> drainStatus;
    transient Set<K> keySet;
    transient Collection<V> values;
    transient Set<Map.Entry<K, V>> entrySet;
    static final long serialVersionUID = 1L;

    static int ceilingNextPowerOfTwo(int n2) {
        return 1 << 32 - Integer.numberOfLeadingZeros(n2 - 1);
    }

    private static int readBufferIndex(int n2, int n3) {
        return (n2 << 4) + n3;
    }

    private pn(pp<K, V> pp2) {
        this.concurrencyLevel = pp2.concurrencyLevel;
        this.capacity = new AtomicLong(Math.min(pp2.capacity, 9223372034707292160L));
        this.data = new ConcurrentHashMap<K, pv<K, V>>(pp2.initialCapacity, 0.75f, this.concurrencyLevel);
        this.evictionLock = new ReentrantLock();
        this.weightedSize = new AtomicLong();
        this.evictionDeque = new pl();
        this.writeBuffer = new ConcurrentLinkedQueue<Runnable>();
        this.drainStatus = new AtomicReference<pq>(pq.IDLE);
        this.readBufferReadCount = new long[NUMBER_OF_READ_BUFFERS];
        this.readBufferWriteCount = new AtomicLongArray(NUMBER_OF_READ_BUFFERS);
        this.readBufferDrainAtWriteCount = new AtomicLongArray(NUMBER_OF_READ_BUFFERS);
        this.readBuffers = new AtomicReferenceArray(NUMBER_OF_READ_BUFFERS << 4);
    }

    static void checkNotNull(Object object) {
        if (object == null) {
            throw new NullPointerException();
        }
    }

    static void checkArgument(boolean bl2) {
        if (!bl2) {
            throw new IllegalArgumentException();
        }
    }

    static void checkState(boolean bl2) {
        if (!bl2) {
            throw new IllegalStateException();
        }
    }

    public final long capacity() {
        return this.capacity.get();
    }

    public final void setCapacity(long l2) {
        pn.checkArgument(l2 >= 0L);
        this.evictionLock.lock();
        try {
            this.capacity.lazySet(Math.min(l2, 9223372034707292160L));
            this.drainBuffers();
            this.evict();
            return;
        }
        finally {
            this.evictionLock.unlock();
        }
    }

    final boolean hasOverflowed() {
        return this.weightedSize.get() > this.capacity.get();
    }

    final void evict() {
        while (this.hasOverflowed()) {
            pv pv2 = (pv)this.evictionDeque.poll();
            if (pv2 == null) {
                return;
            }
            this.data.remove(pv2.key, pv2);
            this.makeDead(pv2);
        }
    }

    final void afterRead(pv<K, V> pv2) {
        int n2 = pn.readBufferIndex();
        long l2 = this.recordRead(n2, pv2);
        this.drainOnReadIfNeeded(n2, l2);
    }

    static int readBufferIndex() {
        return (int)Thread.currentThread().getId() & READ_BUFFERS_MASK;
    }

    final long recordRead(int n2, pv<K, V> pv2) {
        long l2 = this.readBufferWriteCount.get(n2);
        this.readBufferWriteCount.lazySet(n2, l2 + 1L);
        int n3 = (int)(l2 & 0xFL);
        this.readBuffers.lazySet(pn.readBufferIndex(n2, n3), pv2);
        return l2;
    }

    final void drainOnReadIfNeeded(int n2, long l2) {
        int n3 = n2 = l2 - this.readBufferDrainAtWriteCount.get(n2) < 4L ? 1 : 0;
        if (this.drainStatus.get().shouldDrainBuffers(n2 != 0)) {
            this.tryToDrainBuffers();
        }
    }

    final void afterWrite(Runnable runnable) {
        this.writeBuffer.add(runnable);
        this.drainStatus.lazySet(pq.REQUIRED);
        this.tryToDrainBuffers();
    }

    final void tryToDrainBuffers() {
        if (this.evictionLock.tryLock()) {
            try {
                this.drainStatus.lazySet(pq.PROCESSING);
                this.drainBuffers();
                return;
            }
            finally {
                this.drainStatus.compareAndSet(pq.PROCESSING, pq.IDLE);
                this.evictionLock.unlock();
            }
        }
    }

    final void drainBuffers() {
        this.drainReadBuffers();
        this.drainWriteBuffer();
    }

    final void drainReadBuffers() {
        int n2;
        int n3 = n2 + NUMBER_OF_READ_BUFFERS;
        for (n2 = (int)Thread.currentThread().getId(); n2 < n3; ++n2) {
            this.drainReadBuffer(n2 & READ_BUFFERS_MASK);
        }
    }

    final void drainReadBuffer(int n2) {
        long l2 = this.readBufferWriteCount.get(n2);
        for (int i2 = 0; i2 < 8; ++i2) {
            int n3 = (int)(this.readBufferReadCount[n2] & 0xFL);
            pv<K, V> pv2 = this.readBuffers.get(n3 = pn.readBufferIndex(n2, n3));
            if (pv2 == null) break;
            this.readBuffers.lazySet(n3, null);
            this.applyRead(pv2);
            int n4 = n2;
            this.readBufferReadCount[n4] = this.readBufferReadCount[n4] + 1L;
        }
        this.readBufferDrainAtWriteCount.lazySet(n2, l2);
    }

    final void applyRead(pv<K, V> pv2) {
        if (this.evictionDeque.contains(pv2)) {
            this.evictionDeque.moveToBack(pv2);
        }
    }

    final void drainWriteBuffer() {
        Runnable runnable;
        for (int i2 = 0; i2 < 16 && (runnable = this.writeBuffer.poll()) != null; ++i2) {
            runnable.run();
        }
    }

    final boolean tryToRetire(pv<K, V> pv2, pB<V> pB2) {
        if (pB2.isAlive()) {
            pB pB3 = new pB(pB2.value, -pB2.weight);
            return pv2.compareAndSet(pB2, pB3);
        }
        return false;
    }

    final void makeRetired(pv<K, V> pv2) {
        pB pB2;
        pB pB3;
        do {
            if ((pB3 = (pB)pv2.get()).isAlive()) continue;
            return;
        } while (!pv2.compareAndSet(pB3, pB2 = new pB(pB3.value, -pB3.weight)));
    }

    final void makeDead(pv<K, V> pv2) {
        pB pB2;
        pB pB3;
        while (!pv2.compareAndSet(pB3 = (pB)pv2.get(), pB2 = new pB(pB3.value, 0))) {
        }
        this.weightedSize.lazySet(this.weightedSize.get() - (long)Math.abs(pB3.weight));
    }

    @Override
    public final boolean isEmpty() {
        return this.data.isEmpty();
    }

    @Override
    public final int size() {
        return this.data.size();
    }

    @Override
    public final void clear() {
        this.evictionLock.lock();
        try {
            Runnable runnable;
            pv pv2;
            while ((pv2 = (pv)this.evictionDeque.poll()) != null) {
                this.data.remove(pv2.key, pv2);
                this.makeDead(pv2);
            }
            for (int i2 = 0; i2 < this.readBuffers.length(); ++i2) {
                this.readBuffers.lazySet(i2, null);
            }
            while ((runnable = this.writeBuffer.poll()) != null) {
                runnable.run();
            }
            return;
        }
        finally {
            this.evictionLock.unlock();
        }
    }

    @Override
    public final boolean containsKey(Object object) {
        return this.data.containsKey(object);
    }

    @Override
    public final boolean containsValue(Object object) {
        pn.checkNotNull(object);
        Iterator iterator = this.data.values().iterator();
        while (iterator.hasNext()) {
            if (!((pv)iterator.next()).getValue().equals(object)) continue;
            return true;
        }
        return false;
    }

    @Override
    public final V get(Object object) {
        if ((object = (pv)this.data.get(object)) == null) {
            return null;
        }
        this.afterRead((pv<K, V>)object);
        return ((pv)object).getValue();
    }

    @Override
    public final V put(K k2, V v2) {
        return this.put(k2, v2, false);
    }

    @Override
    public final V putIfAbsent(K k2, V v2) {
        return this.put(k2, v2, true);
    }

    final V put(K object, V object2, boolean bl2) {
        pB pB2;
        pv<K, pB> pv2;
        pn.checkNotNull(object);
        pn.checkNotNull(object2);
        object2 = new pB<V>(object2, 1);
        object = new pv(object, object2);
        block0: while (true) {
            if ((pv2 = this.data.putIfAbsent(((pv)object).key, object)) == null) {
                this.afterWrite(new po(this, (pv)object, 1));
                return null;
            }
            if (bl2) {
                this.afterRead(pv2);
                return pv2.getValue();
            }
            do {
                if (!(pB2 = (pB)pv2.get()).isAlive()) continue block0;
            } while (!pv2.compareAndSet(pB2, (pB)object2));
            break;
        }
        int n2 = 1 - pB2.weight;
        if (n2 == 0) {
            this.afterRead(pv2);
        } else {
            this.afterWrite(new py(this, pv2, n2));
        }
        return pB2.value;
    }

    @Override
    public final V remove(Object object) {
        if ((object = (pv)this.data.remove(object)) == null) {
            return null;
        }
        this.makeRetired((pv<K, V>)object);
        this.afterWrite(new pw(this, (pv)object));
        return ((pv)object).getValue();
    }

    @Override
    public final boolean remove(Object object, Object object2) {
        pv pv2 = (pv)this.data.get(object);
        if (pv2 == null || object2 == null) {
            return false;
        }
        pB pB2 = (pB)pv2.get();
        while (pB2.contains(object2)) {
            if (this.tryToRetire(pv2, pB2)) {
                if (!this.data.remove(object, pv2)) break;
                this.afterWrite(new pw(this, pv2));
                return true;
            }
            pB2 = (pB)pv2.get();
            if (pB2.isAlive()) continue;
        }
        return false;
    }

    @Override
    public final V replace(K object, V object2) {
        pB pB2;
        pn.checkNotNull(object);
        pn.checkNotNull(object2);
        object2 = new pB<V>(object2, 1);
        object = (pv)this.data.get(object);
        if (object == null) {
            return null;
        }
        do {
            if ((pB2 = (pB)((AtomicReference)object).get()).isAlive()) continue;
            return null;
        } while (!((AtomicReference)object).compareAndSet(pB2, object2));
        int n2 = 1 - pB2.weight;
        if (n2 == 0) {
            this.afterRead((pv<K, V>)object);
        } else {
            this.afterWrite(new py(this, (pv)object, n2));
        }
        return pB2.value;
    }

    @Override
    public final boolean replace(K object, V v2, V object2) {
        pB pB2;
        pn.checkNotNull(object);
        pn.checkNotNull(v2);
        pn.checkNotNull(object2);
        object2 = new pB<V>(object2, 1);
        object = (pv)this.data.get(object);
        if (object == null) {
            return false;
        }
        do {
            if ((pB2 = (pB)((AtomicReference)object).get()).isAlive() && pB2.contains(v2)) continue;
            return false;
        } while (!((AtomicReference)object).compareAndSet(pB2, object2));
        int n2 = 1 - pB2.weight;
        if (n2 == 0) {
            this.afterRead((pv<K, V>)object);
        } else {
            this.afterWrite(new py(this, (pv)object, n2));
        }
        return true;
    }

    @Override
    public final Set<K> keySet() {
        Set<K> set = this.keySet;
        if (set == null) {
            this.keySet = new pu(this);
            return this.keySet;
        }
        return set;
    }

    @Override
    public final Collection<V> values() {
        Collection<V> collection = this.values;
        if (collection == null) {
            this.values = new pA(this);
            return this.values;
        }
        return collection;
    }

    @Override
    public final Set<Map.Entry<K, V>> entrySet() {
        Set<Map.Entry<K, V>> set = this.entrySet;
        if (set == null) {
            this.entrySet = new ps(this);
            return this.entrySet;
        }
        return set;
    }

    final Object writeReplace() {
        return new px(this);
    }

    private void readObject(ObjectInputStream objectInputStream) {
        throw new InvalidObjectException("Proxy required");
    }

    /* synthetic */ pn(pp pp2, pn$1 pn$1) {
        this(pp2);
    }
}

