/*
 * Decompiled with CFR 0.152.
 */
package liquibase.repackaged.net.sf.jsqlparser.statement.select;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import liquibase.repackaged.net.sf.jsqlparser.statement.Statement;
import liquibase.repackaged.net.sf.jsqlparser.statement.StatementVisitor;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.SelectBody;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.WithItem;

public class Select
implements Statement {
    private SelectBody selectBody;
    private List<WithItem> withItemsList;
    private boolean useWithBrackets = false;

    @Override
    public void accept(StatementVisitor statementVisitor) {
        statementVisitor.visit(this);
    }

    public SelectBody getSelectBody() {
        return this.selectBody;
    }

    public Select withSelectBody(SelectBody selectBody) {
        this.setSelectBody(selectBody);
        return this;
    }

    public void setSelectBody(SelectBody selectBody) {
        this.selectBody = selectBody;
    }

    public void setUsingWithBrackets(boolean bl2) {
        this.useWithBrackets = bl2;
    }

    public Select withUsingWithBrackets(boolean bl2) {
        this.useWithBrackets = bl2;
        return this;
    }

    public boolean isUsingWithBrackets() {
        return this.useWithBrackets;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.withItemsList != null && !this.withItemsList.isEmpty()) {
            if (this.useWithBrackets) {
                stringBuilder.append("( ");
            }
            stringBuilder.append("WITH ");
            Iterator<WithItem> iterator = this.withItemsList.iterator();
            while (iterator.hasNext()) {
                WithItem withItem = iterator.next();
                stringBuilder.append(withItem);
                if (iterator.hasNext()) {
                    stringBuilder.append(",");
                }
                stringBuilder.append(" ");
            }
        }
        stringBuilder.append(this.selectBody);
        if (this.withItemsList != null && !this.withItemsList.isEmpty() && this.useWithBrackets) {
            stringBuilder.append(" )");
        }
        return stringBuilder.toString();
    }

    public List<WithItem> getWithItemsList() {
        return this.withItemsList;
    }

    public void setWithItemsList(List<WithItem> list) {
        this.withItemsList = list;
    }

    public Select withWithItemsList(List<WithItem> list) {
        this.setWithItemsList(list);
        return this;
    }

    public <E extends SelectBody> E getSelectBody(Class<E> clazz) {
        return (E)((SelectBody)clazz.cast(this.getSelectBody()));
    }

    public Select addWithItemsList(WithItem ... withItemArray) {
        List list = Optional.ofNullable(this.getWithItemsList()).orElseGet(ArrayList::new);
        Collections.addAll(list, withItemArray);
        return this.withWithItemsList(list);
    }

    public Select addWithItemsList(Collection<? extends WithItem> collection) {
        List list = Optional.ofNullable(this.getWithItemsList()).orElseGet(ArrayList::new);
        list.addAll(collection);
        return this.withWithItemsList(list);
    }
}

