/*
 * Decompiled with CFR 0.152.
 */
package liquibase.repackaged.net.sf.jsqlparser.util.deparser;

import liquibase.repackaged.net.sf.jsqlparser.schema.Table;
import liquibase.repackaged.net.sf.jsqlparser.statement.create.table.ColumnDefinition;
import liquibase.repackaged.net.sf.jsqlparser.statement.create.table.CreateTable;
import liquibase.repackaged.net.sf.jsqlparser.statement.create.table.Index;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.PlainSelect;
import liquibase.repackaged.net.sf.jsqlparser.util.deparser.AbstractDeParser;
import liquibase.repackaged.net.sf.jsqlparser.util.deparser.StatementDeParser;

public class CreateTableDeParser
extends AbstractDeParser<CreateTable> {
    private StatementDeParser statementDeParser;

    public CreateTableDeParser(StringBuilder stringBuilder) {
        super(stringBuilder);
    }

    public CreateTableDeParser(StatementDeParser statementDeParser, StringBuilder stringBuilder) {
        super(stringBuilder);
        this.statementDeParser = statementDeParser;
    }

    @Override
    public void deParse(CreateTable createTable) {
        Object object;
        this.buffer.append("CREATE ");
        if (createTable.isOrReplace()) {
            this.buffer.append("OR REPLACE ");
        }
        if (createTable.isUnlogged()) {
            this.buffer.append("UNLOGGED ");
        }
        if (!"".equals(object = PlainSelect.getStringList(createTable.getCreateOptionsStrings(), false, false))) {
            this.buffer.append((String)object).append(' ');
        }
        this.buffer.append("TABLE ");
        if (createTable.isIfNotExists()) {
            this.buffer.append("IF NOT EXISTS ");
        }
        this.buffer.append(createTable.getTable().getFullyQualifiedName());
        if (createTable.getColumns() != null && !createTable.getColumns().isEmpty()) {
            this.buffer.append(" (");
            object = createTable.getColumns().iterator();
            this.buffer.append(object.next());
            while (object.hasNext()) {
                this.buffer.append(", ").append((String)object.next());
            }
            this.buffer.append(")");
        }
        if (createTable.getColumnDefinitions() != null) {
            Object object2;
            this.buffer.append(" (");
            object = createTable.getColumnDefinitions().iterator();
            while (object.hasNext()) {
                object2 = (ColumnDefinition)((Object)object.next());
                this.buffer.append(((ColumnDefinition)object2).getColumnName());
                this.buffer.append(" ");
                this.buffer.append(((ColumnDefinition)object2).getColDataType().toString());
                if (((ColumnDefinition)object2).getColumnSpecs() != null) {
                    for (String string : ((ColumnDefinition)object2).getColumnSpecs()) {
                        this.buffer.append(" ");
                        this.buffer.append(string);
                    }
                }
                if (!object.hasNext()) continue;
                this.buffer.append(", ");
            }
            if (createTable.getIndexes() != null) {
                object = createTable.getIndexes().iterator();
                while (object.hasNext()) {
                    object2 = (Index)object.next();
                    this.buffer.append(", ");
                    this.buffer.append(((Index)object2).toString());
                }
            }
            this.buffer.append(")");
        }
        if (!"".equals(object = PlainSelect.getStringList(createTable.getTableOptionsStrings(), false, false))) {
            this.buffer.append(' ').append((String)object);
        }
        if (createTable.getRowMovement() != null) {
            this.buffer.append(' ').append(createTable.getRowMovement().getMode().toString()).append(" ROW MOVEMENT");
        }
        if (createTable.getSelect() != null) {
            this.buffer.append(" AS ");
            if (createTable.isSelectParenthesis()) {
                this.buffer.append("(");
            }
            createTable.getSelect().accept(this.statementDeParser);
            if (createTable.isSelectParenthesis()) {
                this.buffer.append(")");
            }
        }
        if (createTable.getLikeTable() != null) {
            this.buffer.append(" LIKE ");
            if (createTable.isSelectParenthesis()) {
                this.buffer.append("(");
            }
            object = createTable.getLikeTable();
            this.buffer.append(((Table)object).getFullyQualifiedName());
            if (createTable.isSelectParenthesis()) {
                this.buffer.append(")");
            }
        }
        if (createTable.getSpannerInterleaveIn() != null) {
            this.buffer.append(", ").append(createTable.getSpannerInterleaveIn());
        }
    }
}

