/*
 * Decompiled with CFR 0.152.
 */
package liquibase.repackaged.net.sf.jsqlparser.util.validation.validator;

import java.util.List;
import liquibase.repackaged.net.sf.jsqlparser.parser.feature.Feature;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.Join;
import liquibase.repackaged.net.sf.jsqlparser.statement.update.Update;
import liquibase.repackaged.net.sf.jsqlparser.util.validation.ValidationCapability;
import liquibase.repackaged.net.sf.jsqlparser.util.validation.validator.AbstractValidator;
import liquibase.repackaged.net.sf.jsqlparser.util.validation.validator.LimitValidator;
import liquibase.repackaged.net.sf.jsqlparser.util.validation.validator.SelectValidator;

public class UpdateValidator
extends AbstractValidator<Update> {
    @Override
    public void validate(Update update) {
        for (ValidationCapability validationCapability : this.getCapabilities()) {
            this.validateFeature(validationCapability, Feature.update);
            this.validateOptionalFeature(validationCapability, update.getFromItem(), Feature.updateFrom);
            this.validateOptionalFeature(validationCapability, update.getStartJoins(), Feature.updateJoins);
            this.validateFeature(validationCapability, update.isUseSelect(), Feature.updateUseSelect);
            this.validateOptionalFeature(validationCapability, update.getOrderByElements(), Feature.updateOrderBy);
            this.validateOptionalFeature(validationCapability, update.getLimit(), Feature.updateLimit);
            this.validateOptionalFeature(validationCapability, update.getReturningExpressionList(), Feature.updateReturning);
        }
        this.validateOptionalFromItem(update.getTable());
        this.validateOptional(update.getStartJoins(), list -> this.getValidator(SelectValidator.class).validateOptionalJoins((List<Join>)list));
        if (update.isUseSelect()) {
            this.validateOptionalExpressions(update.getColumns());
            this.validateOptional(update.getSelect(), select -> select.getSelectBody().accept(this.getValidator(SelectValidator.class)));
        } else {
            this.validateOptionalExpressions(update.getColumns());
            this.validateOptionalExpressions(update.getExpressions());
        }
        if (update.getFromItem() != null) {
            this.validateOptionalFromItem(update.getFromItem());
            this.validateOptional(update.getJoins(), list -> this.getValidator(SelectValidator.class).validateOptionalJoins((List<Join>)list));
        }
        this.validateOptionalExpression(update.getWhere());
        this.validateOptionalOrderByElements(update.getOrderByElements());
        if (update.getLimit() != null) {
            this.getValidator(LimitValidator.class).validate(update.getLimit());
        }
        if (this.isNotEmpty(update.getReturningExpressionList())) {
            SelectValidator selectValidator = this.getValidator(SelectValidator.class);
            update.getReturningExpressionList().forEach(selectItem -> selectItem.accept(selectValidator));
        }
    }
}

