/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.command.checks;

import com.datical.liquibase.ext.checks.config.model.AbstractConfigurableRule;
import com.datical.liquibase.ext.checks.config.model.CheckSettingsConfig;
import com.datical.liquibase.ext.checks.config.model.DynamicRule;
import com.datical.liquibase.ext.checks.config.model.DynamicRuleParameter;
import com.datical.liquibase.ext.checks.output.FormattedChangelogChecksIssue;
import com.datical.liquibase.ext.checks.output.FormattedChangelogChecksResultModel;
import com.datical.liquibase.ext.checks.output.FormattedChangesetValidated;
import com.datical.liquibase.ext.checks.output.FormattedCheckExecuted;
import com.datical.liquibase.ext.checks.output.FormattedCheckParameter;
import com.datical.liquibase.ext.checks.output.FormattedCheckSkipped;
import com.datical.liquibase.ext.checks.output.FormattedCheckUnrecognized;
import com.datical.liquibase.ext.checks.output.FormattedDatabaseChecksIssue;
import com.datical.liquibase.ext.checks.output.FormattedDatabaseChecksResultModel;
import com.datical.liquibase.ext.checks.output.FormattedDatabaseChecksValidated;
import com.datical.liquibase.ext.checks.output.FormattedUnlicensedChangeset;
import com.datical.liquibase.ext.checks.output.FormattedUnparseableChangeset;
import com.datical.liquibase.ext.command.checks.ChecksRunCommandStep;
import com.datical.liquibase.ext.command.checks.ChecksRunConsoleOutputHelper$DatabaseObjectSortComparator;
import com.datical.liquibase.ext.command.checks.ChecksRunConsoleOutputHelper$DatabaseObjectTypeSortComparator;
import com.datical.liquibase.ext.command.checks.EngineResults;
import com.datical.liquibase.ext.command.checks.LazyDatabaseSnapshot;
import com.datical.liquibase.ext.config.LiquibaseLabsConfiguration;
import com.datical.liquibase.ext.rules.api.SeverityEnum;
import com.datical.liquibase.ext.rules.core.AbstractLiquibaseRule;
import com.datical.liquibase.ext.rules.core.LiquibaseQualityCheckResult;
import com.datical.liquibase.ext.rules.core.LiquibaseRuleResult;
import com.datical.liquibase.ext.rules.core.RuleCombination;
import com.datical.liquibase.ext.rules.core.RuleIteration;
import com.datical.liquibase.ext.util.DatabaseObjectUtils;
import java.lang.reflect.Field;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import liquibase.Scope;
import liquibase.changelog.ChangeSet;
import liquibase.exception.CommandExecutionException;
import liquibase.exception.UnexpectedLiquibaseException;
import liquibase.license.LicenseServiceUtils;
import liquibase.structure.DatabaseObject;
import liquibase.structure.DatabaseObjectCollection;
import liquibase.util.LiquibaseUtil;
import liquibase.util.StringUtil;

public class ChecksRunJsonOutputHelper {
    private ChecksRunJsonOutputHelper() {
    }

    public static FormattedChangelogChecksResultModel createChangelogJsonOutput(Map<ChangeSet, LiquibaseQualityCheckResult> map, Set<RuleCombination> set, String string, String string2, CheckSettingsConfig checkSettingsConfig, List<RuleCombination> list, List<AbstractLiquibaseRule> list2) {
        FormattedChangelogChecksResultModel formattedChangelogChecksResultModel = new FormattedChangelogChecksResultModel();
        AtomicReference<SeverityEnum> atomicReference = new AtomicReference<SeverityEnum>(SeverityEnum.INFO);
        if (map == null || map.isEmpty() || string == null) {
            formattedChangelogChecksResultModel.maxSeverity = atomicReference.get();
            return formattedChangelogChecksResultModel;
        }
        formattedChangelogChecksResultModel.username = System.getProperty("user.name");
        formattedChangelogChecksResultModel.productVersion = LiquibaseUtil.getBuildVersionInfo();
        formattedChangelogChecksResultModel.hasProLicense = LicenseServiceUtils.isProLicenseValid();
        formattedChangelogChecksResultModel.integration = string2;
        formattedChangelogChecksResultModel.changelogFilePath = string;
        formattedChangelogChecksResultModel.executionDate = Instant.now().toString();
        formattedChangelogChecksResultModel.changesetsValidatedCount = map.size();
        map.forEach((changeSet, object) -> {
            object = new FormattedChangesetValidated();
            new FormattedChangesetValidated().author = changeSet.getAuthor();
            ((FormattedChangesetValidated)object).id = changeSet.getId();
            ((FormattedChangesetValidated)object).filepath = changeSet.getFilePath();
            formattedChangelogChecksResultModel.changesetsValidated.add((FormattedChangesetValidated)object);
        });
        ChecksRunJsonOutputHelper.processUnparseableChangesets(map, formattedChangelogChecksResultModel, checkSettingsConfig);
        ChecksRunJsonOutputHelper.processUnlicensedChangesets(map, formattedChangelogChecksResultModel, list);
        int n2 = ChecksRunJsonOutputHelper.processExecutedChangelogChecks(set, formattedChangelogChecksResultModel, list2);
        int n3 = ChecksRunJsonOutputHelper.processChangelogIssues(map, formattedChangelogChecksResultModel, atomicReference);
        ChecksRunJsonOutputHelper.processUnrecognizedChangelogRules(formattedChangelogChecksResultModel, checkSettingsConfig);
        formattedChangelogChecksResultModel.issueCount = n3;
        formattedChangelogChecksResultModel.executedChecksCount = n2;
        formattedChangelogChecksResultModel.returnCode = atomicReference.get().getExitValue();
        formattedChangelogChecksResultModel.maxSeverity = atomicReference.get();
        return formattedChangelogChecksResultModel;
    }

    public static FormattedDatabaseChecksResultModel createDatabaseJsonOutput(EngineResults<DatabaseObject> engineResults, String string, LazyDatabaseSnapshot lazyDatabaseSnapshot, boolean bl2, String string2, CheckSettingsConfig checkSettingsConfig) {
        FormattedDatabaseChecksResultModel formattedDatabaseChecksResultModel = new FormattedDatabaseChecksResultModel();
        AtomicReference<SeverityEnum> atomicReference = new AtomicReference<SeverityEnum>(SeverityEnum.INFO);
        LinkedHashMap<DatabaseObject, LiquibaseQualityCheckResult> linkedHashMap = engineResults.getResults();
        if (linkedHashMap == null || linkedHashMap.isEmpty() && engineResults.getSkippedBecauseOfLicenceRules().isEmpty()) {
            formattedDatabaseChecksResultModel.maxSeverity = atomicReference.get();
            return formattedDatabaseChecksResultModel;
        }
        formattedDatabaseChecksResultModel.username = System.getProperty("user.name");
        formattedDatabaseChecksResultModel.productVersion = LiquibaseUtil.getBuildVersionInfo();
        formattedDatabaseChecksResultModel.integration = string2;
        formattedDatabaseChecksResultModel.executionDate = Instant.now().toString();
        formattedDatabaseChecksResultModel.target = string;
        formattedDatabaseChecksResultModel.targetType = string.startsWith("offline:") ? "snapshot" : "jdbcurl";
        formattedDatabaseChecksResultModel.databaseObjectsValidatedCount = ChecksRunJsonOutputHelper.calcSnapshotObjectCount(lazyDatabaseSnapshot);
        formattedDatabaseChecksResultModel.hasLabsLicense = LiquibaseLabsConfiguration.isLabsLicenseValid();
        ChecksRunJsonOutputHelper.processDatabaseChecksValidated(formattedDatabaseChecksResultModel, lazyDatabaseSnapshot, bl2);
        int n2 = ChecksRunJsonOutputHelper.processExecutedDatabaseChecks(linkedHashMap, formattedDatabaseChecksResultModel);
        int n3 = ChecksRunJsonOutputHelper.processDatabaseIssues(linkedHashMap, formattedDatabaseChecksResultModel, atomicReference);
        ChecksRunJsonOutputHelper.processUnrecognizedDatabaseRules(formattedDatabaseChecksResultModel, checkSettingsConfig);
        formattedDatabaseChecksResultModel.issueCount = n3;
        formattedDatabaseChecksResultModel.executedChecksCount = n2;
        formattedDatabaseChecksResultModel.returnCode = atomicReference.get().getExitValue();
        formattedDatabaseChecksResultModel.maxSeverity = atomicReference.get();
        return formattedDatabaseChecksResultModel;
    }

    public static void processDatabaseChecksValidated(FormattedDatabaseChecksResultModel formattedDatabaseChecksResultModel, LazyDatabaseSnapshot lazyDatabaseSnapshot, boolean bl2) {
        try {
            Object object = lazyDatabaseSnapshot.getSnapshot().getSnapshotControl().getTypesToInclude();
            object = new ArrayList(object);
            Collections.sort(object, new ChecksRunConsoleOutputHelper$DatabaseObjectTypeSortComparator());
            object = object.iterator();
            while (object.hasNext()) {
                Object object2 = (Class)object.next();
                Object object3 = lazyDatabaseSnapshot.getSnapshot().get((Class)object2);
                if (object3.isEmpty()) continue;
                object2 = ((Class)object2).getSimpleName();
                FormattedDatabaseChecksValidated formattedDatabaseChecksValidated = new FormattedDatabaseChecksValidated();
                new FormattedDatabaseChecksValidated().objecttype = StringUtil.upperCaseFirst((String)object2);
                formattedDatabaseChecksValidated.count = object3.size();
                if (bl2) {
                    object2 = lazyDatabaseSnapshot.getDatabase();
                    object3 = new ArrayList(object3);
                    Collections.sort(object3, new ChecksRunConsoleOutputHelper$DatabaseObjectSortComparator());
                    object3 = object3.iterator();
                    while (object3.hasNext()) {
                        DatabaseObject databaseObject = (DatabaseObject)object3.next();
                        if (object2.isLiquibaseObject(databaseObject)) {
                            --formattedDatabaseChecksValidated.count;
                            continue;
                        }
                        formattedDatabaseChecksValidated.objects.add(DatabaseObjectUtils.buildFullyQualifiedName(databaseObject));
                    }
                }
                formattedDatabaseChecksResultModel.databaseObjectsValidated.add(formattedDatabaseChecksValidated);
            }
            return;
        }
        catch (CommandExecutionException commandExecutionException) {
            throw new UnexpectedLiquibaseException((Throwable)commandExecutionException);
        }
    }

    private static int calcSnapshotObjectCount(LazyDatabaseSnapshot lazyDatabaseSnapshot) {
        try {
            lazyDatabaseSnapshot = lazyDatabaseSnapshot.getSnapshot();
        }
        catch (CommandExecutionException commandExecutionException) {
            Scope.getCurrentScope().getLog(ChecksRunJsonOutputHelper.class).warning("Unable to get snapshot count of database objects: " + commandExecutionException.getMessage());
            return 0;
        }
        int n2 = 0;
        lazyDatabaseSnapshot = (DatabaseObjectCollection)lazyDatabaseSnapshot.getSerializableFieldValue("objects");
        for (Class clazz : lazyDatabaseSnapshot.toMap().keySet()) {
            n2 += lazyDatabaseSnapshot.get(clazz).size();
        }
        return n2;
    }

    private static void processUnlicensedChangesets(Map<ChangeSet, LiquibaseQualityCheckResult> object, FormattedChangelogChecksResultModel formattedChangelogChecksResultModel, List<RuleCombination> list) {
        object = ChecksRunJsonOutputHelper.getUnlicensedChangeSetResults((Map<ChangeSet, LiquibaseQualityCheckResult>)object, list);
        formattedChangelogChecksResultModel.unlicensedChangesetsCount = object.size();
        for (Map.Entry entry : object.entrySet()) {
            ChangeSet changeSet = (ChangeSet)entry.getKey();
            entry.getValue();
            FormattedUnlicensedChangeset object2 = new FormattedUnlicensedChangeset();
            new FormattedUnlicensedChangeset().changesetId = changeSet.getId();
            for (RuleCombination ruleCombination : list) {
                FormattedCheckSkipped formattedCheckSkipped = new FormattedCheckSkipped();
                String string = ruleCombination.rule.getName();
                String string2 = null;
                if (ruleCombination.rule instanceof DynamicRule) {
                    string2 = ((DynamicRule)ruleCombination.configurableRule).getShortName();
                }
                formattedCheckSkipped.checkName = string;
                formattedCheckSkipped.checkShortName = string2 != null ? string2.replaceAll("\\(", "").replaceAll("\\)", "").trim() : null;
                object2.skipped.add(formattedCheckSkipped);
            }
            formattedChangelogChecksResultModel.unlicensedChangesets.add(object2);
        }
    }

    private static void processUnrecognizedDatabaseRules(FormattedDatabaseChecksResultModel formattedDatabaseChecksResultModel, CheckSettingsConfig object) {
        for (AbstractConfigurableRule abstractConfigurableRule : ((CheckSettingsConfig)object).getUnrecognizedRules()) {
            FormattedCheckUnrecognized formattedCheckUnrecognized = new FormattedCheckUnrecognized();
            if (abstractConfigurableRule.isConfigurable()) {
                formattedCheckUnrecognized.checkShortName = ((DynamicRule)abstractConfigurableRule).getShortName();
                formattedCheckUnrecognized.checkShortName = formattedCheckUnrecognized.checkShortName != null ? formattedCheckUnrecognized.checkShortName.replaceAll("\\(", "").replaceAll("\\)", "").trim() : null;
            }
            formattedCheckUnrecognized.checkId = abstractConfigurableRule.getId().toString();
            formattedDatabaseChecksResultModel.unrecognizedChecks.add(formattedCheckUnrecognized);
        }
    }

    private static void processUnrecognizedChangelogRules(FormattedChangelogChecksResultModel formattedChangelogChecksResultModel, CheckSettingsConfig object) {
        for (AbstractConfigurableRule abstractConfigurableRule : ((CheckSettingsConfig)object).getUnrecognizedRules()) {
            FormattedCheckUnrecognized formattedCheckUnrecognized = new FormattedCheckUnrecognized();
            if (abstractConfigurableRule.isConfigurable()) {
                formattedCheckUnrecognized.checkShortName = ((DynamicRule)abstractConfigurableRule).getShortName();
                formattedCheckUnrecognized.checkShortName = formattedCheckUnrecognized.checkShortName != null ? formattedCheckUnrecognized.checkShortName.replaceAll("\\(", "").replaceAll("\\)", "").trim() : null;
            }
            formattedCheckUnrecognized.checkId = abstractConfigurableRule.getId().toString();
            formattedChangelogChecksResultModel.unrecognizedChecks.add(formattedCheckUnrecognized);
        }
    }

    private static int processDatabaseIssues(Map<DatabaseObject, LiquibaseQualityCheckResult> object, FormattedDatabaseChecksResultModel formattedDatabaseChecksResultModel, AtomicReference<SeverityEnum> atomicReference) {
        int n2 = 0;
        for (Map.Entry entry : object.entrySet()) {
            DatabaseObject databaseObject = (DatabaseObject)entry.getKey();
            for (LiquibaseRuleResult liquibaseRuleResult : ((LiquibaseQualityCheckResult)entry.getValue()).getRuleResults()) {
                if (liquibaseRuleResult.hasRuleSucceeded()) continue;
                for (RuleIteration ruleIteration : liquibaseRuleResult.getExecutions()) {
                    ++n2;
                    FormattedDatabaseChecksIssue formattedDatabaseChecksIssue = new FormattedDatabaseChecksIssue();
                    new FormattedDatabaseChecksIssue().databaseObjectName = databaseObject.getName();
                    formattedDatabaseChecksIssue.databaseObjectType = databaseObject.getObjectTypeName();
                    formattedDatabaseChecksIssue.databaseObjectLocation = DatabaseObjectUtils.buildFullyQualifiedName(databaseObject);
                    formattedDatabaseChecksIssue.checkName = liquibaseRuleResult.getRule().getName();
                    formattedDatabaseChecksIssue.checkSeverity = liquibaseRuleResult.getRuleSeverity().toString();
                    formattedDatabaseChecksIssue.checkReturnCode = liquibaseRuleResult.getRuleExitValue();
                    String string = liquibaseRuleResult.getRuleShortName().replaceAll("\\(", "").replaceAll("\\)", "").trim();
                    SeverityEnum severityEnum = liquibaseRuleResult.getRuleSeverity();
                    if (severityEnum.getValue() > atomicReference.get().getValue()) {
                        atomicReference.set(severityEnum);
                    }
                    formattedDatabaseChecksIssue.checkShortName = string = string != null ? string.replaceAll("\\(", "").replaceAll("\\)", "").trim() : null;
                    formattedDatabaseChecksIssue.checkMessage = StringUtil.join(ruleIteration.getMessages(), (String)",");
                    formattedDatabaseChecksResultModel.issues.add(formattedDatabaseChecksIssue);
                }
            }
        }
        return n2;
    }

    private static int processChangelogIssues(Map<ChangeSet, LiquibaseQualityCheckResult> object, FormattedChangelogChecksResultModel formattedChangelogChecksResultModel, AtomicReference<SeverityEnum> atomicReference) {
        int n2 = 0;
        for (Map.Entry entry : object.entrySet()) {
            ChangeSet changeSet = (ChangeSet)entry.getKey();
            for (LiquibaseRuleResult liquibaseRuleResult : ((LiquibaseQualityCheckResult)entry.getValue()).getRuleResults()) {
                if (liquibaseRuleResult.hasRuleSucceeded()) continue;
                for (RuleIteration ruleIteration : liquibaseRuleResult.getExecutions()) {
                    if (ruleIteration.isSuccess() || ruleIteration.getMessages().isEmpty()) continue;
                    ++n2;
                    FormattedChangelogChecksIssue formattedChangelogChecksIssue = new FormattedChangelogChecksIssue();
                    new FormattedChangelogChecksIssue().changesetAuthor = changeSet.getAuthor();
                    formattedChangelogChecksIssue.changesetId = changeSet.getId();
                    formattedChangelogChecksIssue.changesetFilePath = changeSet.getFilePath();
                    formattedChangelogChecksIssue.checkName = liquibaseRuleResult.getRule().getName();
                    SeverityEnum severityEnum = liquibaseRuleResult.getRuleSeverity();
                    formattedChangelogChecksIssue.checkSeverity = severityEnum.toString();
                    formattedChangelogChecksIssue.checkReturnCode = severityEnum.getExitValue();
                    String string = liquibaseRuleResult.getRuleShortName().replaceAll("\\(", "").replaceAll("\\)", "").trim();
                    if (severityEnum.getValue() > atomicReference.get().getValue()) {
                        atomicReference.set(severityEnum);
                    }
                    formattedChangelogChecksIssue.checkShortName = string = string != null ? string.replaceAll("\\(", "").replaceAll("\\)", "").trim() : null;
                    formattedChangelogChecksIssue.checkMessage = StringUtil.join(ruleIteration.getMessages(), (String)",");
                    formattedChangelogChecksResultModel.issues.add(formattedChangelogChecksIssue);
                }
            }
        }
        return n2;
    }

    private static int processExecutedDatabaseChecks(Map<DatabaseObject, LiquibaseQualityCheckResult> map, FormattedDatabaseChecksResultModel formattedDatabaseChecksResultModel) {
        LinkedHashSet linkedHashSet = new LinkedHashSet();
        map.forEach((object, object22) -> {
            for (LiquibaseRuleResult liquibaseRuleResult : ((LiquibaseQualityCheckResult)object22).getRuleResults()) {
                if (linkedHashSet.contains(liquibaseRuleResult.getRuleShortName())) continue;
                linkedHashSet.add(liquibaseRuleResult.getRuleShortName());
                FormattedCheckExecuted formattedCheckExecuted = new FormattedCheckExecuted();
                new FormattedCheckExecuted().checkName = liquibaseRuleResult.getRule().getName();
                formattedCheckExecuted.checkShortName = liquibaseRuleResult.getRuleShortName().replaceAll("\\(", "").replaceAll("\\)", "").trim();
                formattedCheckExecuted.description = liquibaseRuleResult.getRule().getDescription();
                formattedCheckExecuted.severity = liquibaseRuleResult.getRuleSeverity().toString();
                formattedCheckExecuted.enabled = true;
                if (liquibaseRuleResult.getDynamicRule() != null) {
                    DynamicRule dynamicRule = liquibaseRuleResult.getDynamicRule();
                    formattedCheckExecuted.enabled = dynamicRule.isEnabled();
                    FormattedCheckParameter formattedCheckParameter = new FormattedCheckParameter();
                    dynamicRule.getParameters().forEach(dynamicRuleParameter -> ChecksRunJsonOutputHelper.setParamValueInModel(formattedCheckParameter, dynamicRuleParameter));
                    formattedCheckExecuted.customizations.add(formattedCheckParameter);
                }
                formattedDatabaseChecksResultModel.executedChecks.add(formattedCheckExecuted);
            }
        });
        return linkedHashSet.size();
    }

    private static int processExecutedChangelogChecks(Set<RuleCombination> set, FormattedChangelogChecksResultModel formattedChangelogChecksResultModel, List<AbstractLiquibaseRule> list) {
        for (RuleCombination ruleCombination : set) {
            Object object = ruleCombination.rule;
            AbstractConfigurableRule abstractConfigurableRule = ruleCombination.configurableRule;
            FormattedCheckExecuted formattedCheckExecuted = new FormattedCheckExecuted();
            new FormattedCheckExecuted().checkName = object.getName();
            formattedCheckExecuted.checkShortName = abstractConfigurableRule.getShortName(list);
            formattedCheckExecuted.description = object.getDescription();
            formattedCheckExecuted.severity = Integer.toString(abstractConfigurableRule.getSeverity().getExitValue());
            formattedCheckExecuted.enabled = true;
            if (abstractConfigurableRule instanceof DynamicRule) {
                DynamicRule dynamicRule = (DynamicRule)abstractConfigurableRule;
                formattedCheckExecuted.enabled = dynamicRule.isEnabled();
                object = new FormattedCheckParameter();
                dynamicRule.getParameters().forEach(arg_0 -> ChecksRunJsonOutputHelper.lambda$processExecutedChangelogChecks$3((FormattedCheckParameter)((Object)object), arg_0));
                formattedCheckExecuted.customizations.add((FormattedCheckParameter)((Object)object));
            }
            formattedChangelogChecksResultModel.executedChecks.add(formattedCheckExecuted);
        }
        return set.size();
    }

    private static void processUnparseableChangesets(Map<ChangeSet, LiquibaseQualityCheckResult> object, FormattedChangelogChecksResultModel formattedChangelogChecksResultModel, CheckSettingsConfig checkSettingsConfig) {
        object = ChecksRunJsonOutputHelper.getUnparseableChangeSetResultsWithoutMessage((Map<ChangeSet, LiquibaseQualityCheckResult>)object);
        formattedChangelogChecksResultModel.unparseableChangesetsCount = object.size();
        for (Map.Entry entry : object.entrySet()) {
            Object object22 = (ChangeSet)entry.getKey();
            LiquibaseQualityCheckResult liquibaseQualityCheckResult = (LiquibaseQualityCheckResult)entry.getValue();
            FormattedUnparseableChangeset formattedUnparseableChangeset = new FormattedUnparseableChangeset();
            new FormattedUnparseableChangeset().changesetId = object22.getId();
            for (Object object22 : liquibaseQualityCheckResult.getSkippedBecauseOfExceptionRuleNames()) {
                FormattedCheckSkipped formattedCheckSkipped = new FormattedCheckSkipped();
                new FormattedCheckSkipped().checkShortName = object22 != null ? object22 : "";
                object22 = checkSettingsConfig.getDynamicRuleByShortName((String)object22);
                formattedCheckSkipped.checkName = object22 != null ? ((DynamicRule)object22).getName() : "";
                formattedUnparseableChangeset.skipped.add(formattedCheckSkipped);
            }
            formattedChangelogChecksResultModel.unparseableChangesets.add(formattedUnparseableChangeset);
        }
    }

    private static void setParamValueInModel(FormattedCheckParameter formattedCheckParameter, DynamicRuleParameter dynamicRuleParameter) {
        Object object = dynamicRuleParameter.getParameter();
        object = Arrays.stream(FormattedCheckParameter.class.getFields()).filter(arg_0 -> ChecksRunJsonOutputHelper.lambda$setParamValueInModel$4((String)object, arg_0)).findFirst().orElse(null);
        if (object != null) {
            try {
                ((Field)object).set((Object)formattedCheckParameter, dynamicRuleParameter.getValue());
                return;
            }
            catch (Exception exception) {
                Scope.getCurrentScope().getLog(ChecksRunCommandStep.class).warning("Unable to set parameter value for " + ((Field)object).getName());
            }
        }
    }

    private static Map<ChangeSet, LiquibaseQualityCheckResult> getUnparseableChangeSetResultsWithoutMessage(Map<ChangeSet, LiquibaseQualityCheckResult> map) {
        return map.entrySet().stream().filter(entry -> !((LiquibaseQualityCheckResult)entry.getValue()).getSkippedBecauseOfExceptionRuleNames().isEmpty()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (liquibaseQualityCheckResult, liquibaseQualityCheckResult2) -> liquibaseQualityCheckResult2, LinkedHashMap::new));
    }

    private static Map<ChangeSet, LiquibaseQualityCheckResult> getUnlicensedChangeSetResults(Map<ChangeSet, LiquibaseQualityCheckResult> map, List<RuleCombination> list) {
        return map.entrySet().stream().filter(entry -> !list.isEmpty()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (liquibaseQualityCheckResult, liquibaseQualityCheckResult2) -> liquibaseQualityCheckResult2, LinkedHashMap::new));
    }

    private static /* synthetic */ boolean lambda$setParamValueInModel$4(String string, Field field) {
        return field.getName().equalsIgnoreCase(string.replace("_", ""));
    }

    private static /* synthetic */ void lambda$processExecutedChangelogChecks$3(FormattedCheckParameter formattedCheckParameter, DynamicRuleParameter dynamicRuleParameter) {
        ChecksRunJsonOutputHelper.setParamValueInModel(formattedCheckParameter, dynamicRuleParameter);
    }
}

