/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.flow.file;

import com.datical.liquibase.ext.flow.action.Action;
import com.datical.liquibase.ext.flow.condition.Condition;
import com.datical.liquibase.ext.flow.file.FlowFile;
import com.datical.liquibase.ext.flow.file.FlowFileDTO;
import com.datical.liquibase.ext.flow.file.FlowFileLoad;
import com.datical.liquibase.ext.flow.file.FlowFileYaml;
import com.datical.liquibase.ext.flow.file.FlowVariableExpander;
import com.datical.liquibase.ext.flow.file.Stage;
import com.datical.liquibase.ext.flow.file.StageDTO;
import com.datical.liquibase.ext.util.ResourceUtil;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.stream.Collectors;
import liquibase.Scope;
import liquibase.exception.CommandExecutionException;
import liquibase.exception.UnexpectedLiquibaseException;
import liquibase.resource.OpenOptions;
import liquibase.resource.PathHandlerFactory;
import liquibase.resource.Resource;
import liquibase.util.CollectionUtil;
import liquibase.util.StreamUtil;
import liquibase.util.StringUtil;
import org.yaml.snakeyaml.Yaml;

public class FlowFileHelper {
    private static final FlowFileYaml ffy = new FlowFileYaml();
    private static final Map<String, Action> cachedActions = Scope.getCurrentScope().getServiceLocator().findInstances(Action.class).stream().collect(Collectors.toMap(Action::getType, action -> action));

    private FlowFileHelper() {
    }

    public static FlowFileLoad load(String object, boolean bl2) {
        block12: {
            FlowFileLoad flowFileLoad = new FlowFileLoad();
            Object object2 = (PathHandlerFactory)Scope.getCurrentScope().getSingleton(PathHandlerFactory.class);
            InputStream inputStream = null;
            if (ResourceUtil.isAbsolute((String)object)) {
                object2 = object2.getResource((String)object);
                flowFileLoad.resource = object2;
                if (object2.exists()) {
                    inputStream = object2.openInputStream();
                }
            } else {
                object2 = ResourceUtil.getResource((String)object);
                flowFileLoad.resource = object2;
                inputStream = ResourceUtil.getResourceInputStream((Resource)object2);
            }
            try {
                if (inputStream == null) {
                    throw new FileNotFoundException((String)object + " does not exist.");
                }
                ffy.setSkipMissingProperties(bl2);
                object2 = StreamUtil.readStreamAsString((InputStream)inputStream);
                if (StringUtil.isEmpty((String)object2)) {
                    throw new CommandExecutionException(String.format("Flow file %s contents are empty", object));
                }
                object = (FlowFileDTO)ffy.load((String)object2);
                flowFileLoad.flowFile = FlowFileHelper.load((FlowFileDTO)object);
                FlowFileHelper.addIncludeFiles(flowFileLoad, (FlowFileDTO)object);
                flowFileLoad.globalVariables = ((FlowFileDTO)object).getGlobalVariables();
                object = flowFileLoad;
                if (inputStream == null) break block12;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        inputStream.close();
                    }
                    throw throwable;
                }
                catch (IOException iOException) {
                    throw iOException;
                }
                catch (Exception exception) {
                    throw new IOException(exception);
                }
            }
            inputStream.close();
        }
        return object;
    }

    private static void addIncludeFiles(FlowFileLoad flowFileLoad, FlowFileDTO object) {
        if (((FlowFileDTO)((Object)object)).getInclude() == null) {
            return;
        }
        for (Map.Entry<String, String> entry : ((FlowFileDTO)((Object)object)).getInclude().entrySet()) {
            String string = entry.getKey();
            Resource entry2 = ResourceUtil.getResource(entry.getValue());
            if (flowFileLoad.includes == null) {
                flowFileLoad.includes = new LinkedHashMap<String, Resource>();
            }
            flowFileLoad.includes.put(string, entry2);
        }
    }

    public static Resource determineResource(String string) {
        PathHandlerFactory pathHandlerFactory = (PathHandlerFactory)Scope.getCurrentScope().getSingleton(PathHandlerFactory.class);
        string = ResourceUtil.isAbsolute(string) ? pathHandlerFactory.getResource(string) : ResourceUtil.getResource(string);
        return string;
    }

    public static boolean exists(String string) {
        try {
            return ResourceUtil.getResource(string).exists();
        }
        catch (IOException iOException) {
            throw new UnexpectedLiquibaseException(iOException.getMessage(), (Throwable)iOException);
        }
    }

    public static FlowFile load(FlowFileDTO flowFileDTO) {
        FlowFile flowFile = new FlowFile();
        flowFile.setGlobalVariables(flowFileDTO.getGlobalVariables());
        flowFile.setIncludedVariables(FlowFileHelper.getIncludedVariables(flowFileDTO.getInclude()));
        if (flowFileDTO.getStages() != null) {
            Iterator<Map.Entry<String, StageDTO>> iterator = flowFileDTO.getStages().entrySet().iterator();
            while (iterator.hasNext()) {
                FlowFileHelper.processStage(iterator.next(), flowFile);
            }
        }
        flowFile.setEndStage(FlowFileHelper.processStage(flowFileDTO.getEndStage(), flowFile.getAllVariables()));
        return flowFile;
    }

    private static LinkedHashMap<String, Object> getIncludedVariables(LinkedHashMap<String, String> object) {
        if (object == null) {
            return null;
        }
        LinkedHashMap<String, Object> linkedHashMap = new LinkedHashMap<String, Object>();
        Yaml yaml = new Yaml();
        for (Map.Entry entry : ((LinkedHashMap)((Object)object)).entrySet()) {
            try {
                String string = (String)entry.getKey();
                String string2 = (String)entry.getValue();
                if (!FlowFileHelper.exists(string2)) {
                    throw new FileNotFoundException("Included file not found ".concat(String.valueOf(string2)));
                }
                Object object22 = StreamUtil.readStreamAsString((InputStream)ResourceUtil.getResource(string2).openInputStream());
                if (StringUtil.isEmpty((String)object22)) {
                    throw new CommandExecutionException("Included file " + string2 + " is empty");
                }
                for (Object object22 : ((Map)yaml.load((String)object22)).entrySet()) {
                    Object v2 = object22.getValue();
                    object22 = (String)object22.getKey();
                    linkedHashMap.put(string + "." + (String)object22, v2);
                }
            }
            catch (Exception exception) {
                String string = String.format("Error during setup: %s", exception.getMessage());
                Scope.getCurrentScope().getUI().sendMessage(string);
                Scope.getCurrentScope().getLog(FlowFileHelper.class).severe(string, (Throwable)exception);
            }
        }
        return linkedHashMap;
    }

    public static String createDefaultFlowFile(String string) {
        String string2 = string;
        return FlowFileHelper.createDefaultFlowFile(string2, string2);
    }

    public static String createDefaultFlowFile(String object, String string) {
        block26: {
            Object object2 = (PathHandlerFactory)Scope.getCurrentScope().getSingleton(PathHandlerFactory.class);
            if (object2.getResource(string).exists()) {
                throw new IOException("The specified file " + string + " already exists.");
            }
            Throwable throwable = null;
            try (InputStream inputStream = FlowFileHelper.class.getClassLoader().getResourceAsStream("liquibase/flow/".concat(String.valueOf(object)));){
                if (inputStream != null) {
                    object = StreamUtil.readStreamAsString((InputStream)inputStream);
                    object2 = object2.createResource(string);
                    Throwable throwable2 = null;
                    try {
                        ((OutputStream)object2).write(((String)object).getBytes());
                        break block26;
                    }
                    catch (Throwable throwable3) {
                        object = throwable3;
                        throwable2 = throwable3;
                        throw object;
                    }
                    finally {
                        if (object2 != null) {
                            if (throwable2 != null) {
                                try {
                                    ((OutputStream)object2).close();
                                }
                                catch (Throwable throwable4) {
                                    throwable2.addSuppressed(throwable4);
                                }
                            } else {
                                ((OutputStream)object2).close();
                            }
                        }
                    }
                }
                throw new FileNotFoundException("Flow file " + (String)object + " provided by Liquibase cannot be located.");
            }
            catch (Throwable throwable5) {
                object = throwable5;
                throwable = throwable5;
                throw object;
            }
        }
        return string;
    }

    public static String createDefaultFlowFileAtPath(String string, String string2) {
        Object object = (PathHandlerFactory)Scope.getCurrentScope().getSingleton(PathHandlerFactory.class);
        Throwable throwable = null;
        try (InputStream inputStream = FlowFileHelper.class.getClassLoader().getResourceAsStream("liquibase/flow/".concat(String.valueOf(string)));){
            Object object2;
            if (inputStream != null) {
                object2 = StreamUtil.readStreamAsString((InputStream)inputStream);
                if ((object = object.getResource(string2).resolve(string)).exists()) {
                    throw new IOException("The specified file " + object.getPath() + " already exists.");
                }
                object = object.openOutputStream(new OpenOptions());
                Throwable throwable2 = null;
                try {
                    ((OutputStream)object).write(((String)object2).getBytes());
                }
                catch (Throwable throwable3) {
                    object2 = throwable3;
                    throwable2 = throwable3;
                    throw object2;
                }
                finally {
                    if (object != null) {
                        if (throwable2 != null) {
                            try {
                                ((OutputStream)object).close();
                            }
                            catch (Throwable throwable4) {
                                throwable2.addSuppressed(throwable4);
                            }
                        } else {
                            ((OutputStream)object).close();
                        }
                    }
                }
                if (string2.endsWith("/")) {
                    object = string2 + string;
                    return object;
                }
                object = string2 + "/" + string;
                return object;
            }
            try {
                throw new FileNotFoundException("Flow file " + string + " provided by Liquibase cannot be located.");
            }
            catch (Throwable throwable5) {
                object2 = throwable5;
                throwable = throwable5;
                throw object2;
            }
        }
    }

    private static Stage processStage(StageDTO stageDTO, LinkedHashMap<String, Object> linkedHashMap) {
        if (stageDTO == null) {
            return null;
        }
        Stage stage = new Stage();
        for (Map map : CollectionUtil.createIfNull(stageDTO.getActions())) {
            stage.getActions().add(FlowFileHelper.generateAction(map, linkedHashMap));
        }
        stage.setGlobalArgs(FlowVariableExpander.expandVariables(stageDTO.getGlobalArgs(), linkedHashMap));
        if (StringUtil.isNotEmpty((String)stageDTO.getCondition())) {
            stage.setCondition(Condition.fromString(stageDTO.getCondition(), linkedHashMap));
        }
        stage.getVariables().putAll(stageDTO.getStageVariables());
        return stage;
    }

    private static void processStage(Map.Entry<String, StageDTO> object, FlowFile flowFile) {
        Object object2;
        LinkedHashMap<String, Object> linkedHashMap = flowFile.getAllVariables();
        StageDTO stageDTO = object.getValue();
        if (stageDTO != null) {
            object2 = stageDTO.getStageVariables();
            if (linkedHashMap != null && object2 != null) {
                linkedHashMap.putAll((Map<String, Object>)object2);
            }
        }
        object2 = FlowFileHelper.processStage(stageDTO, linkedHashMap);
        object = object.getKey();
        flowFile.getStages().put((String)object, (Stage)object2);
    }

    private static Action generateAction(Map<String, Object> map, Map<String, Object> map2) {
        Action action;
        Object object = map.containsKey("type") ? (String)map.get("type") : "liquibase";
        if (StringUtil.isEmpty((String)object)) {
            object = "liquibase";
        }
        if ((action = FlowFileHelper.findAction((String)object)) == null) {
            throw new UnexpectedLiquibaseException("Unable to locate action '" + (String)object + "'");
        }
        object = action.fromAction(map, map2);
        ((Action)object).setCondition(map, map2);
        return object;
    }

    private static Action findAction(String string) {
        return FlowFileHelper.findAllActions().get(string);
    }

    private static Map<String, Action> findAllActions() {
        return cachedActions;
    }
}

