/*
 * Decompiled with CFR 0.152.
 */
package liquibase.repackaged.net.sf.jsqlparser.statement;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import liquibase.repackaged.net.sf.jsqlparser.statement.Block;
import liquibase.repackaged.net.sf.jsqlparser.statement.IfElseStatement;
import liquibase.repackaged.net.sf.jsqlparser.statement.Statement;
import liquibase.repackaged.net.sf.jsqlparser.statement.StatementVisitor;

public class Statements
implements Serializable {
    private List<Statement> statements;

    public List<Statement> getStatements() {
        return this.statements;
    }

    public void setStatements(List<Statement> list) {
        this.statements = list;
    }

    public void accept(StatementVisitor statementVisitor) {
        statementVisitor.visit(this);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        for (Statement statement : this.statements) {
            if (statement instanceof IfElseStatement || statement instanceof Block) {
                stringBuilder.append(statement).append("\n");
                continue;
            }
            stringBuilder.append(statement).append(";\n");
        }
        return stringBuilder.toString();
    }

    public Statements withStatements(List<Statement> list) {
        this.setStatements(list);
        return this;
    }

    public Statements addStatements(Statement ... statementArray) {
        List list = Optional.ofNullable(this.getStatements()).orElseGet(ArrayList::new);
        Collections.addAll(list, statementArray);
        return this.withStatements(list);
    }

    public Statements addStatements(Collection<? extends Statement> collection) {
        List list = Optional.ofNullable(this.getStatements()).orElseGet(ArrayList::new);
        list.addAll(collection);
        return this.withStatements(list);
    }
}

